/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="MATH_SIGNUM")
public final class AArch64MathSignumOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64MathSignumOp> TYPE = LIRInstructionClass.create(AArch64MathSignumOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value result;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value scratch;

    public AArch64MathSignumOp(LIRGeneratorTool tool, Value result, AllocatableValue input) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.input = input;
        this.scratch = tool.newVariable(LIRKind.value(input.getPlatformKind()));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        Register inputReg = ValueUtil.asRegister((Value)this.input);
        Register floatScratch = ValueUtil.asRegister((Value)this.scratch);
        int size = this.result.getPlatformKind().getSizeInBytes() * 8;
        masm.fmov(size, floatScratch, 0.0);
        masm.neon.facgtSSS(AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind()), resultReg, inputReg, floatScratch);
        masm.neon.ushrSSI(AArch64ASIMDAssembler.ElementSize.DoubleWord, resultReg, resultReg, 1);
        masm.fmov(size, floatScratch, 1.0);
        masm.neon.bslVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, resultReg, floatScratch, inputReg);
    }
}

