/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@StubPort(path="src/hotspot/cpu/aarch64/aarch64.ad", lineStart=9713, lineEnd=9795, commit="afda8fbf0bcea18cbe741e9c693789ebe0c6c4c5", sha1="2c84fcc18cc8084cf12c4832a52c7b0c0e80248e")
public class AArch64NormalizedUnsignedCompareOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64NormalizedUnsignedCompareOp> TYPE = LIRInstructionClass.create(AArch64NormalizedUnsignedCompareOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue x;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue y;

    public AArch64NormalizedUnsignedCompareOp(AllocatableValue result, AllocatableValue x, AllocatableValue y) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.x = x;
        this.y = y;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        if (this.x.getPlatformKind() == AArch64Kind.DWORD) {
            masm.cmp(32, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
        } else {
            GraalError.guarantee(this.x.getPlatformKind() == AArch64Kind.QWORD, "unsupported value kind %s", (Object)this.x.getPlatformKind());
            masm.cmp(64, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
        }
        masm.cset(32, ValueUtil.asRegister((Value)this.result), AArch64Assembler.ConditionFlag.NE);
        masm.csneg(32, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), AArch64Assembler.ConditionFlag.HI);
    }
}

