/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra.ssa;

import java.util.BitSet;
import java.util.EnumSet;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanLifetimeAnalysisPhase;
import org.graalvm.compiler.lir.ssa.SSAUtil;

public class SSALinearScanLifetimeAnalysisPhase
extends LinearScanLifetimeAnalysisPhase {
    SSALinearScanLifetimeAnalysisPhase(LinearScan linearScan) {
        super(linearScan);
    }

    @Override
    protected void addRegisterHint(LIRInstruction op, Value targetValue, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags, boolean hintAtDef) {
        super.addRegisterHint(op, targetValue, mode, flags, hintAtDef);
        if (hintAtDef && op instanceof StandardOp.LabelOp) {
            StandardOp.LabelOp label = (StandardOp.LabelOp)op;
            if (!label.isPhiIn()) {
                return;
            }
            Interval to = this.allocator.getOrCreateInterval((AllocatableValue)targetValue);
            LIR lir = this.allocator.getLIR();
            BasicBlock<?> block = this.allocator.blockForId(label.id());
            assert (mode == LIRInstruction.OperandMode.DEF) : "Wrong operand mode: " + mode;
            assert (lir.getLIRforBlock(block).get(0).equals(label)) : String.format("Block %s and Label %s do not match!", block, label);
            int idx = SSAUtil.indexOfValue(label, targetValue);
            assert (idx >= 0) : String.format("Value %s not in label %s", targetValue, label);
            BitSet blockLiveIn = this.allocator.getBlockData(block).liveIn;
            BasicBlock<Object> selectedPredecessor = null;
            AllocatableValue selectedSource = null;
            for (int i = 0; i < block.getPredecessorCount(); ++i) {
                StandardOp.JumpOp jump;
                Value sourceValue;
                Object pred = block.getPredecessorAt(i);
                if (selectedPredecessor != null && !(((BasicBlock)pred).getRelativeFrequency() > selectedPredecessor.getRelativeFrequency()) || !LinearScan.isVariableOrRegister(sourceValue = (jump = SSAUtil.phiOut(lir, pred)).getOutgoingValue(idx)) || blockLiveIn.get(this.getOperandNumber(sourceValue))) continue;
                selectedSource = (AllocatableValue)sourceValue;
                selectedPredecessor = pred;
            }
            if (selectedSource != null) {
                Interval from = this.allocator.getOrCreateInterval(selectedSource);
                SSALinearScanLifetimeAnalysisPhase.setHint(this.debug, op, to, from);
                SSALinearScanLifetimeAnalysisPhase.setHint(this.debug, op, from, to);
            }
        }
    }

    public static void setHint(DebugContext debug, LIRInstruction op, Interval target, Interval source) {
        Interval currentHint = target.locationHint(false);
        if (currentHint == null || currentHint.from() > target.from()) {
            target.setLocationHint(source);
            if (debug.isLogEnabled()) {
                debug.log("operation at opId %d: added hint from interval %d to %d", op.id(), source.operandNumber, target.operandNumber);
            }
        }
    }

    @Override
    protected Interval.RegisterPriority registerPriorityOfOutputOperand(LIRInstruction op) {
        StandardOp.LabelOp label;
        if (op instanceof StandardOp.LabelOp && (label = (StandardOp.LabelOp)op).isPhiIn()) {
            return Interval.RegisterPriority.None;
        }
        return super.registerPriorityOfOutputOperand(op);
    }
}

