/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import java.util.function.BiConsumer;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.amd64.AMD64AESEncryptOp;
import org.graalvm.compiler.lir.amd64.AMD64CounterModeAESCryptOp;
import org.graalvm.compiler.lir.amd64.AMD64HotSpotHelper;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@StubPort(path="src/hotspot/cpu/x86/stubGenerator_x86_64_aes.cpp", lineStart=1245, lineEnd=1501, commit="4a300818fe7a47932c5b762ccd3b948815a31974", sha1="eeac176914c5c7d0fc7ede271a29b937c31470b9")
public final class AMD64CipherBlockChainingAESDecryptOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64CipherBlockChainingAESDecryptOp> TYPE = LIRInstructionClass.create(AMD64CipherBlockChainingAESDecryptOp.class);
    private final int lengthOffset;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value fromValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value toValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value keyValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value rvecValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value lenValue;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value resultValue;
    @LIRInstruction.Temp
    protected Value[] temps;
    private static final int XMM_REG_NUM_KEY_FIRST = 5;
    private static final int XMM_REG_NUM_KEY_LAST = 15;
    private static final int PARALLEL_FACTOR = 4;
    private static final int[] ROUNDS = new int[]{10, 12, 14};

    public AMD64CipherBlockChainingAESDecryptOp(AllocatableValue fromValue, AllocatableValue toValue, AllocatableValue keyValue, AllocatableValue rvecValue, AllocatableValue lenValue, AllocatableValue resultValue, int lengthOffset) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.keyValue = keyValue;
        this.rvecValue = rvecValue;
        this.lenValue = lenValue;
        this.resultValue = resultValue;
        this.lengthOffset = lengthOffset;
        this.temps = new Value[]{AMD64.rbx.asValue(), AMD64.r11.asValue(), AMD64.xmm0.asValue(), AMD64.xmm1.asValue(), AMD64.xmm2.asValue(), AMD64.xmm3.asValue(), AMD64.xmm4.asValue(), AMD64.xmm5.asValue(), AMD64.xmm6.asValue(), AMD64.xmm7.asValue(), AMD64.xmm8.asValue(), AMD64.xmm9.asValue(), AMD64.xmm10.asValue(), AMD64.xmm11.asValue(), AMD64.xmm12.asValue(), AMD64.xmm13.asValue(), AMD64.xmm14.asValue(), AMD64.xmm15.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        GraalError.guarantee(this.fromValue.getPlatformKind().equals(AMD64Kind.QWORD), "Invalid fromValue kind: %s", (Object)this.fromValue);
        GraalError.guarantee(this.toValue.getPlatformKind().equals(AMD64Kind.QWORD), "Invalid toValue kind: %s", (Object)this.toValue);
        GraalError.guarantee(this.keyValue.getPlatformKind().equals(AMD64Kind.QWORD), "Invalid keyValue kind: %s", (Object)this.keyValue);
        GraalError.guarantee(this.rvecValue.getPlatformKind().equals(AMD64Kind.QWORD), "Invalid rvecValue kind: %s", (Object)this.rvecValue);
        GraalError.guarantee(this.lenValue.getPlatformKind().equals(AMD64Kind.DWORD), "Invalid lenValue kind: %s", (Object)this.lenValue);
        GraalError.guarantee(this.resultValue.getPlatformKind().equals(AMD64Kind.DWORD), "Invalid resultValue kind: %s", (Object)this.resultValue);
        Register from = ValueUtil.asRegister((Value)this.fromValue);
        Register to = ValueUtil.asRegister((Value)this.toValue);
        Register key = ValueUtil.asRegister((Value)this.keyValue);
        Register rvec = ValueUtil.asRegister((Value)this.rvecValue);
        Register lenReg = AMD64.r11;
        masm.movq(lenReg, ValueUtil.asRegister((Value)this.lenValue));
        Register pos = ValueUtil.asRegister((Value)this.resultValue);
        Label labelExit = new Label();
        Label[] labelSingleBlockLoopTopHead = AMD64CounterModeAESCryptOp.newLabels(3);
        Label[] labelSingleBlockLoopTopHead2 = AMD64CounterModeAESCryptOp.newLabels(3);
        Label[] labelSingleBlockLoopTop = AMD64CounterModeAESCryptOp.newLabels(3);
        Label[] labelMultiBlockLoopTopHead = AMD64CounterModeAESCryptOp.newLabels(3);
        Label[] labelMultiBlockLoopTop = AMD64CounterModeAESCryptOp.newLabels(3);
        Register xmmKeyFirst = AMD64AESEncryptOp.asXMMRegister(5);
        Register xmmKeyLast = AMD64AESEncryptOp.asXMMRegister(15);
        int wordSize = crb.target.wordSize;
        Register xmmKeyShufMask = AMD64.xmm1;
        masm.movdqu(xmmKeyShufMask, AMD64HotSpotHelper.recordExternalAddress(crb, AMD64AESEncryptOp.keyShuffleMask));
        int offset = 16;
        for (int rnum = 5; rnum < 15; ++rnum) {
            AMD64AESEncryptOp.loadKey(masm, AMD64AESEncryptOp.asXMMRegister(rnum), key, offset, xmmKeyShufMask);
            offset += 16;
        }
        AMD64AESEncryptOp.loadKey(masm, xmmKeyLast, key, 0, xmmKeyShufMask);
        Register xmmPrevBlockCipher = AMD64.xmm1;
        Register xmmResult0 = AMD64.xmm0;
        Register xmmResult1 = AMD64.xmm2;
        Register xmmResult2 = AMD64.xmm3;
        Register xmmResult3 = AMD64.xmm4;
        masm.movdqu(xmmPrevBlockCipher, new AMD64Address(rvec, 0));
        masm.xorq(pos, pos);
        masm.movl(AMD64.rbx, new AMD64Address(key, this.lengthOffset));
        masm.cmplAndJcc(AMD64.rbx, 52, AMD64Assembler.ConditionFlag.Equal, labelMultiBlockLoopTopHead[1], false);
        masm.cmplAndJcc(AMD64.rbx, 60, AMD64Assembler.ConditionFlag.Equal, labelMultiBlockLoopTopHead[2], false);
        for (int k = 0; k < 3; ++k) {
            masm.bind(labelMultiBlockLoopTopHead[k]);
            if (k != 0) {
                masm.cmpqAndJcc(lenReg, 64, AMD64Assembler.ConditionFlag.Less, labelSingleBlockLoopTopHead2[k], false);
            }
            if (k == 1) {
                masm.subq(AMD64.rsp, 6 * wordSize);
                masm.movdqu(new AMD64Address(AMD64.rsp, 0), AMD64.xmm15);
                AMD64AESEncryptOp.loadKey(masm, AMD64.xmm15, key, 176, crb);
                masm.movdqu(new AMD64Address(AMD64.rsp, 2 * wordSize), AMD64.xmm15);
                AMD64AESEncryptOp.loadKey(masm, AMD64.xmm1, key, 192, crb);
                masm.movdqu(new AMD64Address(AMD64.rsp, 4 * wordSize), AMD64.xmm1);
            } else if (k == 2) {
                masm.subq(AMD64.rsp, 10 * wordSize);
                masm.movdqu(new AMD64Address(AMD64.rsp, 0), AMD64.xmm15);
                AMD64AESEncryptOp.loadKey(masm, AMD64.xmm15, key, 208, crb);
                masm.movdqu(new AMD64Address(AMD64.rsp, 6 * wordSize), AMD64.xmm15);
                AMD64AESEncryptOp.loadKey(masm, AMD64.xmm1, key, 224, crb);
                masm.movdqu(new AMD64Address(AMD64.rsp, 8 * wordSize), AMD64.xmm1);
                AMD64AESEncryptOp.loadKey(masm, AMD64.xmm15, key, 176, crb);
                masm.movdqu(new AMD64Address(AMD64.rsp, 2 * wordSize), AMD64.xmm15);
                AMD64AESEncryptOp.loadKey(masm, AMD64.xmm1, key, 192, crb);
                masm.movdqu(new AMD64Address(AMD64.rsp, 4 * wordSize), AMD64.xmm1);
            }
            masm.align(this.preferredLoopAlignment(crb));
            masm.bind(labelMultiBlockLoopTop[k]);
            masm.cmpq(lenReg, 64);
            masm.jcc(AMD64Assembler.ConditionFlag.Less, labelSingleBlockLoopTopHead[k]);
            if (k != 0) {
                masm.movdqu(AMD64.xmm15, new AMD64Address(AMD64.rsp, 2 * wordSize));
                masm.movdqu(AMD64.xmm1, new AMD64Address(AMD64.rsp, 4 * wordSize));
            }
            masm.movdqu(xmmResult0, new AMD64Address(from, pos, Stride.S1, 0));
            masm.movdqu(xmmResult1, new AMD64Address(from, pos, Stride.S1, 16));
            masm.movdqu(xmmResult2, new AMD64Address(from, pos, Stride.S1, 32));
            masm.movdqu(xmmResult3, new AMD64Address(from, pos, Stride.S1, 48));
            AMD64CipherBlockChainingAESDecryptOp.doFour(masm::pxor, xmmKeyFirst);
            if (k == 0) {
                for (int rnum = 1; rnum < ROUNDS[k]; ++rnum) {
                    AMD64CipherBlockChainingAESDecryptOp.doFour(masm::aesdec, AMD64AESEncryptOp.asXMMRegister(rnum + 5));
                }
                AMD64CipherBlockChainingAESDecryptOp.doFour(masm::aesdeclast, xmmKeyLast);
            } else if (k == 1) {
                for (int rnum = 1; rnum <= ROUNDS[k] - 2; ++rnum) {
                    AMD64CipherBlockChainingAESDecryptOp.doFour(masm::aesdec, AMD64AESEncryptOp.asXMMRegister(rnum + 5));
                }
                masm.movdqu(xmmKeyLast, new AMD64Address(AMD64.rsp, 0));
                AMD64CipherBlockChainingAESDecryptOp.doFour(masm::aesdec, AMD64.xmm1);
                masm.movdqu(xmmPrevBlockCipher, new AMD64Address(rvec, 0));
                AMD64CipherBlockChainingAESDecryptOp.doFour(masm::aesdeclast, xmmKeyLast);
            } else if (k == 2) {
                for (int rnum = 1; rnum <= ROUNDS[k] - 4; ++rnum) {
                    AMD64CipherBlockChainingAESDecryptOp.doFour(masm::aesdec, AMD64AESEncryptOp.asXMMRegister(rnum + 5));
                }
                AMD64CipherBlockChainingAESDecryptOp.doFour(masm::aesdec, AMD64.xmm1);
                masm.movdqu(AMD64.xmm15, new AMD64Address(AMD64.rsp, 6 * wordSize));
                masm.movdqu(AMD64.xmm1, new AMD64Address(AMD64.rsp, 8 * wordSize));
                AMD64CipherBlockChainingAESDecryptOp.doFour(masm::aesdec, AMD64.xmm15);
                masm.movdqu(xmmKeyLast, new AMD64Address(AMD64.rsp, 0));
                AMD64CipherBlockChainingAESDecryptOp.doFour(masm::aesdec, AMD64.xmm1);
                masm.movdqu(xmmPrevBlockCipher, new AMD64Address(rvec, 0));
                AMD64CipherBlockChainingAESDecryptOp.doFour(masm::aesdeclast, xmmKeyLast);
            }
            masm.pxor(xmmResult0, xmmPrevBlockCipher);
            masm.movdqu(xmmPrevBlockCipher, new AMD64Address(from, pos, Stride.S1, 0));
            masm.pxor(xmmResult1, xmmPrevBlockCipher);
            masm.movdqu(xmmPrevBlockCipher, new AMD64Address(from, pos, Stride.S1, 16));
            masm.pxor(xmmResult2, xmmPrevBlockCipher);
            masm.movdqu(xmmPrevBlockCipher, new AMD64Address(from, pos, Stride.S1, 32));
            masm.pxor(xmmResult3, xmmPrevBlockCipher);
            masm.movdqu(xmmPrevBlockCipher, new AMD64Address(from, pos, Stride.S1, 48));
            if (k != 0) {
                masm.movdqu(new AMD64Address(rvec, 0), xmmPrevBlockCipher);
            }
            masm.movdqu(new AMD64Address(to, pos, Stride.S1, 0), xmmResult0);
            masm.movdqu(new AMD64Address(to, pos, Stride.S1, 16), xmmResult1);
            masm.movdqu(new AMD64Address(to, pos, Stride.S1, 32), xmmResult2);
            masm.movdqu(new AMD64Address(to, pos, Stride.S1, 48), xmmResult3);
            masm.addq(pos, 64);
            masm.subq(lenReg, 64);
            masm.jmp(labelMultiBlockLoopTop[k]);
            Register xmmResult = AMD64.xmm0;
            Register xmmPrevBlockCipherSave = AMD64.xmm2;
            Register xmmKey11 = AMD64.xmm3;
            Register xmmKey12 = AMD64.xmm4;
            Register keyTmp = AMD64.xmm4;
            masm.bind(labelSingleBlockLoopTopHead[k]);
            if (k == 1) {
                masm.addq(AMD64.rsp, 6 * wordSize);
            } else if (k == 2) {
                masm.addq(AMD64.rsp, 10 * wordSize);
            }
            masm.cmpq(lenReg, 0);
            masm.jcc(AMD64Assembler.ConditionFlag.Equal, labelExit);
            masm.bind(labelSingleBlockLoopTopHead2[k]);
            if (k == 1) {
                AMD64AESEncryptOp.loadKey(masm, xmmKey11, key, 176, crb);
                AMD64AESEncryptOp.loadKey(masm, xmmKey12, key, 192, crb);
            }
            if (k == 2) {
                AMD64AESEncryptOp.loadKey(masm, xmmKey11, key, 176, crb);
            }
            masm.align(this.preferredLoopAlignment(crb));
            masm.bind(labelSingleBlockLoopTop[k]);
            masm.movdqu(xmmResult, new AMD64Address(from, pos, Stride.S1, 0));
            masm.movdqa(xmmPrevBlockCipherSave, xmmResult);
            masm.pxor(xmmResult, xmmKeyFirst);
            for (int rnum = 1; rnum <= 9; ++rnum) {
                masm.aesdec(xmmResult, AMD64AESEncryptOp.asXMMRegister(rnum + 5));
            }
            if (k == 1) {
                masm.aesdec(xmmResult, xmmKey11);
                masm.aesdec(xmmResult, xmmKey12);
            }
            if (k == 2) {
                masm.aesdec(xmmResult, xmmKey11);
                AMD64AESEncryptOp.loadKey(masm, keyTmp, key, 192, crb);
                masm.aesdec(xmmResult, keyTmp);
                AMD64AESEncryptOp.loadKey(masm, keyTmp, key, 208, crb);
                masm.aesdec(xmmResult, keyTmp);
                AMD64AESEncryptOp.loadKey(masm, keyTmp, key, 224, crb);
                masm.aesdec(xmmResult, keyTmp);
            }
            masm.aesdeclast(xmmResult, xmmKeyLast);
            masm.pxor(xmmResult, xmmPrevBlockCipher);
            masm.movdqu(new AMD64Address(to, pos, Stride.S1, 0), xmmResult);
            masm.movdqa(xmmPrevBlockCipher, xmmPrevBlockCipherSave);
            masm.addq(pos, 16);
            masm.subq(lenReg, 16);
            masm.jcc(AMD64Assembler.ConditionFlag.NotEqual, labelSingleBlockLoopTop[k]);
            if (k == 2) continue;
            masm.jmp(labelExit);
        }
        masm.bind(labelExit);
        masm.movdqu(new AMD64Address(rvec, 0), xmmPrevBlockCipher);
        masm.movl(ValueUtil.asRegister((Value)this.resultValue), ValueUtil.asRegister((Value)this.lenValue));
    }

    private static void doFour(BiConsumer<Register, Register> op, Register src) {
        Register xmmResult0 = AMD64.xmm0;
        Register xmmResult1 = AMD64.xmm2;
        Register xmmResult2 = AMD64.xmm3;
        Register xmmResult3 = AMD64.xmm4;
        op.accept(xmmResult0, src);
        op.accept(xmmResult1, src);
        op.accept(xmmResult2, src);
        op.accept(xmmResult3, src);
    }
}

