/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.amd64.AMD64HotSpotHelper;
import org.graalvm.compiler.lir.amd64.AMD64MathIntrinsicUnaryOp;
import org.graalvm.compiler.lir.asm.ArrayDataPointerConstant;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@StubPort(path="src/hotspot/cpu/x86/stubGenerator_x86_64_sin.cpp", lineStart=31, lineEnd=649, commit="090cdfc7a2e280c620a0926512fb67f0ce7f3c21", sha1="c5b71d2dfc288ef6cdd9498329f92da4971c1181")
public final class AMD64MathSinOp
extends AMD64MathIntrinsicUnaryOp {
    public static final LIRInstructionClass<AMD64MathSinOp> TYPE = LIRInstructionClass.create(AMD64MathSinOp.class);
    private static ArrayDataPointerConstant onehalf = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, 1071644672, 0, 1071644672});
    private static ArrayDataPointerConstant p2 = AMD64HotSpotHelper.pointerConstant(16, new int[]{442499072, 1032893537, 442499072, 1032893537});
    private static ArrayDataPointerConstant sc4 = AMD64HotSpotHelper.pointerConstant(16, new int[]{-1521039564, 1053236707, 0x1A01A01A, 1056571808});
    private static ArrayDataPointerConstant ctable = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, 0, 0, 0, 0, 0, 0, 0x3FF00000, 393047345, -1082934994, -1138117588, 1069094822, -536870912, -1136777448, 0, 0x3FF00000, 18115067, -1080840954, 1013556747, 1070135480, -1073741824, -1134400231, 0, 0x3FF00000, -1818418598, -1079637014, 785751814, 1070765062, -1610612736, -1133129075, 0, 0x3FF00000, -2039769649, -1078756191, -1498502813, 1071152610, -536870912, -1134088979, 0, 0x3FF00000, 1945768569, -1078052248, 939980347, 1071524701, 0x20000000, 1012796809, 0, 0x3FF00000, 1539668340, -1077570969, 967731400, 1071761211, 0x20000000, 1015752157, 0, 0x3FF00000, 1403757309, -1077080578, 621354454, 1071926515, 0x20000000, 1013450602, 0, 0x3FF00000, -1711476942, 1070236281, 1719614413, 1072079006, 0x20000000, -1131684556, 0, 1071644672, -1809549480, 1069626316, 1796544321, 1072217216, 0x20000000, -1132280351, 0, 1071644672, -1696166777, 1068266419, 688824739, 1072339814, -536870912, 1010431536, 0, 1071644672, 2140183630, -1080210900, -243221071, 1072445618, Integer.MIN_VALUE, -1133059919, 0, 1071644672, 1699043957, -1078065035, -818770618, 1072533611, 0x20000000, 1014257638, 0, 1071644672, 1991047213, 1067753521, 1455828442, 1072602945, -536870912, 1015505073, 0, 1070596096, 240740309, -1079239393, -805872464, 1072652951, 0x20000000, 1014325783, 0, 1070596096, 257503056, -1080319643, -1546574554, 1072683149, 0x40000000, -1131905546, 0, 1069547520, 0, 0, 0, 0x3FF00000, 0, 0, 0, 0, 257503056, 1067164005, -1546574554, 1072683149, 0x40000000, -1131905546, 0, -1077936128, 240740309, 1068244255, -805872464, 1072652951, 0x20000000, 1014325783, 0, -1076887552, 1991047213, -1079730127, 1455828442, 1072602945, -536870912, 1015505073, 0, -1076887552, 1699043957, 1069418613, -818770618, 1072533611, 0x20000000, 1014257638, 0, -1075838976, 2140183630, 1067272748, -243221071, 1072445618, Integer.MIN_VALUE, -1133059919, 0, -1075838976, -1696166777, -1079217229, 688824739, 1072339814, -536870912, 1010431536, 0, -1075838976, -1809549480, -1077857332, 1796544321, 1072217216, 0x20000000, -1132280351, 0, -1075838976, -1711476942, -1077247367, 1719614413, 1072079006, 0x20000000, -1131684556, 0, -1075838976, 1403757309, 1070403070, 621354454, 1071926515, 0x20000000, 1013450602, 0, -1074790400, 1539668340, 1069912679, 967731400, 1071761211, 0x20000000, 1015752157, 0, -1074790400, 1945768569, 1069431400, 939980347, 1071524701, 0x20000000, 1012796809, 0, -1074790400, -2039769649, 1068727457, -1498502813, 1071152610, -536870912, -1134088979, 0, -1074790400, -1818418598, 1067846634, 785751814, 1070765062, -1610612736, -1133129075, 0, -1074790400, 18115067, 1066642694, 1013556747, 1070135480, -1073741824, -1134400231, 0, -1074790400, 393047345, 1064548654, -1138117588, 1069094822, -536870912, -1136777448, 0, -1074790400, 0, 0, 0, 0, 0, 0, 0, -1074790400, 393047345, 1064548654, -1138117588, -1078388826, -536870912, 1010706200, 0, -1074790400, 18115067, 1066642694, 1013556747, -1077348168, -1073741824, 1013083417, 0, -1074790400, -1818418598, 1067846634, 785751814, -1076718586, -1610612736, 1014354573, 0, -1074790400, -2039769649, 1068727457, -1498502813, -1076331038, -536870912, 1013394669, 0, -1074790400, 1945768569, 1069431400, 939980347, -1075958947, 0x20000000, -1134686839, 0, -1074790400, 1539668340, 1069912679, 967731400, -1075722437, 0x20000000, -1131731491, 0, -1074790400, 1403757309, 1070403070, 621354454, -1075557133, 0x20000000, -1134033046, 0, -1074790400, -1711476942, -1077247367, 1719614413, -1075404642, 0x20000000, 1015799092, 0, -1075838976, -1809549480, -1077857332, 1796544321, -1075266432, 0x20000000, 1015203297, 0, -1075838976, -1696166777, -1079217229, 688824739, -1075143834, -536870912, -1137052112, 0, -1075838976, 2140183630, 1067272748, -243221071, -1075038030, Integer.MIN_VALUE, 1014423729, 0, -1075838976, 1699043957, 1069418613, -818770618, -1074950037, 0x20000000, -1133226010, 0, -1075838976, 1991047213, -1079730127, 1455828442, -1074880703, -536870912, -1131978575, 0, -1076887552, 240740309, 1068244255, -805872464, -1074830697, 0x20000000, -1133157865, 0, -1076887552, 257503056, 1067164005, -1546574554, -1074800499, 0x40000000, 1015578102, 0, -1077936128, 0, 0, 0, -1074790400, 0, 0, 0, 0, 257503056, -1080319643, -1546574554, -1074800499, 0x40000000, 1015578102, 0, 1069547520, 240740309, -1079239393, -805872464, -1074830697, 0x20000000, -1133157865, 0, 1070596096, 1991047213, 1067753521, 1455828442, -1074880703, -536870912, -1131978575, 0, 1070596096, 1699043957, -1078065035, -818770618, -1074950037, 0x20000000, -1133226010, 0, 1071644672, 2140183630, -1080210900, -243221071, -1075038030, Integer.MIN_VALUE, 1014423729, 0, 1071644672, -1696166777, 1068266419, 688824739, -1075143834, -536870912, -1137052112, 0, 1071644672, -1809549480, 1069626316, 1796544321, -1075266432, 0x20000000, 1015203297, 0, 1071644672, -1711476942, 1070236281, 1719614413, -1075404642, 0x20000000, 1015799092, 0, 1071644672, 1403757309, -1077080578, 621354454, -1075557133, 0x20000000, -1134033046, 0, 0x3FF00000, 1539668340, -1077570969, 967731400, -1075722437, 0x20000000, -1131731491, 0, 0x3FF00000, 1945768569, -1078052248, 939980347, -1075958947, 0x20000000, -1134686839, 0, 0x3FF00000, -2039769649, -1078756191, -1498502813, -1076331038, -536870912, 1013394669, 0, 0x3FF00000, -1818418598, -1079637014, 785751814, -1076718586, -1610612736, 1014354573, 0, 0x3FF00000, 18115067, -1080840954, 1013556747, -1077348168, -1073741824, 1013083417, 0, 0x3FF00000, 393047345, -1082934994, -1138117588, -1078388826, -536870912, 1010706200, 0, 0x3FF00000});
    private static ArrayDataPointerConstant sc2 = AMD64HotSpotHelper.pointerConstant(16, new int[]{0x11111111, 1065423121, 0x55555555, 1067799893});
    private static ArrayDataPointerConstant sc3 = AMD64HotSpotHelper.pointerConstant(16, new int[]{0x1A01A01A, -1087766112, 381774871, -1084833428});
    private static ArrayDataPointerConstant sc1 = AMD64HotSpotHelper.pointerConstant(16, new int[]{0x55555555, -1077586603, 0, -1075838976});
    private static ArrayDataPointerConstant piInvTable = AMD64HotSpotHelper.pointerConstant(16, new int[]{0, 0, -1560706194, 1313084713, -64530479, -181084736, -614296167, 1011060801, -28220501, -558119583, -1222349254, 1112396512, 105459434, 164729372, -31593700, -1322670274, -394119691, 784024708, -375623642, -1268810175, 965858873, -2091697676, -1669046389, -1107744709, 536385535, -570058737, -282127989, 1510632735, 1832287951, 667617719, 1330003814, -1637881299, 1965537991, -337251973, 1023883767, -1974299926, 1811636145, 529358088, 1443049542, -59020373, -254821343});
    private static ArrayDataPointerConstant pi4 = AMD64HotSpotHelper.pointerConstant(8, new int[]{0x40000000, 1072243195});
    private static ArrayDataPointerConstant pi48 = AMD64HotSpotHelper.pointerConstant(8, new int[]{407279769, 1046758445});
    private static ArrayDataPointerConstant pi32Inv = AMD64HotSpotHelper.pointerConstant(8, new int[]{1841940611, 1076125488});
    private static ArrayDataPointerConstant shifter = AMD64HotSpotHelper.pointerConstant(8, new int[]{0, 1127743488});
    private static ArrayDataPointerConstant signMask = AMD64HotSpotHelper.pointerConstant(8, new int[]{0, Integer.MIN_VALUE});
    private static ArrayDataPointerConstant p3 = AMD64HotSpotHelper.pointerConstant(8, new int[]{771977331, 996350346});
    private static ArrayDataPointerConstant allOnes = AMD64HotSpotHelper.pointerConstant(8, new int[]{-1, 0x3FEFFFFF});
    private static ArrayDataPointerConstant twoPow55 = AMD64HotSpotHelper.pointerConstant(8, new int[]{0, 1130364928});
    private static ArrayDataPointerConstant twoPowM55 = AMD64HotSpotHelper.pointerConstant(8, new int[]{0, 1015021568});
    private static ArrayDataPointerConstant p1 = AMD64HotSpotHelper.pointerConstant(8, new int[]{0x54400000, 1069097467});
    private static ArrayDataPointerConstant negZero = AMD64HotSpotHelper.pointerConstant(8, new int[]{0, Integer.MIN_VALUE});

    public AMD64MathSinOp() {
        super(TYPE, AMD64.rax, AMD64.rcx, AMD64.rdx, AMD64.rbx, AMD64.rsi, AMD64.rdi, AMD64.r8, AMD64.r9, AMD64.r10, AMD64.r11, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3, AMD64.xmm4, AMD64.xmm5, AMD64.xmm6, AMD64.xmm7);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Label block0 = new Label();
        Label block1 = new Label();
        Label block2 = new Label();
        Label block3 = new Label();
        Label block4 = new Label();
        Label block5 = new Label();
        Label block6 = new Label();
        Label block7 = new Label();
        Label block8 = new Label();
        Label block9 = new Label();
        Label block10 = new Label();
        Label block11 = new Label();
        Label block12 = new Label();
        Label block13 = new Label();
        Label block14 = new Label();
        masm.push(AMD64.rbx);
        masm.subq(AMD64.rsp, 16);
        masm.movsd(new AMD64Address(AMD64.rsp, 8), AMD64.xmm0);
        masm.movl(AMD64.rax, new AMD64Address(AMD64.rsp, 12));
        masm.movq(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, pi32Inv));
        masm.movq(AMD64.xmm2, AMD64HotSpotHelper.recordExternalAddress(crb, shifter));
        masm.andl(AMD64.rax, 0x7FFF0000);
        masm.subl(AMD64.rax, 0x30300000);
        masm.cmplAndJcc(AMD64.rax, 281346048, AMD64Assembler.ConditionFlag.Above, block0, false);
        masm.mulsd(AMD64.xmm1, AMD64.xmm0);
        masm.movdqu(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, onehalf));
        masm.movq(AMD64.xmm4, AMD64HotSpotHelper.recordExternalAddress(crb, signMask));
        masm.pand(AMD64.xmm4, AMD64.xmm0);
        masm.por(AMD64.xmm5, AMD64.xmm4);
        masm.addpd(AMD64.xmm1, AMD64.xmm5);
        masm.cvttsd2sil(AMD64.rdx, AMD64.xmm1);
        masm.cvtsi2sdl(AMD64.xmm1, AMD64.rdx);
        masm.movdqu(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, p2));
        masm.movq(AMD64.r8, 4591738658414919680L);
        masm.movdq(AMD64.xmm3, AMD64.r8);
        masm.movdqu(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, sc4));
        masm.pshufd(AMD64.xmm4, AMD64.xmm0, 68);
        masm.mulsd(AMD64.xmm3, AMD64.xmm1);
        if (masm.supports(AMD64.CPUFeature.SSE3)) {
            masm.movddup(AMD64.xmm1, AMD64.xmm1);
        } else {
            masm.movlhps(AMD64.xmm1, AMD64.xmm1);
        }
        masm.andl(AMD64.rdx, 63);
        masm.shll(AMD64.rdx, 5);
        masm.leaq(AMD64.rax, AMD64HotSpotHelper.recordExternalAddress(crb, ctable));
        masm.addq(AMD64.rax, AMD64.rdx);
        masm.mulpd(AMD64.xmm6, AMD64.xmm1);
        masm.mulsd(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, p3));
        masm.subsd(AMD64.xmm4, AMD64.xmm3);
        masm.movq(AMD64.xmm7, new AMD64Address(AMD64.rax, 8));
        masm.subsd(AMD64.xmm0, AMD64.xmm3);
        if (masm.supports(AMD64.CPUFeature.SSE3)) {
            masm.movddup(AMD64.xmm3, AMD64.xmm4);
        } else {
            masm.movdqu(AMD64.xmm3, AMD64.xmm4);
            masm.movlhps(AMD64.xmm3, AMD64.xmm3);
        }
        masm.subsd(AMD64.xmm4, AMD64.xmm6);
        masm.pshufd(AMD64.xmm0, AMD64.xmm0, 68);
        masm.movdqu(AMD64.xmm2, new AMD64Address(AMD64.rax, 0));
        masm.mulpd(AMD64.xmm5, AMD64.xmm0);
        masm.subpd(AMD64.xmm0, AMD64.xmm6);
        masm.mulsd(AMD64.xmm7, AMD64.xmm4);
        masm.subsd(AMD64.xmm3, AMD64.xmm4);
        masm.mulpd(AMD64.xmm5, AMD64.xmm0);
        masm.mulpd(AMD64.xmm0, AMD64.xmm0);
        masm.subsd(AMD64.xmm3, AMD64.xmm6);
        masm.movdqu(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, sc2));
        masm.subsd(AMD64.xmm1, AMD64.xmm3);
        masm.movq(AMD64.xmm3, new AMD64Address(AMD64.rax, 24));
        masm.addsd(AMD64.xmm2, AMD64.xmm3);
        masm.subsd(AMD64.xmm7, AMD64.xmm2);
        masm.mulsd(AMD64.xmm2, AMD64.xmm4);
        masm.mulpd(AMD64.xmm6, AMD64.xmm0);
        masm.mulsd(AMD64.xmm3, AMD64.xmm4);
        masm.mulpd(AMD64.xmm2, AMD64.xmm0);
        masm.mulpd(AMD64.xmm0, AMD64.xmm0);
        masm.addpd(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, sc3));
        masm.mulsd(AMD64.xmm4, new AMD64Address(AMD64.rax, 0));
        masm.addpd(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, sc1));
        masm.mulpd(AMD64.xmm5, AMD64.xmm0);
        masm.movdqu(AMD64.xmm0, AMD64.xmm3);
        masm.addsd(AMD64.xmm3, new AMD64Address(AMD64.rax, 8));
        masm.mulpd(AMD64.xmm1, AMD64.xmm7);
        masm.movdqu(AMD64.xmm7, AMD64.xmm4);
        masm.addsd(AMD64.xmm4, AMD64.xmm3);
        masm.addpd(AMD64.xmm6, AMD64.xmm5);
        masm.movq(AMD64.xmm5, new AMD64Address(AMD64.rax, 8));
        masm.subsd(AMD64.xmm5, AMD64.xmm3);
        masm.subsd(AMD64.xmm3, AMD64.xmm4);
        masm.addsd(AMD64.xmm1, new AMD64Address(AMD64.rax, 16));
        masm.mulpd(AMD64.xmm6, AMD64.xmm2);
        masm.addsd(AMD64.xmm5, AMD64.xmm0);
        masm.addsd(AMD64.xmm3, AMD64.xmm7);
        masm.addsd(AMD64.xmm1, AMD64.xmm5);
        masm.addsd(AMD64.xmm1, AMD64.xmm3);
        masm.addsd(AMD64.xmm1, AMD64.xmm6);
        masm.unpckhpd(AMD64.xmm6, AMD64.xmm6);
        masm.movdqu(AMD64.xmm0, AMD64.xmm4);
        masm.addsd(AMD64.xmm1, AMD64.xmm6);
        masm.addsd(AMD64.xmm0, AMD64.xmm1);
        masm.jmp(block14);
        masm.bind(block0);
        masm.jcc(AMD64Assembler.ConditionFlag.Greater, block1);
        masm.shrl(AMD64.rax, 20);
        masm.cmplAndJcc(AMD64.rax, 3325, AMD64Assembler.ConditionFlag.NotEqual, block2, false);
        masm.mulsd(AMD64.xmm0, AMD64HotSpotHelper.recordExternalAddress(crb, allOnes));
        masm.jmp(block14);
        masm.bind(block2);
        masm.movq(AMD64.xmm3, AMD64HotSpotHelper.recordExternalAddress(crb, twoPow55));
        masm.mulsd(AMD64.xmm3, AMD64.xmm0);
        masm.subsd(AMD64.xmm3, AMD64.xmm0);
        masm.mulsd(AMD64.xmm3, AMD64HotSpotHelper.recordExternalAddress(crb, twoPowM55));
        masm.jmp(block14);
        masm.bind(block1);
        masm.pextrw(AMD64.rax, AMD64.xmm0, 3);
        masm.andl(AMD64.rax, 32752);
        masm.cmplAndJcc(AMD64.rax, 32752, AMD64Assembler.ConditionFlag.Equal, block3, false);
        masm.pextrw(AMD64.rcx, AMD64.xmm0, 3);
        masm.andl(AMD64.rcx, 32752);
        masm.subl(AMD64.rcx, 16224);
        masm.shrl(AMD64.rcx, 7);
        masm.andl(AMD64.rcx, 65532);
        masm.leaq(AMD64.r11, AMD64HotSpotHelper.recordExternalAddress(crb, piInvTable));
        masm.addq(AMD64.rcx, AMD64.r11);
        masm.movdq(AMD64.rax, AMD64.xmm0);
        masm.movl(AMD64.r10, new AMD64Address(AMD64.rcx, 20));
        masm.movl(AMD64.r8, new AMD64Address(AMD64.rcx, 24));
        masm.movl(AMD64.rdx, AMD64.rax);
        masm.shrq(AMD64.rax, 21);
        masm.orl(AMD64.rax, Integer.MIN_VALUE);
        masm.shrl(AMD64.rax, 11);
        masm.movl(AMD64.r9, AMD64.r10);
        masm.imulq(AMD64.r10, AMD64.rdx);
        masm.imulq(AMD64.r9, AMD64.rax);
        masm.imulq(AMD64.r8, AMD64.rax);
        masm.movl(AMD64.rsi, new AMD64Address(AMD64.rcx, 16));
        masm.movl(AMD64.rdi, new AMD64Address(AMD64.rcx, 12));
        masm.movl(AMD64.r11, AMD64.r10);
        masm.shrq(AMD64.r10, 32);
        masm.addq(AMD64.r9, AMD64.r10);
        masm.addq(AMD64.r11, AMD64.r8);
        masm.movl(AMD64.r8, AMD64.r11);
        masm.shrq(AMD64.r11, 32);
        masm.addq(AMD64.r9, AMD64.r11);
        masm.movl(AMD64.r10, AMD64.rsi);
        masm.imulq(AMD64.rsi, AMD64.rdx);
        masm.imulq(AMD64.r10, AMD64.rax);
        masm.movl(AMD64.r11, AMD64.rdi);
        masm.imulq(AMD64.rdi, AMD64.rdx);
        masm.movl(AMD64.rbx, AMD64.rsi);
        masm.shrq(AMD64.rsi, 32);
        masm.addq(AMD64.r9, AMD64.rbx);
        masm.movl(AMD64.rbx, AMD64.r9);
        masm.shrq(AMD64.r9, 32);
        masm.addq(AMD64.r10, AMD64.rsi);
        masm.addq(AMD64.r10, AMD64.r9);
        masm.shlq(AMD64.rbx, 32);
        masm.orq(AMD64.r8, AMD64.rbx);
        masm.imulq(AMD64.r11, AMD64.rax);
        masm.movl(AMD64.r9, new AMD64Address(AMD64.rcx, 8));
        masm.movl(AMD64.rsi, new AMD64Address(AMD64.rcx, 4));
        masm.movl(AMD64.rbx, AMD64.rdi);
        masm.shrq(AMD64.rdi, 32);
        masm.addq(AMD64.r10, AMD64.rbx);
        masm.movl(AMD64.rbx, AMD64.r10);
        masm.shrq(AMD64.r10, 32);
        masm.addq(AMD64.r11, AMD64.rdi);
        masm.addq(AMD64.r11, AMD64.r10);
        masm.movq(AMD64.rdi, AMD64.r9);
        masm.imulq(AMD64.r9, AMD64.rdx);
        masm.imulq(AMD64.rdi, AMD64.rax);
        masm.movl(AMD64.r10, AMD64.r9);
        masm.shrq(AMD64.r9, 32);
        masm.addq(AMD64.r11, AMD64.r10);
        masm.movl(AMD64.r10, AMD64.r11);
        masm.shrq(AMD64.r11, 32);
        masm.addq(AMD64.rdi, AMD64.r9);
        masm.addq(AMD64.rdi, AMD64.r11);
        masm.movq(AMD64.r9, AMD64.rsi);
        masm.imulq(AMD64.rsi, AMD64.rdx);
        masm.imulq(AMD64.r9, AMD64.rax);
        masm.shlq(AMD64.r10, 32);
        masm.orq(AMD64.r10, AMD64.rbx);
        masm.movl(AMD64.rax, new AMD64Address(AMD64.rcx, 0));
        masm.movl(AMD64.r11, AMD64.rsi);
        masm.shrq(AMD64.rsi, 32);
        masm.addq(AMD64.rdi, AMD64.r11);
        masm.movl(AMD64.r11, AMD64.rdi);
        masm.shrq(AMD64.rdi, 32);
        masm.addq(AMD64.r9, AMD64.rsi);
        masm.addq(AMD64.r9, AMD64.rdi);
        masm.imulq(AMD64.rdx, AMD64.rax);
        masm.pextrw(AMD64.rbx, AMD64.xmm0, 3);
        masm.leaq(AMD64.rdi, AMD64HotSpotHelper.recordExternalAddress(crb, piInvTable));
        masm.subq(AMD64.rcx, AMD64.rdi);
        masm.addl(AMD64.rcx, AMD64.rcx);
        masm.addl(AMD64.rcx, AMD64.rcx);
        masm.addl(AMD64.rcx, AMD64.rcx);
        masm.addl(AMD64.rcx, 19);
        masm.movl(AMD64.rsi, 32768);
        masm.andl(AMD64.rsi, AMD64.rbx);
        masm.shrl(AMD64.rbx, 4);
        masm.andl(AMD64.rbx, 2047);
        masm.subl(AMD64.rbx, 1023);
        masm.subl(AMD64.rcx, AMD64.rbx);
        masm.addq(AMD64.r9, AMD64.rdx);
        masm.movl(AMD64.rdx, AMD64.rcx);
        masm.addl(AMD64.rdx, 32);
        masm.cmplAndJcc(AMD64.rcx, 1, AMD64Assembler.ConditionFlag.Less, block4, false);
        masm.negl(AMD64.rcx);
        masm.addl(AMD64.rcx, 29);
        masm.shll(AMD64.r9);
        masm.movl(AMD64.rdi, AMD64.r9);
        masm.andl(AMD64.r9, 0x1FFFFFFF);
        masm.testlAndJcc(AMD64.r9, 0x10000000, AMD64Assembler.ConditionFlag.NotEqual, block5, false);
        masm.shrl(AMD64.r9);
        masm.movl(AMD64.rbx, 0);
        masm.shlq(AMD64.r9, 32);
        masm.orq(AMD64.r9, AMD64.r11);
        masm.bind(block6);
        masm.bind(block7);
        masm.cmpqAndJcc(AMD64.r9, 0, AMD64Assembler.ConditionFlag.Equal, block8, false);
        masm.bind(block9);
        masm.bsrq(AMD64.r11, AMD64.r9);
        masm.movl(AMD64.rcx, 29);
        masm.sublAndJcc(AMD64.rcx, AMD64.r11, AMD64Assembler.ConditionFlag.LessEqual, block10, false);
        masm.shlq(AMD64.r9);
        masm.movq(AMD64.rax, AMD64.r10);
        masm.shlq(AMD64.r10);
        masm.addl(AMD64.rdx, AMD64.rcx);
        masm.negl(AMD64.rcx);
        masm.addl(AMD64.rcx, 64);
        masm.shrq(AMD64.rax);
        masm.shrq(AMD64.r8);
        masm.orq(AMD64.r9, AMD64.rax);
        masm.orq(AMD64.r10, AMD64.r8);
        masm.bind(block11);
        masm.cvtsi2sdq(AMD64.xmm0, AMD64.r9);
        masm.shrq(AMD64.r10, 1);
        masm.cvtsi2sdq(AMD64.xmm3, AMD64.r10);
        masm.xorpd(AMD64.xmm4, AMD64.xmm4);
        masm.shll(AMD64.rdx, 4);
        masm.negl(AMD64.rdx);
        masm.addl(AMD64.rdx, 16368);
        masm.orl(AMD64.rdx, AMD64.rsi);
        masm.xorl(AMD64.rdx, AMD64.rbx);
        masm.pinsrw(AMD64.xmm4, AMD64.rdx, 3);
        masm.movq(AMD64.xmm2, AMD64HotSpotHelper.recordExternalAddress(crb, pi4));
        masm.movq(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, pi48));
        masm.xorpd(AMD64.xmm5, AMD64.xmm5);
        masm.subl(AMD64.rdx, 1008);
        masm.pinsrw(AMD64.xmm5, AMD64.rdx, 3);
        masm.mulsd(AMD64.xmm0, AMD64.xmm4);
        masm.shll(AMD64.rsi, 16);
        masm.sarl(AMD64.rsi, 31);
        masm.mulsd(AMD64.xmm3, AMD64.xmm5);
        masm.movdqu(AMD64.xmm1, AMD64.xmm0);
        masm.mulsd(AMD64.xmm0, AMD64.xmm2);
        masm.shrl(AMD64.rdi, 29);
        masm.addsd(AMD64.xmm1, AMD64.xmm3);
        masm.mulsd(AMD64.xmm3, AMD64.xmm2);
        masm.addl(AMD64.rdi, AMD64.rsi);
        masm.xorl(AMD64.rdi, AMD64.rsi);
        masm.mulsd(AMD64.xmm6, AMD64.xmm1);
        masm.movl(AMD64.rax, AMD64.rdi);
        masm.addsd(AMD64.xmm6, AMD64.xmm3);
        masm.movdqu(AMD64.xmm2, AMD64.xmm0);
        masm.addsd(AMD64.xmm0, AMD64.xmm6);
        masm.subsd(AMD64.xmm2, AMD64.xmm0);
        masm.addsd(AMD64.xmm6, AMD64.xmm2);
        masm.bind(block12);
        masm.movq(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, pi32Inv));
        masm.mulsd(AMD64.xmm1, AMD64.xmm0);
        masm.movq(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, onehalf));
        masm.movq(AMD64.xmm4, AMD64HotSpotHelper.recordExternalAddress(crb, signMask));
        masm.pand(AMD64.xmm4, AMD64.xmm0);
        masm.por(AMD64.xmm5, AMD64.xmm4);
        masm.addpd(AMD64.xmm1, AMD64.xmm5);
        masm.cvttsd2sil(AMD64.rdx, AMD64.xmm1);
        masm.cvtsi2sdl(AMD64.xmm1, AMD64.rdx);
        masm.movq(AMD64.xmm3, AMD64HotSpotHelper.recordExternalAddress(crb, p1));
        masm.movdqu(AMD64.xmm2, AMD64HotSpotHelper.recordExternalAddress(crb, p2));
        masm.mulsd(AMD64.xmm3, AMD64.xmm1);
        masm.unpcklpd(AMD64.xmm1, AMD64.xmm1);
        masm.shll(AMD64.rax, 3);
        masm.addl(AMD64.rdx, 1865216);
        masm.movdqu(AMD64.xmm4, AMD64.xmm0);
        masm.addl(AMD64.rdx, AMD64.rax);
        masm.andl(AMD64.rdx, 63);
        masm.movdqu(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, sc4));
        masm.leaq(AMD64.rax, AMD64HotSpotHelper.recordExternalAddress(crb, ctable));
        masm.shll(AMD64.rdx, 5);
        masm.addq(AMD64.rax, AMD64.rdx);
        masm.mulpd(AMD64.xmm2, AMD64.xmm1);
        masm.subsd(AMD64.xmm0, AMD64.xmm3);
        masm.mulsd(AMD64.xmm1, AMD64HotSpotHelper.recordExternalAddress(crb, p3));
        masm.subsd(AMD64.xmm4, AMD64.xmm3);
        masm.movq(AMD64.xmm7, new AMD64Address(AMD64.rax, 8));
        masm.unpcklpd(AMD64.xmm0, AMD64.xmm0);
        masm.movdqu(AMD64.xmm3, AMD64.xmm4);
        masm.subsd(AMD64.xmm4, AMD64.xmm2);
        masm.mulpd(AMD64.xmm5, AMD64.xmm0);
        masm.subpd(AMD64.xmm0, AMD64.xmm2);
        masm.mulsd(AMD64.xmm7, AMD64.xmm4);
        masm.subsd(AMD64.xmm3, AMD64.xmm4);
        masm.mulpd(AMD64.xmm5, AMD64.xmm0);
        masm.mulpd(AMD64.xmm0, AMD64.xmm0);
        masm.subsd(AMD64.xmm3, AMD64.xmm2);
        masm.movdqu(AMD64.xmm2, new AMD64Address(AMD64.rax, 0));
        masm.subsd(AMD64.xmm1, AMD64.xmm3);
        masm.movq(AMD64.xmm3, new AMD64Address(AMD64.rax, 24));
        masm.addsd(AMD64.xmm2, AMD64.xmm3);
        masm.subsd(AMD64.xmm7, AMD64.xmm2);
        masm.subsd(AMD64.xmm1, AMD64.xmm6);
        masm.movdqu(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, sc2));
        masm.mulsd(AMD64.xmm2, AMD64.xmm4);
        masm.mulpd(AMD64.xmm6, AMD64.xmm0);
        masm.mulsd(AMD64.xmm3, AMD64.xmm4);
        masm.mulpd(AMD64.xmm2, AMD64.xmm0);
        masm.mulpd(AMD64.xmm0, AMD64.xmm0);
        masm.addpd(AMD64.xmm5, AMD64HotSpotHelper.recordExternalAddress(crb, sc3));
        masm.mulsd(AMD64.xmm4, new AMD64Address(AMD64.rax, 0));
        masm.addpd(AMD64.xmm6, AMD64HotSpotHelper.recordExternalAddress(crb, sc1));
        masm.mulpd(AMD64.xmm5, AMD64.xmm0);
        masm.movdqu(AMD64.xmm0, AMD64.xmm3);
        masm.addsd(AMD64.xmm3, new AMD64Address(AMD64.rax, 8));
        masm.mulpd(AMD64.xmm1, AMD64.xmm7);
        masm.movdqu(AMD64.xmm7, AMD64.xmm4);
        masm.addsd(AMD64.xmm4, AMD64.xmm3);
        masm.addpd(AMD64.xmm6, AMD64.xmm5);
        masm.movq(AMD64.xmm5, new AMD64Address(AMD64.rax, 8));
        masm.subsd(AMD64.xmm5, AMD64.xmm3);
        masm.subsd(AMD64.xmm3, AMD64.xmm4);
        masm.addsd(AMD64.xmm1, new AMD64Address(AMD64.rax, 16));
        masm.mulpd(AMD64.xmm6, AMD64.xmm2);
        masm.addsd(AMD64.xmm5, AMD64.xmm0);
        masm.addsd(AMD64.xmm3, AMD64.xmm7);
        masm.addsd(AMD64.xmm1, AMD64.xmm5);
        masm.addsd(AMD64.xmm1, AMD64.xmm3);
        masm.addsd(AMD64.xmm1, AMD64.xmm6);
        masm.unpckhpd(AMD64.xmm6, AMD64.xmm6);
        masm.movdqu(AMD64.xmm0, AMD64.xmm4);
        masm.addsd(AMD64.xmm1, AMD64.xmm6);
        masm.addsd(AMD64.xmm0, AMD64.xmm1);
        masm.jmp(block14);
        masm.bind(block8);
        masm.addl(AMD64.rdx, 64);
        masm.movq(AMD64.r9, AMD64.r10);
        masm.movq(AMD64.r10, AMD64.r8);
        masm.movl(AMD64.r8, 0);
        masm.cmpqAndJcc(AMD64.r9, 0, AMD64Assembler.ConditionFlag.NotEqual, block9, false);
        masm.addl(AMD64.rdx, 64);
        masm.movq(AMD64.r9, AMD64.r10);
        masm.movq(AMD64.r10, AMD64.r8);
        masm.cmpqAndJcc(AMD64.r9, 0, AMD64Assembler.ConditionFlag.NotEqual, block9, false);
        masm.xorpd(AMD64.xmm0, AMD64.xmm0);
        masm.xorpd(AMD64.xmm6, AMD64.xmm6);
        masm.jmp(block12);
        masm.bind(block10);
        masm.jcc(AMD64Assembler.ConditionFlag.Equal, block11);
        masm.negl(AMD64.rcx);
        masm.shrq(AMD64.r10);
        masm.movq(AMD64.rax, AMD64.r9);
        masm.shrq(AMD64.r9);
        masm.subl(AMD64.rdx, AMD64.rcx);
        masm.negl(AMD64.rcx);
        masm.addl(AMD64.rcx, 64);
        masm.shlq(AMD64.rax);
        masm.orq(AMD64.r10, AMD64.rax);
        masm.jmp(block11);
        masm.bind(block4);
        masm.negl(AMD64.rcx);
        masm.shlq(AMD64.r9, 32);
        masm.orq(AMD64.r9, AMD64.r11);
        masm.shlq(AMD64.r9);
        masm.movq(AMD64.rdi, AMD64.r9);
        masm.testlAndJcc(AMD64.r9, Integer.MIN_VALUE, AMD64Assembler.ConditionFlag.NotEqual, block13, false);
        masm.shrl(AMD64.r9);
        masm.movl(AMD64.rbx, 0);
        masm.shrq(AMD64.rdi, 3);
        masm.jmp(block7);
        masm.bind(block5);
        masm.shrl(AMD64.r9);
        masm.movl(AMD64.rbx, 0x20000000);
        masm.shrl(AMD64.rbx);
        masm.shlq(AMD64.r9, 32);
        masm.orq(AMD64.r9, AMD64.r11);
        masm.shlq(AMD64.rbx, 32);
        masm.addl(AMD64.rdi, 0x20000000);
        masm.movl(AMD64.rcx, 0);
        masm.movl(AMD64.r11, 0);
        masm.subq(AMD64.rcx, AMD64.r8);
        masm.sbbq(AMD64.r11, AMD64.r10);
        masm.sbbq(AMD64.rbx, AMD64.r9);
        masm.movq(AMD64.r8, AMD64.rcx);
        masm.movq(AMD64.r10, AMD64.r11);
        masm.movq(AMD64.r9, AMD64.rbx);
        masm.movl(AMD64.rbx, 32768);
        masm.jmp(block6);
        masm.bind(block13);
        masm.shrl(AMD64.r9);
        masm.movq(AMD64.rbx, 0x100000000L);
        masm.shrq(AMD64.rbx);
        masm.movl(AMD64.rcx, 0);
        masm.movl(AMD64.r11, 0);
        masm.subq(AMD64.rcx, AMD64.r8);
        masm.sbbq(AMD64.r11, AMD64.r10);
        masm.sbbq(AMD64.rbx, AMD64.r9);
        masm.movq(AMD64.r8, AMD64.rcx);
        masm.movq(AMD64.r10, AMD64.r11);
        masm.movq(AMD64.r9, AMD64.rbx);
        masm.movl(AMD64.rbx, 32768);
        masm.shrq(AMD64.rdi, 3);
        masm.addl(AMD64.rdi, 0x20000000);
        masm.jmp(block7);
        masm.bind(block3);
        masm.movq(AMD64.xmm0, new AMD64Address(AMD64.rsp, 8));
        masm.mulsd(AMD64.xmm0, AMD64HotSpotHelper.recordExternalAddress(crb, negZero));
        masm.movq(new AMD64Address(AMD64.rsp, 0), AMD64.xmm0);
        masm.bind(block14);
        masm.addq(AMD64.rsp, 16);
        masm.pop(AMD64.rbx);
    }
}

