/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64.vector;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.amd64.vector.AMD64VectorInstruction;
import org.graalvm.compiler.lir.amd64.vector.AVX512Support;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

public class AMD64VectorUnary {

    public static final class FloatPointClassTestOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<FloatPointClassTestOp> TYPE = LIRInstructionClass.create(FloatPointClassTestOp.class);
        public static final int QUIET_NAN = 1;
        public static final int POS_ZERO = 2;
        public static final int NEG_ZERO = 4;
        public static final int POS_INF = 8;
        public static final int NEG_INF = 16;
        public static final int DENORMAL = 32;
        public static final int FIN_NEG = 64;
        public static final int SIG_NAN = 128;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue maskTemp;
        private final AMD64BaseAssembler.OperandSize size;
        private final int imm8;

        public FloatPointClassTestOp(LIRGeneratorTool tool, AMD64BaseAssembler.OperandSize size, int imm8, AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.size = size;
            this.imm8 = imm8;
            this.maskTemp = tool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.MASK8));
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            switch (this.size) {
                case SS: {
                    AMD64Assembler.EvexRMIOp.VFPCLASSSS.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.maskTemp), ValueUtil.asRegister((Value)this.input), this.imm8);
                    break;
                }
                case SD: {
                    AMD64Assembler.EvexRMIOp.VFPCLASSSD.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.maskTemp), ValueUtil.asRegister((Value)this.input), this.imm8);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("unsupported operand size " + this.size);
                }
            }
            masm.kmovb(ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.maskTemp));
        }
    }

    public static final class AVXConvertOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<AVXConvertOp> TYPE = LIRInstructionClass.create(AVXConvertOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMConvertOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue input;

        public AVXConvertOp(AMD64Assembler.VexRVMConvertOp opcode, AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.input)) {
                if (AMD64.XMM.equals((Object)ValueUtil.asRegister((Value)this.input).getRegisterCategory())) {
                    this.opcode.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input), ValueUtil.asRegister((Value)this.input));
                } else {
                    AMD64Assembler.VexRVMOp.VXORPD.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result));
                    this.opcode.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input));
                }
            } else {
                AMD64Assembler.VexRVMOp.VXORPD.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result));
                this.opcode.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.input));
            }
        }
    }

    public static final class AVXConvertMemoryOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXConvertMemoryOp> TYPE = LIRInstructionClass.create(AVXConvertMemoryOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue input;
        @LIRInstruction.State
        protected LIRFrameState state;

        public AVXConvertMemoryOp(AMD64Assembler.VexRVMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AMD64AddressValue input, LIRFrameState state) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.input = input;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), this.input.toAddress());
        }
    }

    public static final class AVXBroadcastOp
    extends AMD64VectorInstruction
    implements AVX512Support {
        public static final LIRInstructionClass<AVXBroadcastOp> TYPE = LIRInstructionClass.create(AVXBroadcastOp.class);
        @Opcode
        private final AMD64Assembler.VexRMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.CONST})
        protected Value input;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected AllocatableValue opmask;
        private final int z;
        private final int b;

        public AVXBroadcastOp(AMD64Assembler.VexRMOp opcode, AVXKind.AVXSize size, AllocatableValue result, Value input) {
            this(opcode, size, result, input, Value.ILLEGAL, 0, 0);
        }

        public AVXBroadcastOp(AMD64Assembler.VexRMOp opcode, AVXKind.AVXSize size, AllocatableValue result, Value input, AllocatableValue opmask, int z, int b) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.input = input;
            this.opmask = opmask;
            this.z = z;
            this.b = b;
        }

        @Override
        public AllocatableValue getOpmask() {
            return this.opmask;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.input)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input));
            } else if (LIRValueUtil.isConstantValue(this.input)) {
                int align = crb.dataBuilder.ensureValidDataAlignment(this.input.getPlatformKind().getSizeInBytes());
                AMD64Address address = (AMD64Address)crb.recordDataReferenceInCode(LIRValueUtil.asConstant(this.input), align);
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), address, this.getOpmaskRegister(), this.z, this.b);
            } else {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress(this.input), this.getOpmaskRegister(), this.z, this.b);
            }
        }
    }

    public static final class AVXUnaryMemoryOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXUnaryMemoryOp> TYPE = LIRInstructionClass.create(AVXUnaryMemoryOp.class);
        @Opcode
        private final AMD64Assembler.VexRMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue input;
        @LIRInstruction.State
        protected LIRFrameState state;

        public AVXUnaryMemoryOp(AMD64Assembler.VexRMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AMD64AddressValue input, LIRFrameState state) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.input = input;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), this.input.toAddress());
        }
    }

    public static final class AVXUnaryRVMOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXUnaryRVMOp> TYPE = LIRInstructionClass.create(AVXUnaryRVMOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue input;

        public AVXUnaryRVMOp(AMD64Assembler.VexRVMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue input) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.input)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input), ValueUtil.asRegister((Value)this.input));
            } else {
                AMD64Assembler.VexRVMOp.VXORPD.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result));
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.input));
            }
        }
    }

    public static final class AVXUnaryOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXUnaryOp> TYPE = LIRInstructionClass.create(AVXUnaryOp.class);
        @Opcode
        private final AMD64Assembler.VexRMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue input;

        public AVXUnaryOp(AMD64Assembler.VexRMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue input) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.input)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input));
            } else {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.input));
            }
        }
    }
}

