/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.asm;

import java.nio.ByteBuffer;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.SerializableConstant;
import org.graalvm.compiler.code.DataSection;

public abstract class DataBuilder {
    public abstract DataSection.Data createDataItem(Constant var1);

    public DataSection.Data createSerializableData(SerializableConstant constant, int alignment) {
        assert (this.canForceAlignmentOf(alignment));
        return new DataSection.SerializableData(constant, alignment);
    }

    public DataSection.Data createSerializableData(SerializableConstant constant) {
        return this.createSerializableData(constant, 1);
    }

    public DataSection.Data createMutableData(int alignment, int size) {
        assert (this.canForceAlignmentOf(alignment));
        return new DataSection.ZeroData(alignment, size){

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }

            @Override
            public boolean isMutable() {
                return true;
            }
        };
    }

    public DataSection.Data createZeroData(int alignment, int size) {
        assert (this.canForceAlignmentOf(alignment));
        switch (size) {
            case 1: {
                return new DataSection.ZeroData(alignment, size){

                    @Override
                    protected void emit(ByteBuffer buffer, DataSection.Patches patches) {
                        buffer.put((byte)0);
                    }
                };
            }
            case 2: {
                return new DataSection.ZeroData(alignment, size){

                    @Override
                    protected void emit(ByteBuffer buffer, DataSection.Patches patches) {
                        buffer.putShort((short)0);
                    }
                };
            }
            case 4: {
                return new DataSection.ZeroData(alignment, size){

                    @Override
                    protected void emit(ByteBuffer buffer, DataSection.Patches patches) {
                        buffer.putInt(0);
                    }
                };
            }
            case 8: {
                return new DataSection.ZeroData(alignment, size){

                    @Override
                    protected void emit(ByteBuffer buffer, DataSection.Patches patches) {
                        buffer.putLong(0L);
                    }
                };
            }
        }
        return new DataSection.ZeroData(alignment, size);
    }

    public DataSection.Data createPackedDataItem(int alignment, int size, DataSection.Data[] nested) {
        assert (this.canForceAlignmentOf(alignment));
        return new DataSection.PackedData(alignment, size, nested);
    }

    public DataSection.Data createPackedDataItem(DataSection.Data[] nested) {
        int size = 0;
        int alignment = 1;
        for (int i = 0; i < nested.length; ++i) {
            assert (size % nested[i].getAlignment() == 0) : "invalid alignment in packed constants";
            alignment = DataSection.lcm(alignment, nested[i].getAlignment());
            size += nested[i].getSize();
        }
        return this.createPackedDataItem(alignment, size, nested);
    }

    public DataSection.Data createMultiDataItem(Constant ... constants) {
        assert (constants.length > 0);
        if (constants.length == 1) {
            return this.createDataItem(constants[0]);
        }
        DataSection.Data[] data = new DataSection.Data[constants.length];
        for (int i = 0; i < constants.length; ++i) {
            data[i] = this.createDataItem(constants[i]);
        }
        return this.createPackedDataItem(data);
    }

    public int ensureValidDataAlignment(int requestedAlignment) {
        return Math.min(requestedAlignment, this.getMaxSupportedAlignment());
    }

    public void updateAlignment(DataSection.Data data, int newAlignment) {
        assert (this.canForceAlignmentOf(newAlignment));
        data.updateAlignment(newAlignment);
    }

    public abstract int getMaxSupportedAlignment();

    public boolean canForceAlignmentOf(int sizeInBytes) {
        return sizeInBytes <= this.getMaxSupportedAlignment();
    }
}

