/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import java.util.Optional;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.loop.phases.LoopPhase;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;

public class LoopPeelingPhase
extends LoopPhase<LoopPolicies> {
    public LoopPeelingPhase(LoopPolicies policies, CanonicalizerPhase canonicalizer) {
        super(policies, canonicalizer);
    }

    public static boolean canPeel(LoopEx loop) {
        return LoopPeelingPhase.stateAllowsPeeling(loop.loopBegin().graph().getGraphState()) && loop.canDuplicateLoop() && loop.loopBegin().getLoopEndCount() > 0;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FSA, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState));
    }

    private static boolean stateAllowsPeeling(GraphState graphState) {
        return graphState.isBeforeStage(GraphState.StageFlag.FSA) && graphState.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        DebugContext debug = graph.getDebug();
        if (graph.hasLoops()) {
            LoopsData data = context.getLoopsDataProvider().getLoopsData(graph);
            try (DebugContext.Scope s = debug.scope((Object)"peeling", data.getCFG());){
                for (LoopEx loop : data.outerFirst()) {
                    if (!LoopPeelingPhase.canPeel(loop)) continue;
                    for (int iteration = 0; iteration < Options.IterativePeelingLimit.getValue(graph.getOptions()); ++iteration) {
                        if (!LoopPolicies.Options.PeelALot.getValue(graph.getOptions()).booleanValue() && !this.getPolicies().shouldPeel(loop, data.getCFG(), context, iteration)) continue;
                        LoopTransformations.peel(loop);
                        loop.invalidateFragmentsAndIVs();
                        data.getCFG().updateCachedLocalLoopFrequency(loop.loopBegin(), f -> f.decrementFrequency(1.0));
                    }
                }
                data.deleteUnusedNodes();
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    @Override
    public float codeSizeIncrease() {
        return 10.0f;
    }

    public static class Options {
        public static final OptionKey<Integer> IterativePeelingLimit = new OptionKey<Integer>(2);
    }
}

