/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CompanionObjectEncoder;
import org.graalvm.compiler.nodes.InliningLog;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.util.CollectionsUtil;

public class InliningLogCodec
extends CompanionObjectEncoder<InliningLog, EncodedInliningLog> {
    @Override
    protected InliningLog getCompanionObject(StructuredGraph graph) {
        return graph.getInliningLog();
    }

    @Override
    protected boolean shouldBeEncoded(InliningLog inliningLog) {
        return inliningLog != null;
    }

    @Override
    protected EncodedInliningLog createInstance(InliningLog inliningLog) {
        assert (this.shouldBeEncoded(inliningLog)) : "prepare should be called iff there is anything to encode";
        return new EncodedInliningLog();
    }

    @Override
    protected void encodeIntoInstance(EncodedInliningLog encodedObject, InliningLog inliningLog, Function<Node, Integer> mapper) {
        assert (this.shouldBeEncoded(inliningLog)) : "encode should be once iff there is anything to encode";
        EconomicMap replacements = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        encodedObject.root = InliningLogCodec.encodeSubtree(inliningLog.getRootCallsite(), mapper, (EconomicMap<InliningLog.Callsite, EncodedCallsite>)replacements);
    }

    private static Integer encodeInvokable(Invokable invokable, Function<Node, Integer> mapper) {
        if (invokable instanceof Node && ((Node)((Object)invokable)).isAlive()) {
            return mapper.apply((Node)((Object)invokable));
        }
        return null;
    }

    private static EncodedCallsite encodeSubtree(InliningLog.Callsite replacementSite, Function<Node, Integer> mapper, EconomicMap<InliningLog.Callsite, EncodedCallsite> mapping) {
        Integer invokableNode = InliningLogCodec.encodeInvokable(replacementSite.getInvoke(), mapper);
        EncodedCallsite originalCallsite = replacementSite.getOriginalCallsite() == null ? null : (EncodedCallsite)mapping.get((Object)replacementSite.getOriginalCallsite());
        EncodedCallsite site = new EncodedCallsite(new ArrayList<InliningLog.Decision>(replacementSite.getDecisions()), new ArrayList<EncodedCallsite>(), replacementSite.getBci(), originalCallsite, invokableNode, replacementSite.getTarget(), replacementSite.isIndirect(), replacementSite.getTargetTypeProfile());
        mapping.put((Object)replacementSite, (Object)site);
        for (InliningLog.Callsite replacementChild : replacementSite.getChildren()) {
            site.children.add(InliningLogCodec.encodeSubtree(replacementChild, mapper, mapping));
        }
        return site;
    }

    public static Pair<InliningLogDecoder, InliningLog> maybeDecode(StructuredGraph graph, Object encodedObject) {
        if (graph.getInliningLog() == null) {
            return null;
        }
        InliningLogDecoder decoder = new InliningLogDecoder();
        InliningLog inliningLog = decoder.decode(encodedObject);
        return Pair.create((Object)decoder, (Object)inliningLog);
    }

    @Override
    public boolean verify(StructuredGraph originalGraph, StructuredGraph decodedGraph) {
        InliningLog original = originalGraph.getInliningLog();
        InliningLog decoded = decodedGraph.getInliningLog();
        if (original == null || decoded == null) {
            return true;
        }
        return InliningLogCodec.subtreesEqual(original.getRootCallsite(), decoded.getRootCallsite());
    }

    private static boolean subtreesEqual(InliningLog.Callsite callsite1, InliningLog.Callsite callsite2) {
        if (callsite1 == null || callsite2 == null || !Objects.equals(callsite1.getTarget(), callsite2.getTarget()) || callsite1.getBci() != callsite2.getBci() || callsite1.isIndirect() != callsite2.isIndirect()) {
            return false;
        }
        Iterable children1 = () -> callsite1.getChildren().stream().iterator();
        Iterable children2 = () -> callsite2.getChildren().stream().iterator();
        return CollectionsUtil.allMatch(CollectionsUtil.zipLongest(children1, children2), pair -> InliningLogCodec.subtreesEqual((InliningLog.Callsite)pair.getLeft(), (InliningLog.Callsite)pair.getRight()));
    }

    protected static final class EncodedInliningLog
    implements CompanionObjectEncoder.EncodedObject {
        private EncodedCallsite root;

        protected EncodedInliningLog() {
        }
    }

    private static final class EncodedCallsite {
        private final List<InliningLog.Decision> decisions;
        private final List<EncodedCallsite> children;
        private final int bci;
        private final EncodedCallsite originalCallsite;
        private final Integer invokeOrderId;
        private final ResolvedJavaMethod target;
        private final boolean indirect;
        private final JavaTypeProfile typeProfile;

        private EncodedCallsite(List<InliningLog.Decision> decisions, List<EncodedCallsite> children, int bci, EncodedCallsite originalCallsite, Integer invokeOrderId, ResolvedJavaMethod target, boolean indirect, JavaTypeProfile typeProfile) {
            this.decisions = decisions;
            this.children = children;
            this.bci = bci;
            this.originalCallsite = originalCallsite;
            this.invokeOrderId = invokeOrderId;
            this.target = target;
            this.indirect = indirect;
            this.typeProfile = typeProfile;
        }
    }

    public static final class InliningLogDecoder {
        private EconomicMap<Integer, InliningLog.Callsite> orderIdToCallsite;

        private InliningLogDecoder() {
        }

        private InliningLog decode(Object encodedObject) {
            this.orderIdToCallsite = EconomicMap.create();
            InliningLog inliningLog = new InliningLog(null);
            if (encodedObject != null) {
                EncodedInliningLog instance = (EncodedInliningLog)encodedObject;
                assert (instance.root != null);
                EconomicMap replacements = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
                inliningLog.setRootCallsite(this.decodeSubtree(null, instance.root, (EconomicMap<EncodedCallsite, InliningLog.Callsite>)replacements));
            }
            return inliningLog;
        }

        public void registerNode(InliningLog inliningLog, Node node, int orderId) {
            if (!(node instanceof Invokable)) {
                return;
            }
            assert (this.orderIdToCallsite != null) : "registerNode should be called after decode";
            Invokable invokable = (Invokable)((Object)node);
            if (inliningLog.containsLeafCallsite(invokable)) {
                return;
            }
            if (this.orderIdToCallsite.containsKey((Object)orderId)) {
                InliningLog.Callsite callsite = (InliningLog.Callsite)this.orderIdToCallsite.get((Object)orderId);
                callsite.setInvoke(invokable);
                inliningLog.registerLeafCallsite(invokable, callsite);
            } else {
                inliningLog.trackNewCallsite(invokable);
            }
        }

        private InliningLog.Callsite decodeSubtree(InliningLog.Callsite parent, EncodedCallsite replacementSite, EconomicMap<EncodedCallsite, InliningLog.Callsite> replacements) {
            InliningLog.Callsite originalCallsite = replacementSite.originalCallsite == null ? null : (InliningLog.Callsite)replacements.get((Object)replacementSite.originalCallsite);
            InliningLog.Callsite site = new InliningLog.Callsite(parent, originalCallsite, null, replacementSite.target, replacementSite.bci, replacementSite.indirect, replacementSite.typeProfile);
            if (replacementSite.invokeOrderId != null) {
                this.orderIdToCallsite.put((Object)replacementSite.invokeOrderId, (Object)site);
            }
            site.getDecisions().addAll(replacementSite.decisions);
            replacements.put((Object)replacementSite, (Object)site);
            for (EncodedCallsite replacementChild : replacementSite.children) {
                this.decodeSubtree(site, replacementChild, replacements);
            }
            return site;
        }
    }
}

