/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.function.Function;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicMapUtil;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CompanionObjectEncoder;
import org.graalvm.compiler.nodes.OptimizationLog;
import org.graalvm.compiler.nodes.OptimizationLogImpl;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.util.CollectionsUtil;

public class OptimizationLogCodec
extends CompanionObjectEncoder<OptimizationLog, EncodedOptimizationLog> {
    @Override
    protected OptimizationLog getCompanionObject(StructuredGraph graph) {
        return graph.getOptimizationLog();
    }

    @Override
    protected boolean shouldBeEncoded(OptimizationLog optimizationLog) {
        return optimizationLog.isOptimizationLogEnabled();
    }

    @Override
    protected EncodedOptimizationLog createInstance(OptimizationLog optimizationLog) {
        assert (this.shouldBeEncoded(optimizationLog) && optimizationLog instanceof OptimizationLogImpl) : "prepare should be called iff there is anything to encode";
        return new EncodedOptimizationLog();
    }

    @Override
    protected void encodeIntoInstance(EncodedOptimizationLog encodedObject, OptimizationLog optimizationLog, Function<Node, Integer> mapper) {
        assert (encodedObject.optimizationTree == null && encodedObject.root == null && this.shouldBeEncoded(optimizationLog) && optimizationLog instanceof OptimizationLogImpl) : "encode should be once iff there is anything to encode";
        OptimizationLogImpl optimizationLogImpl = (OptimizationLogImpl)optimizationLog;
        Graph original = optimizationLogImpl.getOptimizationTree();
        encodedObject.optimizationTree = new Graph(original.name, original.getOptions(), original.getDebug(), original.trackNodeSourcePosition());
        EconomicMap<Node, Node> duplicates = encodedObject.optimizationTree.addDuplicates(original.getNodes(), original, original.getNodeCount(), (UnmodifiableEconomicMap<Node, Node>)((EconomicMap)null));
        encodedObject.root = (OptimizationLogImpl.OptimizationPhaseNode)duplicates.get((Object)optimizationLogImpl.findRootPhase());
    }

    public static OptimizationLog maybeDecode(StructuredGraph graph, Object encodedObject) {
        if (!graph.getOptimizationLog().isOptimizationLogEnabled()) {
            return null;
        }
        OptimizationLogImpl optimizationLog = new OptimizationLogImpl(graph);
        if (encodedObject != null) {
            EncodedOptimizationLog instance = (EncodedOptimizationLog)encodedObject;
            assert (instance.optimizationTree != null && instance.root != null) : "an empty optimization tree should be encoded as null";
            OptimizationLogImpl.OptimizationPhaseNode rootPhase = optimizationLog.findRootPhase();
            EconomicMap<Node, Node> duplicates = optimizationLog.getOptimizationTree().addDuplicates(instance.optimizationTree.getNodes(), instance.optimizationTree, instance.optimizationTree.getNodeCount(), (UnmodifiableEconomicMap<Node, Node>)((EconomicMap)null));
            ((Node)duplicates.get((Object)instance.root)).safeDelete();
            for (OptimizationLog.OptimizationTreeNode child : instance.root.getChildren()) {
                rootPhase.getChildren().add((Node)duplicates.get((Object)child));
            }
        }
        return optimizationLog;
    }

    @Override
    public boolean verify(StructuredGraph originalGraph, StructuredGraph decodedGraph) {
        OptimizationLog original = originalGraph.getOptimizationLog();
        OptimizationLog decoded = decodedGraph.getOptimizationLog();
        if (!original.isOptimizationLogEnabled() || !decoded.isOptimizationLogEnabled()) {
            return true;
        }
        assert (original instanceof OptimizationLogImpl && decoded instanceof OptimizationLogImpl) : "enabled optimization log implies instanceof OptimizationLogImpl";
        return OptimizationLogCodec.subtreesEqual(((OptimizationLogImpl)original).findRootPhase(), ((OptimizationLogImpl)decoded).findRootPhase());
    }

    private static boolean subtreesEqual(OptimizationLog.OptimizationTreeNode treeNode1, OptimizationLog.OptimizationTreeNode treeNode2) {
        if (treeNode1 instanceof OptimizationLogImpl.OptimizationNode && treeNode2 instanceof OptimizationLogImpl.OptimizationNode) {
            OptimizationLogImpl.OptimizationNode entry1 = (OptimizationLogImpl.OptimizationNode)treeNode1;
            OptimizationLogImpl.OptimizationNode entry2 = (OptimizationLogImpl.OptimizationNode)treeNode2;
            return entry1.getOptimizationName().equals(entry2.getOptimizationName()) && entry1.getEventName().equals(entry2.getEventName()) && EconomicMapUtil.equals(entry1.getProperties(), entry2.getProperties());
        }
        if (treeNode1 instanceof OptimizationLogImpl.OptimizationPhaseNode && treeNode2 instanceof OptimizationLogImpl.OptimizationPhaseNode) {
            OptimizationLogImpl.OptimizationPhaseNode phase1 = (OptimizationLogImpl.OptimizationPhaseNode)treeNode1;
            OptimizationLogImpl.OptimizationPhaseNode phase2 = (OptimizationLogImpl.OptimizationPhaseNode)treeNode2;
            if (!phase1.getPhaseName().equals(phase2.getPhaseName())) {
                return false;
            }
            Iterable children1 = () -> phase1.getChildren().stream().iterator();
            Iterable children2 = () -> phase2.getChildren().stream().iterator();
            return CollectionsUtil.allMatch(CollectionsUtil.zipLongest(children1, children2), pair -> OptimizationLogCodec.subtreesEqual((OptimizationLog.OptimizationTreeNode)pair.getLeft(), (OptimizationLog.OptimizationTreeNode)pair.getRight()));
        }
        return false;
    }

    protected static final class EncodedOptimizationLog
    implements CompanionObjectEncoder.EncodedObject {
        private Graph optimizationTree;
        private OptimizationLogImpl.OptimizationPhaseNode root;

        protected EncodedOptimizationLog() {
        }
    }
}

