/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.CoreProvidersDelegate;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class ShortCircuitOrNode
extends LogicNode
implements IterableNodeType,
Canonicalizable.Binary<LogicNode> {
    public static final NodeClass<ShortCircuitOrNode> TYPE = NodeClass.create(ShortCircuitOrNode.class);
    @Node.Input(value=InputType.Condition)
    LogicNode x;
    @Node.Input(value=InputType.Condition)
    LogicNode y;
    protected boolean xNegated;
    protected boolean yNegated;
    protected ProfileData.BranchProbabilityData shortCircuitProbability;

    protected ShortCircuitOrNode(LogicNode x, boolean xNegated, LogicNode y, boolean yNegated, ProfileData.BranchProbabilityData shortCircuitProbability) {
        super((NodeClass<? extends LogicNode>)TYPE);
        this.x = x;
        this.xNegated = xNegated;
        this.y = y;
        this.yNegated = yNegated;
        this.shortCircuitProbability = shortCircuitProbability;
    }

    public static LogicNode create(LogicNode x, boolean xNegated, LogicNode y, boolean yNegated, ProfileData.BranchProbabilityData shortCircuitProbability) {
        LogicNode canonical = ShortCircuitOrNode.canonicalize(null, null, shortCircuitProbability, x, xNegated, y, yNegated);
        if (canonical != null) {
            return canonical;
        }
        return new ShortCircuitOrNode(x, xNegated, y, yNegated, shortCircuitProbability);
    }

    @Override
    public LogicNode getX() {
        return this.x;
    }

    @Override
    public LogicNode getY() {
        return this.y;
    }

    public boolean isXNegated() {
        return this.xNegated;
    }

    public boolean isYNegated() {
        return this.yNegated;
    }

    public ProfileData.BranchProbabilityData getShortCircuitProbability() {
        return this.shortCircuitProbability;
    }

    protected static ShortCircuitOrNode canonicalizeNegation(LogicNode forX, boolean xNegated, LogicNode forY, boolean yNegated, ProfileData.BranchProbabilityData shortCircuitProbability) {
        LogicNode xCond = forX;
        boolean xNeg = xNegated;
        while (xCond instanceof LogicNegationNode) {
            xCond = ((LogicNegationNode)xCond).getValue();
            xNeg = !xNeg;
        }
        LogicNode yCond = forY;
        boolean yNeg = yNegated;
        while (yCond instanceof LogicNegationNode) {
            yCond = ((LogicNegationNode)yCond).getValue();
            yNeg = !yNeg;
        }
        if (xCond != forX || yCond != forY) {
            return new ShortCircuitOrNode(xCond, xNeg, yCond, yNeg, shortCircuitProbability);
        }
        return null;
    }

    public LogicNode canonical(CanonicalizerTool tool, LogicNode forX, LogicNode forY) {
        LogicNode canonical = ShortCircuitOrNode.canonicalize(this, tool, this.shortCircuitProbability, forX, this.xNegated, forY, this.yNegated);
        if (canonical != this) {
            return canonical;
        }
        return this;
    }

    private static LogicNode canonicalize(ShortCircuitOrNode self, CanonicalizerTool tool, ProfileData.BranchProbabilityData shortCircuitProbability, LogicNode forX, boolean xNegated, LogicNode forY, boolean yNegated) {
        LogicNode sym;
        ShortCircuitOrNode yNode;
        LogicNode sym2;
        TriState impliedForY;
        ShortCircuitOrNode inner;
        NodeView view;
        ShortCircuitOrNode ret = ShortCircuitOrNode.canonicalizeNegation(forX, xNegated, forY, yNegated, shortCircuitProbability);
        if (ret != self && ret != null) {
            return ret;
        }
        NodeView nodeView = view = tool == null ? NodeView.DEFAULT : NodeView.from(tool);
        if (forX == forY) {
            if (xNegated) {
                if (yNegated) {
                    return LogicNegationNode.create(forX);
                }
                return LogicConstantNode.tautology();
            }
            if (yNegated) {
                return LogicConstantNode.tautology();
            }
            return forX;
        }
        if (forX instanceof LogicConstantNode) {
            if (((LogicConstantNode)forX).getValue() ^ xNegated) {
                return LogicConstantNode.tautology();
            }
            if (yNegated) {
                return LogicNegationNode.create(forY);
            }
            return forY;
        }
        if (forY instanceof LogicConstantNode) {
            if (((LogicConstantNode)forY).getValue() ^ yNegated) {
                return LogicConstantNode.tautology();
            }
            if (xNegated) {
                return LogicNegationNode.create(forX);
            }
            return forX;
        }
        if (forX instanceof ShortCircuitOrNode) {
            inner = (ShortCircuitOrNode)forX;
            if (forY == inner.getX()) {
                return ShortCircuitOrNode.optimizeShortCircuit(inner, xNegated, yNegated, true);
            }
            if (forY == inner.getY()) {
                return ShortCircuitOrNode.optimizeShortCircuit(inner, xNegated, yNegated, false);
            }
        }
        if (forY instanceof ShortCircuitOrNode) {
            inner = (ShortCircuitOrNode)forY;
            if (inner.getX() == forX) {
                return ShortCircuitOrNode.optimizeShortCircuit(inner, yNegated, xNegated, true);
            }
            if (inner.getY() == forX) {
                return ShortCircuitOrNode.optimizeShortCircuit(inner, yNegated, xNegated, false);
            }
        }
        if ((impliedForY = forX.implies(!xNegated, forY)).isKnown()) {
            boolean yResult = impliedForY.toBoolean() ^ yNegated;
            return yResult ? LogicConstantNode.tautology() : (xNegated ? LogicNegationNode.create(forX) : forX);
        }
        if (!xNegated && !yNegated && (sym2 = ShortCircuitOrNode.simplifyComparison(forX, forY)) != null) {
            return sym2;
        }
        if (forX instanceof IntegerBelowNode && forY instanceof IntegerLessThanNode && !xNegated && !yNegated) {
            ValueNode yyNode;
            ValueNode xyNode;
            ValueNode yxNode;
            IntegerBelowNode xNode = (IntegerBelowNode)forX;
            IntegerLessThanNode yNode2 = (IntegerLessThanNode)forY;
            ValueNode xxNode = xNode.getX();
            if (xxNode == (yxNode = yNode2.getX()) && ((IntegerStamp)xxNode.stamp(view)).isPositive() && (xyNode = xNode.getY()) == (yyNode = yNode2.getY())) {
                return forX;
            }
        }
        if (forY instanceof ShortCircuitOrNode && !xNegated && !yNegated && !(yNode = (ShortCircuitOrNode)forY).isXNegated() && (sym = ShortCircuitOrNode.simplifyComparison(forX, yNode.getX())) != null) {
            ProfileData.BranchProbabilityData combinedProfile = ProfileData.BranchProbabilityData.combineShortCircuitOr(shortCircuitProbability, yNode.getShortCircuitProbability());
            return new ShortCircuitOrNode(sym, xNegated, yNode.getY(), yNode.isYNegated(), combinedProfile);
        }
        if (tool != null && forX instanceof CompareNode && forY instanceof CompareNode) {
            ProxyCanonicalizerTool proxyTool;
            ValueNode result;
            Stamp succeedingStampX;
            CompareNode xCompare = (CompareNode)forX;
            CompareNode yCompare = (CompareNode)forY;
            if (!(xCompare.getX() != yCompare.getX() && xCompare.getX() != yCompare.getY() || (succeedingStampX = xCompare.getSucceedingStampForX(!xNegated, xCompare.getX().stamp(view), xCompare.getY().stamp(view))) == null || succeedingStampX.isUnrestricted() || (result = (ValueNode)yCompare.canonical(proxyTool = new ProxyCanonicalizerTool(succeedingStampX, xCompare.getX(), tool, view))) == yCompare)) {
                return ShortCircuitOrNode.create(forX, xNegated, (LogicNode)result, yNegated, shortCircuitProbability);
            }
        }
        return self;
    }

    private static LogicNode simplifyComparison(LogicNode forX, LogicNode forY) {
        LogicNode sym = ShortCircuitOrNode.simplifyComparisonOrdered(forX, forY);
        if (sym == null) {
            return ShortCircuitOrNode.simplifyComparisonOrdered(forY, forX);
        }
        return sym;
    }

    private static LogicNode simplifyComparisonOrdered(LogicNode forX, LogicNode forY) {
        if (forX instanceof IntegerLessThanNode && forY instanceof IntegerLessThanNode) {
            ValueNode yxNode;
            IntegerStamp stamp;
            IntegerLessThanNode xNode = (IntegerLessThanNode)forX;
            IntegerLessThanNode yNode = (IntegerLessThanNode)forY;
            ValueNode xyNode = xNode.getY();
            if (xyNode.isConstant() && IntegerStamp.OPS.getAdd().isNeutral(xyNode.asConstant()) && (stamp = (IntegerStamp)(yxNode = yNode.getX()).stamp(NodeView.DEFAULT)).isPositive() && xNode.getX() == yNode.getY()) {
                ValueNode u = xNode.getX();
                return IntegerBelowNode.create(yxNode, u, NodeView.DEFAULT);
            }
        }
        return null;
    }

    private static LogicNode optimizeShortCircuit(ShortCircuitOrNode inner, boolean innerNegated, boolean matchNegated, boolean matchIsInnerX) {
        boolean innerMatchNegated = matchIsInnerX ? inner.isXNegated() : inner.isYNegated();
        if (!innerNegated) {
            if (innerMatchNegated == matchNegated) {
                return inner;
            }
            return LogicConstantNode.tautology();
        }
        if (innerMatchNegated == matchNegated) {
            boolean newInnerXNegated = inner.isXNegated();
            boolean newInnerYNegated = inner.isYNegated();
            ProfileData.BranchProbabilityData newProbability = inner.getShortCircuitProbability();
            if (matchIsInnerX) {
                newInnerYNegated = !newInnerYNegated;
            } else {
                newInnerXNegated = !newInnerXNegated;
                newProbability = newProbability.negated();
            }
            return new ShortCircuitOrNode(inner.getX(), newInnerXNegated, inner.getY(), newInnerYNegated, newProbability);
        }
        LogicNode result = inner.getY();
        if (matchIsInnerX) {
            result = inner.getX();
        }
        if (matchNegated) {
            return LogicNegationNode.create(result);
        }
        return result;
    }

    private static class ProxyCanonicalizerTool
    extends CoreProvidersDelegate
    implements CanonicalizerTool,
    NodeView {
        private final Stamp stamp;
        private final ValueNode node;
        private final CanonicalizerTool tool;
        private final NodeView view;

        ProxyCanonicalizerTool(Stamp stamp, ValueNode node, CanonicalizerTool tool, NodeView view) {
            super(tool);
            this.stamp = stamp;
            this.node = node;
            this.tool = tool;
            this.view = view;
        }

        @Override
        public Stamp stamp(ValueNode n) {
            if (n == this.node) {
                return this.stamp;
            }
            return this.view.stamp(n);
        }

        @Override
        public Assumptions getAssumptions() {
            return this.tool.getAssumptions();
        }

        @Override
        public boolean canonicalizeReads() {
            return this.tool.canonicalizeReads();
        }

        @Override
        public boolean allUsagesAvailable() {
            return this.tool.allUsagesAvailable();
        }

        @Override
        public Integer smallestCompareWidth() {
            return this.tool.smallestCompareWidth();
        }

        @Override
        public boolean supportsRounding() {
            return this.tool.supportsRounding();
        }

        @Override
        public OptionValues getOptions() {
            return this.tool.getOptions();
        }

        @Override
        public boolean divisionOverflowIsJVMSCompliant() {
            return this.tool.divisionOverflowIsJVMSCompliant();
        }
    }
}

