/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ValueNodeInterface;

public interface StaticDeoptimizingNode
extends ValueNodeInterface {
    public DeoptimizationReason getReason();

    public void setReason(DeoptimizationReason var1);

    public DeoptimizationAction getAction();

    public void setAction(DeoptimizationAction var1);

    public SpeculationLog.Speculation getSpeculation();

    default public GuardPriority computePriority() {
        if (!1.$assertionsDisabled && this.getSpeculation() == null) {
            throw new AssertionError();
        }
        if (!this.getSpeculation().equals((Object)SpeculationLog.NO_SPECULATION)) {
            return GuardPriority.Speculation;
        }
        switch (this.getAction()) {
            case InvalidateReprofile: 
            case InvalidateRecompile: {
                return GuardPriority.Profile;
            }
            case RecompileIfTooManyDeopts: 
            case InvalidateStopCompiling: 
            case None: {
                return GuardPriority.None;
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    public static DeoptimizationAction mergeActions(DeoptimizationAction a1, DeoptimizationAction a2) {
        if (a1 == a2) {
            return a1;
        }
        if (a1 == DeoptimizationAction.InvalidateRecompile && a2 == DeoptimizationAction.InvalidateReprofile || a1 == DeoptimizationAction.InvalidateReprofile && a2 == DeoptimizationAction.InvalidateRecompile) {
            return DeoptimizationAction.InvalidateReprofile;
        }
        return null;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static enum GuardPriority {
        Speculation,
        Profile,
        None;


        public boolean isHigherPriorityThan(GuardPriority other) {
            return this.compareTo(other) < 0;
        }

        public boolean isLowerPriorityThan(GuardPriority other) {
            return this.compareTo(other) > 0;
        }

        public static GuardPriority highest() {
            return Speculation;
        }
    }
}

