/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.CancellationBailoutException;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.JavaMethodContext;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.InliningLog;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.OptimizationLog;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.ProfileProvider;
import org.graalvm.compiler.nodes.spi.ResolvedJavaMethodProfileProvider;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;

public final class StructuredGraph
extends Graph
implements JavaMethodContext {
    public static final long INVALID_GRAPH_ID = -1L;
    private static final AtomicLong uniqueGraphIds = new AtomicLong();
    private StartNode start;
    private final ResolvedJavaMethod rootMethod;
    private final long graphId;
    private final CompilationIdentifier compilationId;
    private final int entryBCI;
    private final ProfileProvider profileProvider;
    private GraphState graphState;
    private final Cancellable cancellable;
    private final boolean isSubstitution;
    private final Assumptions assumptions;
    private ScheduleResult lastSchedule;
    private InliningLog inliningLog;
    private final NodeSourcePosition callerContext;
    private final List<ResolvedJavaMethod> methods;
    private UnsafeAccessState hasUnsafeAccess = UnsafeAccessState.NO_ACCESS;
    public static final boolean USE_PROFILING_INFO = true;
    public static final boolean NO_PROFILING_INFO = false;
    private OptimizationLog optimizationLog;
    private GlobalProfileProvider globalProfileProvider = GlobalProfileProvider.DEFAULT;

    private StructuredGraph(String name, ResolvedJavaMethod method, int entryBCI, Assumptions assumptions, ProfileProvider profileProvider, GraphState graphState, boolean isSubstitution, List<ResolvedJavaMethod> methods, boolean trackNodeSourcePosition, CompilationIdentifier compilationId, OptionValues options, DebugContext debug, Cancellable cancellable, NodeSourcePosition context) {
        super(name, options, debug, trackNodeSourcePosition);
        this.graphState = graphState;
        this.setStart(this.add(new StartNode()));
        this.rootMethod = method;
        this.graphId = uniqueGraphIds.incrementAndGet();
        this.compilationId = compilationId;
        this.entryBCI = entryBCI;
        this.assumptions = assumptions;
        this.methods = methods;
        assert (!isSubstitution || profileProvider == null);
        this.profileProvider = profileProvider;
        this.isSubstitution = isSubstitution;
        assert (StructuredGraph.checkIsSubstitutionInvariants(method, isSubstitution));
        this.cancellable = cancellable;
        this.inliningLog = GraalOptions.TraceInlining.getValue(options) != false || OptimizationLog.isOptimizationLogEnabled(options) ? new InliningLog(this.rootMethod) : null;
        this.callerContext = context;
        this.optimizationLog = OptimizationLog.getInstance(this);
    }

    private static boolean checkIsSubstitutionInvariants(ResolvedJavaMethod method, boolean isSubstitution) {
        if (!Services.IS_IN_NATIVE_IMAGE && !Services.IS_BUILDING_NATIVE_IMAGE && method != null && method.getAnnotation(Snippet.class) != null) assert (isSubstitution) : "Graph for method " + method.format("%H.%n(%p)") + " annotated by " + Snippet.class.getName() + " must have its `isSubstitution` field set to true";
        return true;
    }

    public void setLastSchedule(ScheduleResult result) {
        GraalError.guarantee(result == null || result.cfg.getStartBlock().isModifiable(), "Schedule must use blocks that can be modified");
        this.lastSchedule = result;
    }

    public ScheduleResult getLastSchedule() {
        return this.lastSchedule;
    }

    public void clearLastSchedule() {
        this.setLastSchedule(null);
    }

    @Override
    public void getDebugProperties(Map<Object, Object> properties) {
        super.getDebugProperties(properties);
        properties.put("compilationIdentifier", this.compilationId());
        properties.put("edgeModificationCount", this.getEdgeModificationCount());
        properties.put("assumptions", String.valueOf(this.getAssumptions()));
    }

    @Override
    public void beforeNodeDuplication(Graph sourceGraph) {
        super.beforeNodeDuplication(sourceGraph);
        this.recordAssumptions((StructuredGraph)sourceGraph);
    }

    @Override
    protected Object beforeNodeIdChange(Node node) {
        if (this.inliningLog != null && node instanceof Invokable) {
            return this.inliningLog.unregisterLeafCallsite((Invokable)((Object)node));
        }
        return null;
    }

    @Override
    protected void afterNodeIdChange(Node node, Object value) {
        if (this.inliningLog != null && node instanceof Invokable) {
            this.inliningLog.registerLeafCallsite((Invokable)((Object)node), (InliningLog.Callsite)value);
        }
    }

    @Override
    protected boolean compress(boolean minimizeSize) {
        if (super.compress(minimizeSize)) {
            this.clearLastSchedule();
            return true;
        }
        return false;
    }

    public Stamp getReturnStamp() {
        Stamp returnStamp = null;
        for (ReturnNode returnNode : this.getNodes(ReturnNode.TYPE)) {
            ValueNode result = returnNode.result();
            if (result == null) continue;
            if (returnStamp == null) {
                returnStamp = result.stamp(NodeView.DEFAULT);
                continue;
            }
            returnStamp = returnStamp.meet(result.stamp(NodeView.DEFAULT));
        }
        return returnStamp;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getSimpleName() + ":" + this.graphId);
        String sep = "{";
        if (this.name != null) {
            buf.append(sep);
            buf.append(this.name);
            sep = ", ";
        }
        if (this.method() != null) {
            buf.append(sep);
            buf.append(this.method());
            sep = ", ";
        }
        if (!sep.equals("{")) {
            buf.append("}");
        }
        return buf.toString();
    }

    public StartNode start() {
        return this.start;
    }

    public ResolvedJavaMethod method() {
        return this.rootMethod;
    }

    public int getEntryBCI() {
        return this.entryBCI;
    }

    public GraphState getGraphState() {
        return this.graphState;
    }

    public GraphState.GuardsStage getGuardsStage() {
        return this.getGraphState().getGuardsStage();
    }

    public SpeculationLog getSpeculationLog() {
        return this.getGraphState().getSpeculationLog();
    }

    public boolean isBeforeStage(GraphState.StageFlag stage) {
        return this.getGraphState().isBeforeStage(stage);
    }

    public boolean isAfterStage(GraphState.StageFlag stage) {
        return this.getGraphState().isAfterStage(stage);
    }

    public Cancellable getCancellable() {
        return this.cancellable;
    }

    public void checkCancellation() {
        if (this.cancellable != null && this.cancellable.isCancelled()) {
            CancellationBailoutException.cancelCompilation();
        }
    }

    public boolean isOSR() {
        return this.entryBCI != -1;
    }

    public long graphId() {
        return this.graphId;
    }

    public CompilationIdentifier compilationId() {
        return this.compilationId;
    }

    public void setStart(StartNode start) {
        this.start = start;
    }

    public InliningLog getInliningLog() {
        return this.inliningLog;
    }

    public void notifyInliningDecision(Invokable invoke, boolean positive, String phase, EconomicMap<Node, Node> replacements, InliningLog calleeInliningLog, OptimizationLog calleeOptimizationLog, ResolvedJavaMethod inlineeMethod, String reason, Object ... args) {
        if (this.inliningLog != null) {
            this.inliningLog.addDecision(invoke, positive, phase, replacements, calleeInliningLog, inlineeMethod, reason, args);
        }
        if (positive && calleeOptimizationLog != null && this.optimizationLog.isOptimizationLogEnabled()) {
            FixedNode invokeNode = invoke.asFixedNodeOrNull();
            this.optimizationLog.inline(calleeOptimizationLog, true, invokeNode == null ? null : invokeNode.getNodeSourcePosition());
        }
        if (this.getDebug().hasCompilationListener()) {
            String message = String.format(reason, args);
            this.getDebug().notifyInlining(invoke.getContextMethod(), inlineeMethod, positive, message, invoke.bci());
        }
    }

    public void logInliningTree() {
        String formattedTree;
        if (GraalOptions.TraceInlining.getValue(this.getOptions()).booleanValue() && (formattedTree = this.inliningLog.formatAsTree(true)) != null) {
            TTY.println(formattedTree);
        }
    }

    @Override
    protected Graph copy(String newName, Consumer<UnmodifiableEconomicMap<Node, Node>> duplicationMapCallback, DebugContext debugForCopy) {
        return this.copy(newName, this.rootMethod, this.getOptions(), duplicationMapCallback, this.compilationId, debugForCopy, this.trackNodeSourcePosition);
    }

    public StructuredGraph copy(String newName, Consumer<UnmodifiableEconomicMap<Node, Node>> duplicationMapCallback, DebugContext debugForCopy, OptionValues options) {
        return this.copy(newName, this.rootMethod, options, duplicationMapCallback, this.compilationId, debugForCopy, this.trackNodeSourcePosition);
    }

    private StructuredGraph copy(String newName, ResolvedJavaMethod rootMethodForCopy, OptionValues optionsForCopy, Consumer<UnmodifiableEconomicMap<Node, Node>> duplicationMapCallback, CompilationIdentifier newCompilationId, DebugContext debugForCopy, boolean trackNodeSourcePositionForCopy) {
        EconomicMap<Node, Node> duplicates;
        AllowAssumptions allowAssumptions = this.allowAssumptions();
        StructuredGraph copy = new StructuredGraph(newName, rootMethodForCopy, this.entryBCI, this.assumptions == null ? null : new Assumptions(), this.profileProvider, this.graphState.copy(), this.isSubstitution, this.methods != null ? new ArrayList<ResolvedJavaMethod>(this.methods) : null, trackNodeSourcePositionForCopy, newCompilationId, optionsForCopy, debugForCopy, null, this.callerContext);
        if (allowAssumptions == AllowAssumptions.YES && this.assumptions != null) {
            copy.assumptions.record(this.assumptions);
        }
        copy.hasUnsafeAccess = this.hasUnsafeAccess;
        EconomicMap replacements = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        replacements.put((Object)this.start, (Object)copy.start);
        InliningLog copyInliningLog = copy.getInliningLog();
        try (InliningLog.UpdateScope scope = InliningLog.openDefaultUpdateScope(copyInliningLog);){
            duplicates = copy.addDuplicates(this.getNodes(), (Graph)this, this.getNodeCount(), (UnmodifiableEconomicMap<Node, Node>)replacements);
            if (scope != null) {
                copyInliningLog.replaceLog((UnmodifiableEconomicMap<Node, Node>)duplicates, this.getInliningLog());
            }
        }
        copy.getOptimizationLog().replaceLog(this.optimizationLog);
        if (duplicationMapCallback != null) {
            duplicationMapCallback.accept((UnmodifiableEconomicMap<Node, Node>)duplicates);
        }
        return copy;
    }

    public StructuredGraph copyWithIdentifier(CompilationIdentifier newCompilationId, DebugContext debugForCopy) {
        return this.copy(this.name, this.rootMethod, this.getOptions(), null, newCompilationId, debugForCopy, this.trackNodeSourcePosition);
    }

    public StructuredGraph copy(ResolvedJavaMethod rootMethodForCopy, OptionValues optionsForCopy, DebugContext debugForCopy, boolean trackNodeSourcePositionForCopy) {
        return this.copy(this.name, rootMethodForCopy, optionsForCopy, null, this.compilationId, debugForCopy, trackNodeSourcePositionForCopy);
    }

    public ParameterNode getParameter(int index) {
        for (ParameterNode param : this.getNodes(ParameterNode.TYPE)) {
            if (param.index() != index) continue;
            return param;
        }
        return null;
    }

    public Iterable<Invoke> getInvokes() {
        final Iterator callTargets = this.getNodes(MethodCallTargetNode.TYPE).iterator();
        return new Iterable<Invoke>(){
            private Invoke next;

            @Override
            public Iterator<Invoke> iterator() {
                return new Iterator<Invoke>(){

                    @Override
                    public boolean hasNext() {
                        if (next == null) {
                            while (callTargets.hasNext()) {
                                Invoke i = ((MethodCallTargetNode)callTargets.next()).invoke();
                                if (i == null) continue;
                                next = i;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public Invoke next() {
                        try {
                            Invoke invoke = next;
                            return invoke;
                        }
                        finally {
                            next = null;
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public boolean hasLoops() {
        return this.hasNode(LoopBeginNode.TYPE);
    }

    public void removeFixed(FixedWithNextNode node) {
        assert (node != null);
        if (node instanceof AbstractBeginNode) {
            ((AbstractBeginNode)node).prepareDelete();
        }
        assert (node.hasNoUsages()) : node + " " + node.getUsageCount() + ", " + node.usages().first();
        GraphUtil.unlinkFixedNode(node);
        node.safeDelete();
    }

    public void replaceFixed(FixedWithNextNode node, Node replacement) {
        if (replacement instanceof FixedWithNextNode) {
            this.replaceFixedWithFixed(node, (FixedWithNextNode)replacement);
        } else {
            assert (replacement != null) : "cannot replace " + node + " with null";
            assert (replacement instanceof FloatingNode) : "cannot replace " + node + " with " + replacement;
            this.replaceFixedWithFloating(node, (FloatingNode)replacement);
        }
    }

    public void replaceFixedWithFixed(FixedWithNextNode node, FixedWithNextNode replacement) {
        assert (node != null && replacement != null && node.isAlive() && replacement.isAlive()) : "cannot replace " + node + " with " + replacement;
        FixedNode next = node.next();
        node.setNext(null);
        replacement.setNext(next);
        node.replaceAndDelete(replacement);
        if (node == this.start) {
            this.setStart((StartNode)replacement);
        }
    }

    public void replaceFixedWithFloating(FixedWithNextNode node, ValueNode replacement) {
        assert (node != null && replacement != null && node.isAlive() && replacement.isAlive()) : "cannot replace " + node + " with " + replacement;
        GraphUtil.unlinkFixedNode(node);
        node.replaceAtUsagesAndDelete(replacement);
    }

    public void removeSplit(ControlSplitNode node, AbstractBeginNode survivingSuccessor) {
        assert (node != null);
        assert (node.hasNoUsages());
        assert (survivingSuccessor != null);
        node.clearSuccessors();
        node.replaceAtPredecessor(survivingSuccessor);
        node.safeDelete();
    }

    public void removeSplitPropagate(ControlSplitNode node, AbstractBeginNode survivingSuccessor) {
        assert (node != null);
        assert (node.hasNoUsages());
        assert (survivingSuccessor != null);
        List<Node> snapshot = node.successors().snapshot();
        node.clearSuccessors();
        node.replaceAtPredecessor(survivingSuccessor);
        node.safeDelete();
        for (Node successor : snapshot) {
            if (successor == null || !successor.isAlive() || successor == survivingSuccessor) continue;
            GraphUtil.killCFG((FixedNode)successor);
        }
    }

    public void replaceSplit(ControlSplitNode node, Node replacement, AbstractBeginNode survivingSuccessor) {
        if (replacement instanceof FixedWithNextNode) {
            this.replaceSplitWithFixed(node, (FixedWithNextNode)replacement, survivingSuccessor);
        } else {
            assert (replacement != null) : "cannot replace " + node + " with null";
            assert (replacement instanceof FloatingNode) : "cannot replace " + node + " with " + replacement;
            this.replaceSplitWithFloating(node, (FloatingNode)replacement, survivingSuccessor);
        }
    }

    public void replaceSplitWithFixed(ControlSplitNode node, FixedWithNextNode replacement, AbstractBeginNode survivingSuccessor) {
        assert (node != null && replacement != null && node.isAlive() && replacement.isAlive()) : "cannot replace " + node + " with " + replacement;
        assert (survivingSuccessor != null);
        node.clearSuccessors();
        replacement.setNext(survivingSuccessor);
        node.replaceAndDelete(replacement);
    }

    public void replaceSplitWithFloating(ControlSplitNode node, FloatingNode replacement, AbstractBeginNode survivingSuccessor) {
        assert (node != null && replacement != null && node.isAlive() && replacement.isAlive()) : "cannot replace " + node + " with " + replacement;
        assert (survivingSuccessor != null);
        node.clearSuccessors();
        node.replaceAtPredecessor(survivingSuccessor);
        node.replaceAtUsagesAndDelete(replacement);
    }

    public void replaceWithExceptionSplit(WithExceptionNode node, WithExceptionNode replacement) {
        assert (node != null && replacement != null && node.isAlive() && replacement.isAlive()) : "cannot replace " + node + " with " + replacement;
        node.replaceAtPredecessor(replacement);
        AbstractBeginNode next = node.next();
        AbstractBeginNode exceptionEdge = node.exceptionEdge();
        node.replaceAtUsagesAndDelete(replacement);
        if (next instanceof LoopExitNode) {
            BeginNode newNextBegin = this.add(new BeginNode());
            newNextBegin.setNext(next);
            next = newNextBegin;
        }
        if (exceptionEdge instanceof LoopExitNode) {
            BeginNode newExceptionEdgeBegin = this.add(new BeginNode());
            newExceptionEdgeBegin.setNext(exceptionEdge);
            exceptionEdge = newExceptionEdgeBegin;
        }
        replacement.setNext(next);
        replacement.setExceptionEdge(exceptionEdge);
    }

    public void addAfterFixed(FixedWithNextNode node, FixedNode newNode) {
        assert (node != null && newNode != null && node.isAlive() && newNode.isAlive()) : "cannot add " + newNode + " after " + node;
        FixedNode next = node.next();
        node.setNext(newNode);
        if (next != null) {
            assert (newNode instanceof FixedWithNextNode);
            FixedWithNextNode newFixedWithNext = (FixedWithNextNode)newNode;
            assert (newFixedWithNext.next() == null);
            newFixedWithNext.setNext(next);
        }
    }

    public void addBeforeFixed(FixedNode node, FixedWithNextNode newNode) {
        assert (node != null && newNode != null && node.isAlive() && newNode.isAlive()) : "cannot add " + newNode + " before " + node;
        assert (node.predecessor() != null && node.predecessor() instanceof FixedWithNextNode) : "cannot add " + newNode + " before " + node;
        assert (newNode.next() == null) : newNode;
        assert (!(node instanceof AbstractMergeNode));
        FixedWithNextNode pred = (FixedWithNextNode)node.predecessor();
        pred.setNext(newNode);
        newNode.setNext(node);
    }

    public void reduceDegenerateLoopBegin(LoopBeginNode begin) {
        this.reduceDegenerateLoopBegin(begin, false);
    }

    public void reduceDegenerateLoopBegin(LoopBeginNode begin, boolean forKillCFG) {
        assert (begin.loopEnds().isEmpty()) : "Loop begin still has backedges";
        if (begin.forwardEndCount() == 1) {
            this.reduceTrivialMerge(begin, forKillCFG);
        } else {
            AbstractMergeNode merge = this.add(new MergeNode());
            for (EndNode end : begin.forwardEnds()) {
                merge.addForwardEnd(end);
            }
            this.replaceFixedWithFixed(begin, merge);
        }
    }

    public void reduceTrivialMerge(AbstractMergeNode merge) {
        this.reduceTrivialMerge(merge, false);
    }

    public void reduceTrivialMerge(AbstractMergeNode merge, boolean forKillCFG) {
        assert (merge.forwardEndCount() == 1);
        assert (!(merge instanceof LoopBeginNode) || ((LoopBeginNode)merge).loopEnds().isEmpty());
        for (PhiNode phi : merge.phis().snapshot()) {
            assert (phi.valueCount() == 1);
            ValueNode singleValue = phi.valueAt(0);
            if (phi.hasUsages()) {
                phi.replaceAtUsagesAndDelete(singleValue);
                continue;
            }
            phi.safeDelete();
            if (singleValue == null) continue;
            GraphUtil.tryKillUnused(singleValue);
        }
        if (merge instanceof LoopBeginNode) {
            ((LoopBeginNode)merge).removeExits(forKillCFG);
        }
        EndNode singleEnd = merge.forwardEndAt(0);
        FixedNode sux = merge.next();
        FrameState stateAfter = merge.stateAfter();
        merge.prepareDelete((FixedNode)singleEnd.predecessor());
        merge.safeDelete();
        if (stateAfter != null) {
            GraphUtil.tryKillUnused(stateAfter);
        }
        if (sux == null) {
            singleEnd.replaceAtPredecessor(null);
            singleEnd.safeDelete();
        } else {
            singleEnd.replaceAndDelete(sux);
        }
    }

    public ProfileProvider getProfileProvider() {
        return this.profileProvider;
    }

    public boolean isSubstitution() {
        return this.isSubstitution;
    }

    public ProfilingInfo getProfilingInfo() {
        return this.getProfilingInfo(this.method());
    }

    public ProfilingInfo getProfilingInfo(ResolvedJavaMethod m) {
        if (this.profileProvider != null && m != null) {
            return this.profileProvider.getProfilingInfo(m);
        }
        return null;
    }

    public Assumptions getAssumptions() {
        return this.assumptions;
    }

    public AllowAssumptions allowAssumptions() {
        return AllowAssumptions.ifNonNull(this.assumptions);
    }

    public void recordAssumptions(StructuredGraph inlineGraph) {
        if (this.getAssumptions() != null) {
            if (this != inlineGraph && inlineGraph.getAssumptions() != null) {
                this.getAssumptions().record(inlineGraph.getAssumptions());
            }
        } else assert (inlineGraph.getAssumptions() == null) : String.format("cannot inline graph (%s) which makes assumptions into a graph (%s) that doesn't", inlineGraph, this);
    }

    private boolean checkFrameStatesAgainstInlinedMethods() {
        for (FrameState fs : this.getNodes(FrameState.TYPE)) {
            ResolvedJavaMethod m;
            if (BytecodeFrame.isPlaceholderBci((int)fs.bci) || (m = fs.getCode().getMethod()).equals(this.rootMethod) || this.methods.contains(m)) continue;
            TreeSet<String> haystack = new TreeSet<String>();
            if (!this.methods.contains(this.rootMethod)) {
                haystack.add(this.rootMethod.format("%H.%n(%p)"));
            }
            for (ResolvedJavaMethod e : this.methods) {
                haystack.add(e.format("%H.%n(%p)"));
            }
            throw new AssertionError((Object)String.format("Could not find %s from %s in set(%s)", m.format("%H.%n(%p)"), fs, haystack.stream().collect(Collectors.joining(System.lineSeparator()))));
        }
        return true;
    }

    public List<ResolvedJavaMethod> getMethods() {
        if (this.methods != null) {
            assert (this.isSubstitution || this.checkFrameStatesAgainstInlinedMethods());
            return Collections.unmodifiableList(this.methods);
        }
        return Collections.emptyList();
    }

    public void recordMethod(ResolvedJavaMethod method) {
        if (this.methods != null) {
            this.methods.add(method);
        }
    }

    public void updateMethods(StructuredGraph other) {
        if (this.methods != null) {
            if (other.rootMethod != null) {
                this.methods.add(other.rootMethod);
            }
            for (ResolvedJavaMethod m : other.methods) {
                this.methods.add(m);
            }
        }
    }

    public int getBytecodeSize() {
        int res = 0;
        if (this.rootMethod != null) {
            res += this.rootMethod.getCodeSize();
        }
        if (this.methods != null) {
            for (ResolvedJavaMethod e : this.methods) {
                res += e.getCodeSize();
            }
        }
        return res;
    }

    @Override
    public JavaMethod asJavaMethod() {
        return this.method();
    }

    public boolean hasUnsafeAccess() {
        return this.hasUnsafeAccess == UnsafeAccessState.HAS_ACCESS;
    }

    public void markUnsafeAccess() {
        if (this.hasUnsafeAccess == UnsafeAccessState.DISABLED) {
            return;
        }
        this.hasUnsafeAccess = UnsafeAccessState.HAS_ACCESS;
    }

    public void disableUnsafeAccessTracking() {
        this.hasUnsafeAccess = UnsafeAccessState.DISABLED;
    }

    public boolean isUnsafeAccessTrackingEnabled() {
        return this.hasUnsafeAccess != UnsafeAccessState.DISABLED;
    }

    public void clearAllStateAfterForTestingOnly() {
        this.graphState.weakenFrameStateVerification(GraphState.FrameStateVerification.NONE);
        for (Node node : this.getNodes()) {
            FrameState stateAfter;
            if (!(node instanceof StateSplit) || (stateAfter = ((StateSplit)((Object)node)).stateAfter()) == null) continue;
            assert (!(node instanceof ExceptionObjectNode)) : "ExceptionObjects cannot have a null FrameState";
            ((StateSplit)((Object)node)).setStateAfter(null);
            if (!stateAfter.isAlive()) continue;
            GraphUtil.killWithUnusedFloatingInputs(stateAfter);
        }
        this.graphState.forceDisableFrameStateVerification();
    }

    public boolean hasVirtualizableAllocation() {
        for (Node n : this.getNodes()) {
            if (!(n instanceof VirtualizableAllocation)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void afterRegister(Node node) {
        assert (!this.graphState.isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) || !(node instanceof ValueProxyNode));
        if (this.inliningLog != null && node instanceof Invokable) {
            ((Invokable)((Object)node)).updateInliningLogAfterRegister(this);
        }
    }

    public NodeSourcePosition getCallerContext() {
        return this.callerContext;
    }

    public OptimizationLog getOptimizationLog() {
        return this.optimizationLog;
    }

    public void setGlobalProfileProvider(GlobalProfileProvider globalProfileProvider) {
        Objects.requireNonNull(globalProfileProvider);
        this.globalProfileProvider = globalProfileProvider;
    }

    public GlobalProfileProvider globalProfileProvider() {
        return this.globalProfileProvider;
    }

    public void setOptimizationLog(OptimizationLog newOptimizationLog) {
        assert (newOptimizationLog != null) : "the optimization log must not be null";
        this.optimizationLog = newOptimizationLog;
    }

    public void setInliningLog(InliningLog newInliningLog) {
        assert (this.inliningLog == null == (newInliningLog == null)) : "the new inlining log must be null iff the previous is null";
        this.inliningLog = newInliningLog;
    }

    private static enum UnsafeAccessState {
        NO_ACCESS,
        HAS_ACCESS,
        DISABLED;

    }

    public static interface GlobalProfileProvider {
        public static final GlobalProfileProvider DEFAULT = new GlobalProfileProvider(){
            public static final int DEFAULT_TIME = -1;

            @Override
            public double getGlobalSelfTimePercent() {
                return -1.0;
            }

            @Override
            public boolean hotCaller() {
                return false;
            }
        };

        public double getGlobalSelfTimePercent();

        public boolean hotCaller();
    }

    public static class ScheduleResult {
        private final ControlFlowGraph cfg;
        private final NodeMap<HIRBlock> nodeToBlockMap;
        private final BlockMap<List<Node>> blockToNodesMap;

        public ScheduleResult(ControlFlowGraph cfg, NodeMap<HIRBlock> nodeToBlockMap, BlockMap<List<Node>> blockToNodesMap) {
            this.cfg = cfg;
            this.nodeToBlockMap = nodeToBlockMap;
            this.blockToNodesMap = blockToNodesMap;
        }

        public ControlFlowGraph getCFG() {
            return this.cfg;
        }

        public NodeMap<HIRBlock> getNodeToBlockMap() {
            return this.nodeToBlockMap;
        }

        public BlockMap<List<Node>> getBlockToNodesMap() {
            return this.blockToNodesMap;
        }

        public List<Node> nodesFor(HIRBlock block) {
            return this.blockToNodesMap.get(block);
        }
    }

    public static enum AllowAssumptions {
        YES,
        NO;


        public static AllowAssumptions ifTrue(boolean flag) {
            return flag ? YES : NO;
        }

        public static AllowAssumptions ifNonNull(Assumptions assumptions) {
            return assumptions != null ? YES : NO;
        }
    }

    public static class Builder {
        private String name;
        private final Assumptions assumptions;
        private SpeculationLog speculationLog;
        private ResolvedJavaMethod rootMethod;
        private CompilationIdentifier compilationId = CompilationIdentifier.INVALID_COMPILATION_ID;
        private int entryBCI = -1;
        private ProfileProvider profileProvider = new ResolvedJavaMethodProfileProvider();
        private boolean recordInlinedMethods = true;
        private boolean trackNodeSourcePosition;
        private final OptionValues options;
        private Cancellable cancellable = null;
        private final DebugContext debug;
        private NodeSourcePosition callerContext;
        private boolean isSubstitution;

        public Builder(OptionValues options, DebugContext debug, AllowAssumptions allowAssumptions) {
            this.options = options;
            this.debug = debug;
            this.assumptions = allowAssumptions == AllowAssumptions.YES ? new Assumptions() : null;
            this.trackNodeSourcePosition = Graph.trackNodeSourcePositionDefault(options, debug);
        }

        public Builder(OptionValues options, DebugContext debug) {
            this.options = options;
            this.debug = debug;
            this.assumptions = null;
            this.trackNodeSourcePosition = Graph.trackNodeSourcePositionDefault(options, debug);
        }

        public Builder name(String s) {
            this.name = s;
            return this;
        }

        public Builder setIsSubstitution(boolean flag) {
            this.isSubstitution = flag;
            if (this.isSubstitution) {
                this.profileProvider = null;
            }
            return this;
        }

        public ResolvedJavaMethod getMethod() {
            return this.rootMethod;
        }

        public Builder method(ResolvedJavaMethod method) {
            this.rootMethod = method;
            return this;
        }

        public Builder speculationLog(SpeculationLog log) {
            this.speculationLog = log;
            return this;
        }

        public CompilationIdentifier getCompilationId() {
            return this.compilationId;
        }

        public Builder compilationId(CompilationIdentifier id) {
            this.compilationId = id;
            return this;
        }

        public Cancellable getCancellable() {
            return this.cancellable;
        }

        public Builder cancellable(Cancellable cancel) {
            this.cancellable = cancel;
            return this;
        }

        public Builder entryBCI(int bci) {
            this.entryBCI = bci;
            return this;
        }

        public Builder profileProvider(ProfileProvider provider) {
            this.profileProvider = provider;
            return this;
        }

        public Builder recordInlinedMethods(boolean flag) {
            this.recordInlinedMethods = flag;
            return this;
        }

        public Builder trackNodeSourcePosition(boolean flag) {
            if (flag) {
                this.trackNodeSourcePosition = true;
            }
            return this;
        }

        public Builder callerContext(NodeSourcePosition context) {
            this.callerContext = context;
            return this;
        }

        public StructuredGraph build() {
            GraphState newGraphState = GraphState.defaultGraphState();
            ArrayList<ResolvedJavaMethod> inlinedMethods = this.recordInlinedMethods ? new ArrayList<ResolvedJavaMethod>() : null;
            return new StructuredGraph(this.name, this.rootMethod, this.entryBCI, this.assumptions, this.profileProvider, newGraphState.copyWith(this.isSubstitution, this.speculationLog), this.isSubstitution, inlinedMethods, this.trackNodeSourcePosition, this.compilationId, this.options, this.debug, this.cancellable, this.callerContext);
        }
    }
}

