/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class FloatTypeTestNode
extends UnaryNode
implements ArithmeticLIRLowerable {
    public static final NodeClass<FloatTypeTestNode> TYPE = NodeClass.create(FloatTypeTestNode.class);
    private final FloatTypeTestOp op;

    public FloatTypeTestNode(ValueNode value, FloatTypeTestOp op) {
        super(TYPE, StampFactory.forKind(JavaKind.Boolean), value);
        GraalError.guarantee(value.getStackKind().isNumericFloat(), "float type test on incompatible value %s", (Object)value);
        this.op = op;
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forValue) {
        switch (forValue.getStackKind()) {
            case Float: {
                if (!forValue.isJavaConstant()) break;
                switch (this.op) {
                    case IS_FINITE: {
                        return ConstantNode.forBoolean(Float.isFinite(forValue.asJavaConstant().asFloat()));
                    }
                    case IS_INFINITE: {
                        return ConstantNode.forBoolean(Float.isInfinite(forValue.asJavaConstant().asFloat()));
                    }
                }
                break;
            }
            case Double: {
                if (!forValue.isJavaConstant()) break;
                switch (this.op) {
                    case IS_FINITE: {
                        return ConstantNode.forBoolean(Double.isFinite(forValue.asJavaConstant().asDouble()));
                    }
                    case IS_INFINITE: {
                        return ConstantNode.forBoolean(Double.isInfinite(forValue.asJavaConstant().asDouble()));
                    }
                }
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("incompatible value " + forValue);
            }
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        switch (this.op) {
            case IS_INFINITE: {
                nodeValueMap.setResult(this, gen.emitFloatIsInfinite(nodeValueMap.operand(this.getValue())));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("unimplemented float type test op " + this.op);
            }
        }
    }

    public static enum FloatTypeTestOp {
        IS_INFINITE,
        IS_FINITE;

    }
}

