/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AbstractNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo
public final class IntegerNormalizeCompareNode
extends AbstractNormalizeCompareNode {
    public static final NodeClass<IntegerNormalizeCompareNode> TYPE = NodeClass.create(IntegerNormalizeCompareNode.class);
    protected final boolean unsigned;

    public IntegerNormalizeCompareNode(ValueNode x, ValueNode y, JavaKind kind, boolean unsigned) {
        super(TYPE, kind, x, y);
        this.unsigned = unsigned;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public static ValueNode create(ValueNode x, ValueNode y, boolean unsigned, JavaKind kind, ConstantReflectionProvider constantReflection) {
        ValueNode result = IntegerNormalizeCompareNode.tryConstantFold(x, y, false, unsigned, kind, constantReflection);
        if (result != null) {
            return result;
        }
        return new IntegerNormalizeCompareNode(x, y, kind, unsigned);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode result = IntegerNormalizeCompareNode.tryConstantFold(this.x, this.y, false, this.unsigned, this.stamp(view).getStackKind(), tool.getConstantReflection());
        if (result != null) {
            return result;
        }
        return this;
    }

    @Override
    public LogicNode createLowerComparison(boolean swapInputs) {
        ValueNode b;
        ValueNode a = swapInputs ? this.y : this.x;
        ValueNode valueNode = b = swapInputs ? this.x : this.y;
        if (this.unsigned) {
            return IntegerBelowNode.create(a, b, NodeView.DEFAULT);
        }
        return IntegerLessThanNode.create(a, b, NodeView.DEFAULT);
    }

    @Override
    public LogicNode createLowerComparison(boolean swapInputs, ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, NodeView view) {
        ValueNode b;
        ValueNode a = swapInputs ? this.y : this.x;
        ValueNode valueNode = b = swapInputs ? this.x : this.y;
        if (this.unsigned) {
            return IntegerBelowNode.create(constantReflection, metaAccess, options, smallestCompareWidth, a, b, NodeView.DEFAULT);
        }
        return IntegerLessThanNode.create(constantReflection, metaAccess, options, smallestCompareWidth, a, b, NodeView.DEFAULT);
    }

    @Override
    public LogicNode createEqualComparison() {
        return IntegerEqualsNode.create(this.x, this.y, NodeView.DEFAULT);
    }

    @Override
    public LogicNode createEqualComparison(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, NodeView view) {
        return IntegerEqualsNode.create(constantReflection, metaAccess, options, smallestCompareWidth, this.x, this.y, view);
    }
}

