/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.cfg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.compiler.core.common.cfg.BasicBlock;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRLoop;
import org.graalvm.compiler.nodes.cfg.LocationSet;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.word.LocationIdentity;

public abstract class HIRBlock
extends BasicBlock<HIRBlock> {
    protected final AbstractBeginNode beginNode;
    protected FixedNode endNode;
    protected double relativeFrequency = -1.0;
    protected ProfileData.ProfileSource frequencySource;
    protected Loop<HIRBlock> loop;
    protected int numBackedges = -1;
    protected int postdominator = Integer.MAX_VALUE;
    private LocationSet killLocations;
    private LocationSet killLocationsBetweenThisAndDominator;

    HIRBlock(AbstractBeginNode node, ControlFlowGraph cfg) {
        super(cfg);
        this.beginNode = node;
    }

    public AbstractBeginNode getBeginNode() {
        return this.beginNode;
    }

    public FixedNode getEndNode() {
        return this.endNode;
    }

    @Override
    public Loop<HIRBlock> getLoop() {
        return this.loop;
    }

    public void setLoop(Loop<HIRBlock> loop) {
        this.loop = loop;
        this.numBackedges = this.isLoopHeader() ? loop.numBackedges() : -1;
    }

    @Override
    public int getLoopDepth() {
        return this.loop == null ? 0 : this.loop.getDepth();
    }

    @Override
    public boolean isLoopHeader() {
        return this.getBeginNode() instanceof LoopBeginNode;
    }

    @Override
    public int numBackedges() {
        return this.numBackedges;
    }

    @Override
    public boolean isLoopEnd() {
        return this.getEndNode() instanceof LoopEndNode;
    }

    @Override
    public boolean isExceptionEntry() {
        Node predecessor = this.getBeginNode().predecessor();
        return predecessor != null && predecessor instanceof WithExceptionNode && this.getBeginNode() == ((WithExceptionNode)predecessor).exceptionEdge();
    }

    public HIRBlock getFirstPredecessor() {
        return (HIRBlock)this.getPredecessorAt(0);
    }

    public HIRBlock getFirstSuccessor() {
        return (HIRBlock)this.getSuccessorAt(0);
    }

    @Override
    public HIRBlock getPostdominator() {
        return this.postdominator != Integer.MAX_VALUE ? ((HIRBlock[])this.getBlocks())[this.postdominator] : null;
    }

    @Override
    public boolean isModifiable() {
        return this instanceof ModifiableBlock;
    }

    public Iterable<FixedNode> getNodes() {
        return new Iterable<FixedNode>(){

            @Override
            public Iterator<FixedNode> iterator() {
                return new NodeIterator();
            }

            public String toString() {
                StringBuilder str = new StringBuilder().append('[');
                for (FixedNode node : this) {
                    str.append(node).append(", ");
                }
                if (str.length() > 1) {
                    str.setLength(str.length() - 2);
                }
                return str.append(']').toString();
            }
        };
    }

    @Override
    public String toString() {
        return this.toString(Verbosity.Id);
    }

    public String toString(Verbosity verbosity) {
        StringBuilder sb = new StringBuilder();
        sb.append('B').append(this.id);
        if (verbosity == Verbosity.Name) {
            sb.append("{");
            sb.append(this.getBeginNode());
            sb.append("->");
            sb.append(this.getEndNode());
            sb.append("}");
        } else if (verbosity != Verbosity.Id) {
            int i;
            if (this.isLoopHeader()) {
                sb.append(" lh");
            }
            if (this.getSuccessorCount() > 0) {
                sb.append(" ->[");
                for (i = 0; i < this.getSuccessorCount(); ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append('B').append(((HIRBlock)this.getSuccessorAt(i)).getId());
                }
                sb.append(']');
            }
            if (this.getPredecessorCount() > 0) {
                sb.append(" <-[");
                for (i = 0; i < this.getPredecessorCount(); ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append('B').append(((HIRBlock)this.getPredecessorAt(i)).getId());
                }
                sb.append(']');
            }
        }
        return sb.toString();
    }

    @Override
    public double getRelativeFrequency() {
        return this.relativeFrequency;
    }

    public void setRelativeFrequency(double relativeFrequency) {
        assert (relativeFrequency >= 0.0 && Double.isFinite(relativeFrequency)) : "Relative Frequency=" + relativeFrequency;
        this.relativeFrequency = relativeFrequency;
    }

    public void setFrequencySource(ProfileData.ProfileSource frequencySource) {
        this.frequencySource = frequencySource;
    }

    public ProfileData.ProfileSource getFrequencySource() {
        return this.frequencySource;
    }

    @Override
    public HIRBlock getDominator(int distance) {
        HIRBlock result = this;
        for (int i = 0; i < distance; ++i) {
            result = (HIRBlock)result.getDominator();
        }
        return result;
    }

    public boolean canKill(LocationIdentity location) {
        if (location.isImmutable()) {
            return false;
        }
        return this.getKillLocations().contains(location);
    }

    public LocationSet getKillLocations() {
        if (this.killLocations == null) {
            this.killLocations = this.calcKillLocations();
        }
        return this.killLocations;
    }

    private LocationSet calcKillLocations() {
        LocationSet result = new LocationSet();
        for (FixedNode node : this.getNodes()) {
            if (MemoryKill.isSingleMemoryKill(node)) {
                LocationIdentity identity = ((SingleMemoryKill)((Object)node)).getKilledLocationIdentity();
                result.add(identity);
            } else if (MemoryKill.isMultiMemoryKill(node)) {
                for (LocationIdentity identity : ((MultiMemoryKill)((Object)node)).getKilledLocationIdentities()) {
                    result.add(identity);
                }
            }
            if (!result.isAny()) continue;
            break;
        }
        return result;
    }

    public boolean canKillBetweenThisAndDominator(LocationIdentity location) {
        if (location.isImmutable()) {
            return false;
        }
        return this.getKillLocationsBetweenThisAndDominator().contains(location);
    }

    private LocationSet getKillLocationsBetweenThisAndDominator() {
        if (this.killLocationsBetweenThisAndDominator == null) {
            LocationSet dominatorResult = new LocationSet();
            HIRBlock stopBlock = (HIRBlock)this.getDominator();
            if (this.isLoopHeader()) {
                assert (stopBlock.getLoopDepth() < this.getLoopDepth());
                dominatorResult.addAll(((HIRLoop)this.getLoop()).getKillLocations());
            } else {
                for (int i = 0; i < this.getPredecessorCount(); ++i) {
                    HIRBlock b = (HIRBlock)this.getPredecessorAt(i);
                    assert (!this.isLoopHeader());
                    if (b == stopBlock) continue;
                    dominatorResult.addAll(b.getKillLocations());
                    if (dominatorResult.isAny()) break;
                    b.calcKillLocationsBetweenThisAndTarget(dominatorResult, stopBlock);
                    if (dominatorResult.isAny()) break;
                }
            }
            this.killLocationsBetweenThisAndDominator = dominatorResult;
        }
        return this.killLocationsBetweenThisAndDominator;
    }

    private void calcKillLocationsBetweenThisAndTarget(LocationSet result, HIRBlock stopBlock) {
        assert (stopBlock.dominates(this));
        if (stopBlock == this || result.isAny()) {
            return;
        }
        if (stopBlock == this.getDominator()) {
            result.addAll(this.getKillLocationsBetweenThisAndDominator());
        } else {
            this.calcKillLocationsBetweenThisAndTarget(result, (HIRBlock)this.getDominator());
            result.addAll(((HIRBlock)this.getDominator()).getKillLocations());
            if (result.isAny()) {
                return;
            }
            ((HIRBlock)this.getDominator()).calcKillLocationsBetweenThisAndTarget(result, stopBlock);
        }
    }

    protected void setPostDominator(HIRBlock postdominator) {
        if (postdominator != null) {
            this.postdominator = postdominator.getId();
        }
    }

    public boolean isInSameOrOuterLoopOf(HIRBlock block) {
        if (this.loop == null) {
            return true;
        }
        for (Loop<HIRBlock> l = block.loop; l != null; l = l.getParent()) {
            if (l != this.loop) continue;
            return true;
        }
        return false;
    }

    public static void computeLoopPredecessors(NodeMap<HIRBlock> nodeMap, ModifiableBlock block, LoopBeginNode loopBeginNode) {
        int i;
        int forwardEndCount = loopBeginNode.forwardEndCount();
        LoopEndNode[] loopEnds = loopBeginNode.orderedLoopEnds();
        int firstPredecessor = nodeMap.get(loopBeginNode.forwardEndAt(0)).getId();
        int[] extraPredecessors = new int[forwardEndCount + loopEnds.length - 1];
        for (i = 1; i < forwardEndCount; ++i) {
            extraPredecessors[i - 1] = nodeMap.get(loopBeginNode.forwardEndAt(i)).getId();
        }
        for (i = 0; i < loopEnds.length; ++i) {
            extraPredecessors[i + forwardEndCount - 1] = nodeMap.get(loopEnds[i]).getId();
        }
        block.setPredecessors(firstPredecessor, extraPredecessors);
    }

    public static void assignPredecessorsAndSuccessors(HIRBlock[] blocks, ControlFlowGraph cfg) {
        for (int bI = 0; bI < blocks.length; ++bI) {
            ModifiableBlock b = (ModifiableBlock)blocks[bI];
            FixedNode blockEndNode = b.getEndNode();
            if (blockEndNode instanceof EndNode) {
                EndNode endNode = (EndNode)blockEndNode;
                HIRBlock suxBlock = cfg.getNodeToBlock().get(endNode.merge());
                b.setSuccessor(suxBlock.getId());
            } else if (blockEndNode instanceof ControlSplitNode) {
                ControlSplitNode split = (ControlSplitNode)blockEndNode;
                int splitSuccessorcount = split.getSuccessorCount();
                int index = 0;
                int succ0 = Integer.MAX_VALUE;
                int succ1 = Integer.MAX_VALUE;
                int[] extraSucc = splitSuccessorcount > 2 ? new int[split.getSuccessorCount() - 2] : null;
                for (Node sux : blockEndNode.successors()) {
                    ModifiableBlock sucBlock = (ModifiableBlock)cfg.getNodeToBlock().get(sux);
                    if (index == 0) {
                        succ0 = sucBlock.getId();
                    } else if (index == 1) {
                        succ1 = sucBlock.getId();
                    } else {
                        extraSucc[index - 2] = sucBlock.getId();
                    }
                    ++index;
                    sucBlock.setPredecessor(b.getId());
                }
                double[] succP = ((ControlSplitNode)blockEndNode).successorProbabilities();
                if (splitSuccessorcount == 1) {
                    b.setSuccessor(succ0);
                } else if (splitSuccessorcount == 2) {
                    assert (succP.length == 2);
                    b.setSuccessors(succ0, succ1, succP[0], succP[1]);
                } else {
                    assert (succP.length > 2);
                    b.setSuccessors(succ0, succ1, extraSucc, succP[0], succP[1], Arrays.copyOfRange(succP, 2, succP.length));
                }
            } else if (blockEndNode instanceof LoopEndNode) {
                LoopEndNode loopEndNode = (LoopEndNode)blockEndNode;
                b.setSuccessor(cfg.getNodeToBlock().get(loopEndNode.loopBegin()).getId());
            } else if (!(blockEndNode instanceof ControlSinkNode)) {
                assert (!(blockEndNode instanceof AbstractEndNode)) : "Algorithm only supports EndNode and LoopEndNode.";
                for (Node suxNode : blockEndNode.successors()) {
                    ModifiableBlock sux = (ModifiableBlock)cfg.getNodeToBlock().get(suxNode);
                    sux.setPredecessor(b.getId());
                }
                assert (blockEndNode.successors().count() == 1) : "Node " + blockEndNode;
                HIRBlock sequentialSuc = cfg.getNodeToBlock().get(blockEndNode.successors().first());
                b.setSuccessor(sequentialSuc.getId());
            }
            AbstractBeginNode blockBeginNode = b.getBeginNode();
            if (blockBeginNode instanceof LoopBeginNode) {
                HIRBlock.computeLoopPredecessors(cfg.getNodeToBlock(), b, (LoopBeginNode)blockBeginNode);
                continue;
            }
            if (!(blockBeginNode instanceof AbstractMergeNode)) continue;
            AbstractMergeNode mergeNode = (AbstractMergeNode)blockBeginNode;
            int forwardEndCount = mergeNode.forwardEndCount();
            int[] extraPred = new int[forwardEndCount - 1];
            int pred0 = cfg.getNodeToBlock().get(mergeNode.forwardEndAt(0)).getId();
            for (int i = 1; i < forwardEndCount; ++i) {
                extraPred[i - 1] = cfg.getNodeToBlock().get(mergeNode.forwardEndAt(i)).getId();
            }
            b.setPredecessors(pred0, extraPred);
        }
    }

    static class ModifiableBlock
    extends HIRBlock {
        private boolean align;
        private int linearScanNumber = -1;
        private boolean markedAsLoopEnd = false;
        private int firstPredecessor = Integer.MAX_VALUE;
        private int[] extraPredecessors;
        private int firstSuccessor = Integer.MAX_VALUE;
        private int secondSuccessor = Integer.MAX_VALUE;
        private int[] extraSuccessors;
        private double firstSuccessorProbability;
        private double secondSuccessorProbability;
        private double[] extraSuccessorsProbabilities;

        ModifiableBlock(AbstractBeginNode node, ControlFlowGraph cfg) {
            super(node, cfg);
        }

        @Override
        public boolean isLoopEnd() {
            return this.markedAsLoopEnd || super.isLoopEnd();
        }

        public void markAsLoopEnd() {
            this.markedAsLoopEnd = true;
        }

        @Override
        public int getLinearScanNumber() {
            return this.linearScanNumber;
        }

        @Override
        public void setLinearScanNumber(int linearScanNumber) {
            this.linearScanNumber = linearScanNumber;
        }

        @Override
        public boolean isAligned() {
            return this.align;
        }

        @Override
        public void setAlign(boolean align) {
            this.align = align;
        }

        @Override
        public int getPredecessorCount() {
            return ModifiableBlock.getCount(this.firstPredecessor, this.extraPredecessors);
        }

        @Override
        public int getSuccessorCount() {
            return ModifiableBlock.getCount(this.firstSuccessor, this.secondSuccessor, this.extraSuccessors);
        }

        private static int getCount(int first, int second, int[] extra) {
            if (first == Integer.MAX_VALUE) {
                return 0;
            }
            if (second == Integer.MAX_VALUE) {
                return 1;
            }
            return 2 + (extra == null ? 0 : extra.length);
        }

        private static int getCount(int first, int[] extra) {
            return first == Integer.MAX_VALUE ? 0 : 1 + (extra == null ? 0 : extra.length);
        }

        private static int getAtIndex(int first, int[] extra, int index) {
            return index == 0 ? first : extra[index - 1];
        }

        private static int getAtIndex(int first, int second, int[] extra, int index) {
            if (index == 0) {
                return first;
            }
            if (index == 1) {
                return second;
            }
            return extra[index - 2];
        }

        @Override
        public HIRBlock getPredecessorAt(int predIndex) {
            assert (predIndex < this.getPredecessorCount());
            return ((HIRBlock[])this.getBlocks())[ModifiableBlock.getAtIndex(this.firstPredecessor, this.extraPredecessors, predIndex)];
        }

        @Override
        public HIRBlock getSuccessorAt(int succIndex) {
            assert (succIndex < this.getSuccessorCount());
            return ((HIRBlock[])this.getBlocks())[ModifiableBlock.getAtIndex(this.firstSuccessor, this.secondSuccessor, this.extraSuccessors, succIndex)];
        }

        public void setPredecessor(int firstPredecessor) {
            this.firstPredecessor = firstPredecessor;
        }

        public void setPredecessors(int firstPredecessor, int[] extraPredecessors) {
            this.firstPredecessor = firstPredecessor;
            this.extraPredecessors = extraPredecessors;
        }

        public void setSuccessor(int firstSuccessor) {
            this.firstSuccessor = firstSuccessor;
            this.firstSuccessorProbability = 1.0;
        }

        public void setSuccessors(int firstSuccessor, int secondSuccessor, double firstSuccP, double secondSuccP) {
            this.firstSuccessor = firstSuccessor;
            this.secondSuccessor = secondSuccessor;
            this.firstSuccessorProbability = firstSuccP;
            this.secondSuccessorProbability = secondSuccP;
        }

        public void setSuccessors(int firstSuccessor, int secondSuccessor, int[] extraSuccessors, double firstSuccP, double secondSuccP, double[] restSuccP) {
            this.firstSuccessor = firstSuccessor;
            this.secondSuccessor = secondSuccessor;
            this.extraSuccessors = extraSuccessors;
            this.firstSuccessorProbability = firstSuccP;
            this.secondSuccessorProbability = secondSuccP;
            this.extraSuccessorsProbabilities = restSuccP;
        }

        @Override
        public double getSuccessorProbabilityAt(int succIndex) {
            if (succIndex == 0) {
                return this.firstSuccessorProbability;
            }
            if (succIndex == 1) {
                return this.secondSuccessorProbability;
            }
            return this.extraSuccessorsProbabilities[succIndex - 2];
        }

        @Override
        public void delete() {
            GraalError.guarantee(this.getSuccessorCount() == 1, "can only delete blocks with exactly one successor");
            ModifiableBlock next = (ModifiableBlock)this.getSuccessorAt(0);
            int predecessorCount = this.getPredecessorCount();
            for (int i = 0; i < this.getPredecessorCount(); ++i) {
                ModifiableBlock pred = (ModifiableBlock)this.getPredecessorAt(i);
                int[] newPredSuccs = new int[pred.getSuccessorCount()];
                double[] newPredSuccP = new double[pred.getSuccessorCount()];
                for (int j = 0; j < pred.getSuccessorCount(); ++j) {
                    HIRBlock predSuccAt = pred.getSuccessorAt(j);
                    if (predSuccAt == this) {
                        newPredSuccs[j] = next.getId();
                        newPredSuccP[j] = pred.getSuccessorProbabilityAt(0);
                        continue;
                    }
                    newPredSuccP[j] = pred.getSuccessorProbabilityAt(j);
                    newPredSuccs[j] = predSuccAt.getId();
                }
                if (newPredSuccs.length == 1) {
                    pred.setSuccessor(newPredSuccs[0]);
                } else if (newPredSuccs.length == 2) {
                    pred.setSuccessors(newPredSuccs[0], newPredSuccs[1], newPredSuccP[0], newPredSuccP[1]);
                } else {
                    pred.setSuccessors(newPredSuccs[0], newPredSuccs[1], Arrays.copyOfRange(newPredSuccs, 2, newPredSuccs.length), newPredSuccP[0], newPredSuccP[1], Arrays.copyOfRange(newPredSuccP, 2, newPredSuccP.length));
                }
                if (!this.isLoopEnd()) continue;
                pred.markAsLoopEnd();
            }
            if (this.isLoopEnd()) {
                GraalError.guarantee(next.isLoopHeader(), "a loop end's successor must be a loop header");
                next.numBackedges += predecessorCount - 1;
            }
            ArrayList<HIRBlock> newPreds = new ArrayList<HIRBlock>();
            for (int i = 0; i < next.getPredecessorCount(); ++i) {
                HIRBlock curPred = next.getPredecessorAt(i);
                if (curPred == this) {
                    for (int j = 0; j < this.getPredecessorCount(); ++j) {
                        newPreds.add(this.getPredecessorAt(j));
                    }
                    continue;
                }
                newPreds.add(curPred);
            }
            HIRBlock firstPred = (HIRBlock)newPreds.get(0);
            int[] extraPred1 = null;
            if (newPreds.size() - 1 > 0) {
                extraPred1 = new int[newPreds.size() - 1];
                for (int i = 1; i < newPreds.size(); ++i) {
                    extraPred1[i - 1] = ((HIRBlock)newPreds.get(i)).getId();
                }
                next.setPredecessors(firstPred.getId(), extraPred1);
            } else {
                next.setPredecessor(firstPred.getId());
            }
            for (Loop currLoop = this.loop; currLoop != null; currLoop = currLoop.getParent()) {
                GraalError.guarantee(currLoop.getBlocks().contains(this), "block not contained in a loop it is referencing");
                currLoop.getBlocks().remove(this);
            }
        }
    }

    static class UnmodifiableBlock
    extends HIRBlock {
        UnmodifiableBlock(AbstractBeginNode node, ControlFlowGraph cfg) {
            super(node, cfg);
        }

        @Override
        public int getPredecessorCount() {
            if (this.beginNode instanceof AbstractMergeNode) {
                if (this.beginNode instanceof LoopBeginNode) {
                    return ((AbstractMergeNode)this.beginNode).forwardEndCount() + ((LoopBeginNode)this.beginNode).getLoopEndCount();
                }
                return ((AbstractMergeNode)this.beginNode).forwardEndCount();
            }
            if (this.beginNode instanceof StartNode) {
                return 0;
            }
            return 1;
        }

        @Override
        public int getSuccessorCount() {
            if (this.endNode instanceof EndNode) {
                return 1;
            }
            if (this.endNode instanceof ControlSplitNode) {
                ControlSplitNode split = (ControlSplitNode)this.endNode;
                return split.getSuccessorCount();
            }
            if (this.endNode instanceof LoopEndNode) {
                return 1;
            }
            if (this.endNode instanceof ControlSinkNode) {
                return 0;
            }
            return 1;
        }

        @Override
        public HIRBlock getPredecessorAt(int predIndex) {
            ControlFlowGraph cfg1 = (ControlFlowGraph)this.cfg;
            if (this.beginNode instanceof AbstractMergeNode) {
                if (this.beginNode instanceof LoopBeginNode) {
                    return cfg1.blockFor(((LoopBeginNode)this.beginNode).phiPredecessorAt(predIndex));
                }
                return cfg1.blockFor(((AbstractMergeNode)this.beginNode).forwardEndAt(predIndex));
            }
            return cfg1.blockFor(this.beginNode.predecessor());
        }

        @Override
        public HIRBlock getSuccessorAt(int succIndex) {
            ControlFlowGraph cfg1 = (ControlFlowGraph)this.cfg;
            if (this.endNode instanceof EndNode) {
                return cfg1.blockFor(((EndNode)this.endNode).merge());
            }
            if (this.endNode instanceof ControlSplitNode) {
                ControlSplitNode split = (ControlSplitNode)this.endNode;
                if (split instanceof IfNode) {
                    IfNode ifNode = (IfNode)split;
                    return succIndex == 0 ? cfg1.blockFor(ifNode.trueSuccessor()) : cfg1.blockFor(ifNode.falseSuccessor());
                }
                if (split instanceof SwitchNode) {
                    SwitchNode switchNode = (SwitchNode)split;
                    return cfg1.blockFor(switchNode.blockSuccessor(succIndex));
                }
                if (split instanceof WithExceptionNode) {
                    GraalError.guarantee(succIndex <= 1, "With exception nodes only have 2 successors");
                    WithExceptionNode wen = (WithExceptionNode)split;
                    return succIndex == 0 ? cfg1.blockFor(wen.getPrimarySuccessor()) : cfg1.blockFor(wen.exceptionEdge());
                }
                int index = 0;
                for (Node successor : split.successors()) {
                    if (index++ != succIndex) continue;
                    return cfg1.blockFor(successor);
                }
                throw GraalError.shouldNotReachHere();
            }
            if (this.endNode instanceof LoopEndNode) {
                return cfg1.blockFor(((LoopEndNode)this.endNode).loopBegin());
            }
            if (this.endNode instanceof ControlSinkNode) {
                throw GraalError.shouldNotReachHere("Sink has no successor");
            }
            return cfg1.blockFor(this.endNode.successors().first());
        }

        @Override
        public double getSuccessorProbabilityAt(int succIndex) {
            if (this.endNode instanceof ControlSplitNode) {
                return ((ControlSplitNode)this.endNode).successorProbabilities()[succIndex];
            }
            return 1.0;
        }

        @Override
        public void delete() {
            throw GraalError.shouldNotReachHere("Cannot delete a fixed block");
        }

        @Override
        public int getLinearScanNumber() {
            throw this.unsupported("have no linear scan properties");
        }

        @Override
        public void setLinearScanNumber(int linearScanNumber) {
            throw this.unsupported("have no alignment properties");
        }

        @Override
        public boolean isAligned() {
            throw this.unsupported("have no alignment properties");
        }

        @Override
        public void setAlign(boolean align) {
            throw this.unsupported("have no alignment properties");
        }

        GraalError unsupported(String reason) {
            throw GraalError.shouldNotReachHere(this.getClass().getSimpleName() + "s " + reason);
        }
    }

    private class NodeIterator
    implements Iterator<FixedNode> {
        private FixedNode cur;

        NodeIterator() {
            this.cur = HIRBlock.this.getBeginNode();
        }

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        @Override
        public FixedNode next() {
            FixedNode result = this.cur;
            if (result instanceof FixedWithNextNode) {
                FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)result;
                FixedNode next = fixedWithNextNode.next();
                if (next instanceof AbstractBeginNode) {
                    next = null;
                }
                this.cur = next;
            } else {
                this.cur = null;
            }
            assert (!(this.cur instanceof AbstractBeginNode));
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

