/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.extended;

import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.UnsafeAccessNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class RawStoreNode
extends UnsafeAccessNode
implements StateSplit,
Lowerable,
Virtualizable,
SingleMemoryKill {
    public static final NodeClass<RawStoreNode> TYPE = NodeClass.create(RawStoreNode.class);
    @Node.Input
    ValueNode value;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateAfter;
    private final boolean needsBarrier;

    public RawStoreNode(ValueNode object, ValueNode offset, ValueNode value, JavaKind accessKind, LocationIdentity locationIdentity) {
        this(object, offset, value, accessKind, locationIdentity, true, MemoryOrderMode.PLAIN, null, false);
    }

    public RawStoreNode(ValueNode object, ValueNode offset, ValueNode value, JavaKind accessKind, LocationIdentity locationIdentity, boolean needsBarrier) {
        this(object, offset, value, accessKind, locationIdentity, needsBarrier, MemoryOrderMode.PLAIN, null, false);
    }

    public RawStoreNode(ValueNode object, ValueNode offset, ValueNode value, JavaKind accessKind, LocationIdentity locationIdentity, boolean needsBarrier, MemoryOrderMode memoryOrder) {
        this(object, offset, value, accessKind, locationIdentity, needsBarrier, memoryOrder, null, false);
    }

    public RawStoreNode(ValueNode object, ValueNode offset, ValueNode value, JavaKind accessKind, LocationIdentity locationIdentity, boolean needsBarrier, FrameState stateAfter, boolean forceLocation) {
        this(object, offset, value, accessKind, locationIdentity, needsBarrier, MemoryOrderMode.PLAIN, stateAfter, forceLocation);
    }

    public RawStoreNode(ValueNode object, ValueNode offset, ValueNode value, JavaKind accessKind, LocationIdentity locationIdentity, boolean needsBarrier, MemoryOrderMode memoryOrder, FrameState stateAfter, boolean forceLocation) {
        this(TYPE, object, offset, value, accessKind, locationIdentity, needsBarrier, memoryOrder, stateAfter, forceLocation);
    }

    protected RawStoreNode(NodeClass<? extends RawStoreNode> c, ValueNode object, ValueNode offset, ValueNode value, JavaKind accessKind, LocationIdentity locationIdentity, boolean needsBarrier, MemoryOrderMode memoryOrder, FrameState stateAfter, boolean forceLocation) {
        super(c, StampFactory.forVoid(), object, offset, accessKind, locationIdentity, forceLocation, memoryOrder);
        this.value = value;
        this.needsBarrier = needsBarrier;
        this.stateAfter = stateAfter;
        assert (accessKind != JavaKind.Void && accessKind != JavaKind.Illegal);
    }

    @Node.NodeIntrinsic
    public static native Object storeObject(Object var0, long var1, Object var3, @Node.ConstantNodeParameter JavaKind var4, @Node.ConstantNodeParameter LocationIdentity var5, @Node.ConstantNodeParameter boolean var6);

    @Node.NodeIntrinsic
    public static native Object storeChar(Object var0, long var1, char var3, @Node.ConstantNodeParameter JavaKind var4, @Node.ConstantNodeParameter LocationIdentity var5);

    @Node.NodeIntrinsic
    public static native Object storeByte(Object var0, long var1, byte var3, @Node.ConstantNodeParameter JavaKind var4, @Node.ConstantNodeParameter LocationIdentity var5);

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return MemoryOrderMode.ordersMemoryAccesses(this.getMemoryOrder()) ? LocationIdentity.ANY_LOCATION : this.getLocationIdentity();
    }

    public boolean needsBarrier() {
        return this.needsBarrier;
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    public ValueNode value() {
        return this.value;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode) {
            VirtualObjectNode virtual = (VirtualObjectNode)alias;
            ValueNode indexValue = tool.getAlias(this.offset());
            if (indexValue.isConstant()) {
                long off = indexValue.asJavaConstant().asLong();
                int entryIndex = virtual.entryIndexForOffset(tool.getMetaAccess(), off, this.accessKind());
                if (entryIndex != -1 && tool.setVirtualEntry(virtual, entryIndex, this.value(), this.accessKind(), off)) {
                    tool.delete();
                }
            }
        }
    }

    @Override
    protected ValueNode cloneAsFieldAccess(Assumptions assumptions, ResolvedJavaField field, MemoryOrderMode memOrder) {
        return new StoreFieldNode(field.isStatic() ? null : this.object(), field, this.value(), this.stateAfter(), memOrder);
    }

    @Override
    protected ValueNode cloneAsArrayAccess(ValueNode location, LocationIdentity identity, MemoryOrderMode memOrder) {
        return new RawStoreNode(this.object(), location, this.value, this.accessKind(), identity, this.needsBarrier, memOrder, this.stateAfter(), this.isLocationForced());
    }
}

