/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.loop.BasicInductionVariable;
import org.graalvm.compiler.nodes.loop.DerivedInductionVariable;
import org.graalvm.compiler.nodes.loop.DerivedOffsetInductionVariable;
import org.graalvm.compiler.nodes.loop.InductionVariable;

public class InductionVariableHelper {
    public static InductionVariable previousIteration(InductionVariable start) {
        if (start instanceof BasicInductionVariable) {
            return InductionVariableHelper.previousIterationBasic((BasicInductionVariable)start);
        }
        return InductionVariableHelper.previousIterationDerived((DerivedInductionVariable)start);
    }

    private static InductionVariable previousIterationBasic(BasicInductionVariable start) {
        BinaryArithmeticNode previousOp;
        if (start.getOp() instanceof AddNode) {
            previousOp = start.graph().unique(new SubNode(start.valueNode(), start.rawStride()));
        } else if (start.getOp() instanceof SubNode) {
            previousOp = start.graph().unique(new AddNode(start.valueNode(), start.rawStride()));
        } else {
            throw GraalError.shouldNotReachHere();
        }
        InductionVariable previousIv = (InductionVariable)start.getLoop().getInductionVariables().get((Object)previousOp);
        if (previousIv == null) {
            previousIv = new DerivedOffsetInductionVariable(start.getLoop(), start, start.rawStride(), previousOp);
            start.getLoop().getInductionVariables().put((Object)previousOp, (Object)previousIv);
        }
        return previousIv;
    }

    private static InductionVariable previousIterationDerived(DerivedInductionVariable start) {
        InductionVariable previousBase = InductionVariableHelper.previousIteration(start.getBase());
        ValueNode previousValue = start.copyValue(previousBase);
        InductionVariable previousIv = (InductionVariable)start.getLoop().getInductionVariables().get((Object)previousValue);
        if (previousIv == null) {
            previousIv = start.copy(previousBase, previousValue);
            start.getLoop().getInductionVariables().put((Object)previousValue, (Object)previousIv);
        }
        return previousIv;
    }

    public static InductionVariable nextIteration(InductionVariable start) {
        if (start instanceof BasicInductionVariable) {
            return InductionVariableHelper.nextIteration((BasicInductionVariable)start);
        }
        return InductionVariableHelper.nextIteration((DerivedInductionVariable)start);
    }

    static InductionVariable nextIteration(BasicInductionVariable start) {
        BinaryArithmeticNode nextOp;
        if (start.getOp() instanceof AddNode) {
            nextOp = start.graph().unique(new AddNode(start.getOp(), start.rawStride()));
        } else if (start.getOp() instanceof SubNode) {
            nextOp = start.graph().unique(new SubNode(start.getOp(), start.rawStride()));
        } else {
            throw GraalError.shouldNotReachHere();
        }
        InductionVariable nextIv = (InductionVariable)start.getLoop().getInductionVariables().get((Object)nextOp);
        if (nextIv == null) {
            nextIv = new DerivedOffsetInductionVariable(start.getLoop(), start, start.rawStride(), nextOp);
            start.getLoop().getInductionVariables().put((Object)nextOp, (Object)nextIv);
        }
        return nextIv;
    }

    static InductionVariable nextIteration(DerivedInductionVariable start) {
        InductionVariable nextBase = InductionVariableHelper.nextIteration(start.getBase());
        ValueNode nextValue = start.copyValue(nextBase);
        InductionVariable previousIv = (InductionVariable)start.getLoop().getInductionVariables().get((Object)nextValue);
        if (previousIv == null) {
            previousIv = start.copy(nextBase, nextValue);
            start.getLoop().getInductionVariables().put((Object)nextValue, (Object)previousIv);
        }
        return previousIv;
    }
}

