/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.gc.WriteBarrier;
import org.graalvm.compiler.nodes.java.AbstractCompareAndSwapNode;
import org.graalvm.compiler.nodes.memory.AbstractWriteNode;
import org.graalvm.compiler.nodes.memory.LIRLowerableAccess;
import org.graalvm.compiler.nodes.memory.MemoryAccess;
import org.graalvm.compiler.nodes.memory.OrderedMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Write#{p#location/s}")
public class WriteNode
extends AbstractWriteNode
implements LIRLowerableAccess,
Simplifiable {
    public static final NodeClass<WriteNode> TYPE = NodeClass.create(WriteNode.class);
    private final LocationIdentity killedLocationIdentity;
    private MemoryOrderMode memoryOrder;

    public WriteNode(AddressNode address, LocationIdentity location, ValueNode value, BarrierType barrierType, MemoryOrderMode memoryOrder) {
        this(TYPE, address, location, location, value, barrierType, memoryOrder);
    }

    protected WriteNode(NodeClass<? extends WriteNode> c, AddressNode address, LocationIdentity location, LocationIdentity killedLocationIdentity, ValueNode value, BarrierType barrierType, MemoryOrderMode memoryOrder) {
        super(c, address, location, value, barrierType);
        this.killedLocationIdentity = killedLocationIdentity;
        this.memoryOrder = memoryOrder;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRKind writeKind = gen.getLIRGeneratorTool().getLIRKind(this.value().stamp(NodeView.DEFAULT));
        gen.getLIRGeneratorTool().getArithmetic().emitStore(writeKind, gen.operand(this.address), gen.operand(this.value()), gen.state(this), this.memoryOrder);
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.value().stamp(view);
    }

    @Override
    public boolean canNullCheck() {
        return true;
    }

    @Override
    public boolean hasSideEffect() {
        if (this.ordersMemoryAccesses()) {
            return true;
        }
        if (this.getLocationIdentity().equals(LocationIdentity.INIT_LOCATION)) {
            return false;
        }
        return super.hasSideEffect();
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return this.killedLocationIdentity;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (!this.ordersMemoryAccesses()) {
            if (tool.canonicalizeReads() && this.hasExactlyOneUsage() && this.next() instanceof WriteNode) {
                WriteNode write = (WriteNode)this.next();
                if (write.lastLocationAccess == this && write.getAddress() == this.getAddress() && this.getAccessStamp(NodeView.DEFAULT).isCompatible(write.getAccessStamp(NodeView.DEFAULT))) {
                    write.setLastLocationAccess(this.getLastLocationAccess());
                    tool.addToWorkList(this.inputs());
                    tool.addToWorkList(this.next());
                    tool.addToWorkList(this.predecessor());
                    this.graph().removeFixed(this);
                }
            }
            if (this.value() instanceof ReinterpretNode) {
                tool.addToWorkList(this.value());
                tool.addToWorkList(((ReinterpretNode)this.value()).getValue());
                tool.addToWorkList(this);
                this.setValue(((ReinterpretNode)this.value()).getValue());
            }
        } else if (tool.trySinkWriteFences() && this.getMemoryOrder() == MemoryOrderMode.VOLATILE && WriteNode.followedByVolatileWrite(this)) {
            this.memoryOrder = MemoryOrderMode.RELEASE;
        }
    }

    private static boolean followedByVolatileWrite(FixedWithNextNode start) {
        FixedWithNextNode cur = start;
        while (true) {
            for (Node usage : cur.usages()) {
                if (usage instanceof MemoryAccess && usage instanceof FixedWithNextNode) continue;
                return false;
            }
            FixedNode nextNode = cur.next();
            while (nextNode instanceof WriteBarrier) {
                nextNode = ((WriteBarrier)nextNode).next();
            }
            if (!(nextNode instanceof OrderedMemoryAccess) || !(nextNode instanceof AbstractWriteNode) && !(nextNode instanceof AbstractCompareAndSwapNode)) break;
            if (((OrderedMemoryAccess)((Object)nextNode)).getMemoryOrder() == MemoryOrderMode.VOLATILE) {
                return true;
            }
            cur = (FixedWithNextNode)nextNode;
        }
        return false;
    }
}

