/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.options;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;

public final class OptionDescriptor {
    private final String name;
    private final OptionType optionType;
    private final Class<?> optionValueType;
    private final String help;
    private final List<String> extraHelp;
    private final OptionKey<?> optionKey;
    private final Class<?> declaringClass;
    private final String fieldName;
    private final boolean deprecated;
    private final String deprecationMessage;
    private static final String[] NO_EXTRA_HELP = new String[0];

    public static OptionDescriptor create(String name, OptionType optionType, Class<?> optionValueType, String help, Class<?> declaringClass, String fieldName, OptionKey<?> option) {
        return OptionDescriptor.create(name, optionType, optionValueType, help, NO_EXTRA_HELP, declaringClass, fieldName, option, false, "");
    }

    public static OptionDescriptor create(String name, OptionType optionType, Class<?> optionValueType, String help, Class<?> declaringClass, String fieldName, OptionKey<?> option, boolean deprecated, String deprecationMessage) {
        return OptionDescriptor.create(name, optionType, optionValueType, help, NO_EXTRA_HELP, declaringClass, fieldName, option, deprecated, deprecationMessage);
    }

    public static OptionDescriptor create(String name, OptionType optionType, Class<?> optionValueType, String help, String[] extraHelp, Class<?> declaringClass, String fieldName, OptionKey<?> option, boolean deprecated, String deprecationMessage) {
        assert (option != null) : declaringClass + "." + fieldName;
        OptionDescriptor result = option.getDescriptor();
        if (result == null) {
            List<String> extraHelpList = extraHelp == null || extraHelp.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(extraHelp));
            result = new OptionDescriptor(name, optionType, optionValueType, help, extraHelpList, declaringClass, fieldName, option, deprecated, deprecationMessage);
            option.setDescriptor(result);
        }
        assert (result.name.equals(name) && result.optionValueType == optionValueType && result.declaringClass == declaringClass && result.fieldName.equals(fieldName) && result.optionKey == option);
        return result;
    }

    private OptionDescriptor(String name, OptionType optionType, Class<?> optionValueType, String help, List<String> extraHelp, Class<?> declaringClass, String fieldName, OptionKey<?> optionKey, boolean deprecated, String deprecationMessage) {
        this.name = name;
        this.optionType = optionType;
        this.optionValueType = optionValueType;
        this.help = help;
        this.extraHelp = extraHelp;
        this.optionKey = optionKey;
        this.declaringClass = declaringClass;
        this.fieldName = fieldName;
        this.deprecated = deprecated || deprecationMessage != null && !deprecationMessage.isEmpty();
        this.deprecationMessage = deprecationMessage;
        assert (!optionValueType.isPrimitive()) : "must use boxed optionValueType instead of " + optionValueType;
    }

    public Class<?> getOptionValueType() {
        return this.optionValueType;
    }

    public String getHelp() {
        return this.help;
    }

    public List<String> getExtraHelp() {
        return this.extraHelp;
    }

    public String getName() {
        return this.name;
    }

    public OptionType getOptionType() {
        return this.optionType;
    }

    public OptionKey<?> getOptionKey() {
        return this.optionKey;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getLocation() {
        return this.getDeclaringClass().getName() + "." + this.getFieldName();
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String getDeprecationMessage() {
        return this.deprecationMessage;
    }
}

