/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.LoopsDataProvider;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.common.AddressLoweringPhase;

public class AddressLoweringByNodePhase
extends AddressLoweringPhase {
    private final AddressLowering lowering;

    public AddressLoweringByNodePhase(AddressLowering lowering) {
        this.lowering = lowering;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders providers) {
        this.lowering.preProcess(graph, providers.getLoopsDataProvider());
        for (Node node : graph.getNodes()) {
            if (!(node instanceof OffsetAddressNode)) continue;
            OffsetAddressNode address = (OffsetAddressNode)node;
            AddressNode lowered = this.lowering.lower(address.getBase(), address.getOffset());
            this.lowering.postProcess(lowered);
            node.replaceAtUsages(lowered);
            GraphUtil.killWithUnusedFloatingInputs(node);
        }
    }

    public static abstract class AddressLowering {
        public void preProcess(StructuredGraph graph, LoopsDataProvider loopsDataProvider) {
        }

        public void postProcess(AddressNode lowered) {
        }

        public abstract AddressNode lower(ValueNode var1, ValueNode var2);
    }
}

