/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common;

import java.util.Optional;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.PostRunCanonicalizationPhase;

public class RemoveValueProxyPhase
extends PostRunCanonicalizationPhase<CoreProviders> {
    public RemoveValueProxyPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.MID_TIER_LOWERING, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FSA, graphState), BasePhase.NotApplicable.when(!graphState.canWeakenFrameStateVerification(GraphState.FrameStateVerification.ALL_EXCEPT_LOOP_EXIT), "Cannot apply %s because the frame state verification has already been weakened to %s", new Object[]{this.getName(), graphState.getFrameStateVerification()}));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (LoopExitNode exit : graph.getNodes(LoopExitNode.TYPE)) {
            exit.removeProxies();
            FrameState frameState = exit.stateAfter();
            if (frameState == null || !frameState.isExceptionHandlingBCI()) continue;
            exit.setStateAfter(null);
            GraphUtil.tryKillUnused(frameState);
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL);
        graphState.weakenFrameStateVerification(GraphState.FrameStateVerification.ALL_EXCEPT_LOOP_EXIT);
    }
}

