/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.common.inlining.info;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.common.inlining.info.AbstractInlineInfo;
import org.graalvm.compiler.phases.common.inlining.info.elem.Inlineable;
import org.graalvm.compiler.phases.util.Providers;

public class TypeGuardInlineInfo
extends AbstractInlineInfo {
    private final ResolvedJavaMethod concrete;
    private final ResolvedJavaType type;
    private Inlineable inlineableElement;
    private final SpeculationLog.Speculation speculation;

    public TypeGuardInlineInfo(Invoke invoke, ResolvedJavaMethod concrete, ResolvedJavaType type, SpeculationLog.Speculation speculation) {
        super(invoke);
        this.concrete = concrete;
        this.type = type;
        assert (type.isArray() || type.isConcrete()) : type;
        this.speculation = speculation;
    }

    @Override
    public int numberOfMethods() {
        return 1;
    }

    @Override
    public ResolvedJavaMethod methodAt(int index) {
        assert (index == 0);
        return this.concrete;
    }

    @Override
    public Inlineable inlineableElementAt(int index) {
        assert (index == 0);
        return this.inlineableElement;
    }

    @Override
    public double probabilityAt(int index) {
        assert (index == 0);
        return 1.0;
    }

    @Override
    public double relevanceAt(int index) {
        assert (index == 0);
        return 1.0;
    }

    @Override
    public void setInlinableElement(int index, Inlineable inlineableElement) {
        assert (index == 0);
        this.inlineableElement = inlineableElement;
    }

    @Override
    public EconomicSet<Node> inline(CoreProviders providers, String reason) {
        InliningUtil.insertTypeGuard(providers, this.invoke, this.type, this.speculation);
        return TypeGuardInlineInfo.inline(this.invoke, this.concrete, this.inlineableElement, false, reason);
    }

    @Override
    public void tryToDevirtualizeInvoke(Providers providers) {
        InliningUtil.insertTypeGuard(providers, this.invoke, this.type, this.speculation);
        InliningUtil.replaceInvokeCallTarget(this.invoke, this.graph(), CallTargetNode.InvokeKind.Special, this.concrete);
    }

    public String toString() {
        return "type-checked with type " + this.type.getName() + " and method " + this.concrete.format("%H.%n(%p):%r");
    }

    @Override
    public boolean shouldInline() {
        return this.concrete.shouldBeInlined();
    }
}

