/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.phases.graph;

import java.util.ListIterator;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;

public abstract class ScheduledNodeIterator {
    private FixedWithNextNode lastFixed;
    private FixedWithNextNode reconnect;
    private ListIterator<Node> iterator;

    public void processNodes(HIRBlock block, StructuredGraph.ScheduleResult schedule) {
        this.lastFixed = block.getBeginNode();
        assert (this.lastFixed != null);
        this.reconnect = null;
        this.iterator = schedule.nodesFor(block).listIterator();
        while (this.iterator.hasNext()) {
            Node node = this.iterator.next();
            if (!node.isAlive()) continue;
            if (this.reconnect != null && node instanceof FixedNode) {
                this.reconnect.setNext((FixedNode)node);
                this.reconnect = null;
            }
            if (node instanceof FixedWithNextNode) {
                this.lastFixed = (FixedWithNextNode)node;
            }
            this.processNode(node, block, schedule, this.iterator);
        }
        if (this.reconnect != null) {
            assert (block.getSuccessorCount() == 1);
            this.reconnect.setNext(block.getFirstSuccessor().getBeginNode());
        }
    }

    protected void insert(FixedNode start, FixedWithNextNode end) {
        this.lastFixed.setNext(start);
        this.lastFixed = end;
        this.reconnect = end;
    }

    protected void replaceCurrent(FixedWithNextNode newNode) {
        Node current = this.iterator.previous();
        this.iterator.next();
        current.replaceAndDelete(newNode);
        this.insert(newNode, newNode);
        this.iterator.set(newNode);
    }

    protected abstract void processNode(Node var1, HIRBlock var2, StructuredGraph.ScheduleResult var3, ListIterator<Node> var4);
}

