/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.amd64;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.asm.amd64.AVXKind;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.core.common.StrideUtil;
import org.graalvm.compiler.lir.amd64.AMD64ArrayEqualsOp;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsWithMaskNode;

public final class AMD64IntrinsicStubs {
    public static boolean shouldInlineIntrinsic(ValueNode valueNode, LIRGenerator gen) {
        if (valueNode instanceof ArrayEqualsNode) {
            return AMD64IntrinsicStubs.shouldInline((ArrayEqualsNode)valueNode, gen);
        }
        if (valueNode instanceof ArrayRegionEqualsNode) {
            return AMD64IntrinsicStubs.shouldInline((ArrayRegionEqualsNode)valueNode, gen);
        }
        if (valueNode instanceof ArrayRegionEqualsWithMaskNode) {
            return AMD64IntrinsicStubs.shouldInline((ArrayRegionEqualsWithMaskNode)valueNode, gen);
        }
        return false;
    }

    private static boolean shouldInline(ArrayEqualsNode arrayEqualsNode, LIRGenerator gen) {
        Stride stride = Stride.fromJavaKind(arrayEqualsNode.getKind());
        ValueNode length = arrayEqualsNode.getLength();
        return length.isJavaConstant() && AMD64ArrayEqualsOp.canGenerateConstantLengthCompare(gen.target(), arrayEqualsNode.getRuntimeCheckedCPUFeatures(), arrayEqualsNode.getKind(), stride, stride, length.asJavaConstant().asInt(), (AVXKind.AVXSize)gen.getMaxVectorSize(arrayEqualsNode.getRuntimeCheckedCPUFeatures()));
    }

    private static boolean shouldInline(ArrayRegionEqualsNode regionEqualsNode, LIRGenerator gen) {
        ValueNode length = regionEqualsNode.getLength();
        int directStubCallIndex = regionEqualsNode.getDirectStubCallIndex();
        return directStubCallIndex >= 0 && length.isJavaConstant() && AMD64ArrayEqualsOp.canGenerateConstantLengthCompare(gen.target(), regionEqualsNode.getRuntimeCheckedCPUFeatures(), JavaKind.Byte, StrideUtil.getConstantStrideA(directStubCallIndex), StrideUtil.getConstantStrideB(directStubCallIndex), length.asJavaConstant().asInt(), (AVXKind.AVXSize)gen.getMaxVectorSize(regionEqualsNode.getRuntimeCheckedCPUFeatures()));
    }

    private static boolean shouldInline(ArrayRegionEqualsWithMaskNode node, LIRGenerator gen) {
        ValueNode length = node.getLength();
        return node.getDirectStubCallIndex() >= 0 && length.isJavaConstant() && AMD64ArrayEqualsOp.canGenerateConstantLengthCompare(gen.target(), node.getRuntimeCheckedCPUFeatures(), JavaKind.Byte, StrideUtil.getConstantStrideA(node.getDirectStubCallIndex()), StrideUtil.getConstantStrideB(node.getDirectStubCallIndex()), length.asJavaConstant().asInt(), (AVXKind.AVXSize)gen.getMaxVectorSize(node.getRuntimeCheckedCPUFeatures()));
    }
}

