/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.replacements.classfile.Classfile;
import org.graalvm.compiler.serviceprovider.GraalServices;

public final class ClassfileBytecodeProvider
implements BytecodeProvider {
    private final ClassLoader loader;
    private final EconomicMap<Class<?>, Classfile> classfiles = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    private final EconomicMap<String, Class<?>> classes = EconomicMap.create();
    private final EconomicMap<ResolvedJavaType, FieldsCache> fields = EconomicMap.create();
    private final EconomicMap<ResolvedJavaType, MethodsCache> methods = EconomicMap.create();
    final MetaAccessProvider metaAccess;
    final SnippetReflectionProvider snippetReflection;

    public ClassfileBytecodeProvider(MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection) {
        this.metaAccess = metaAccess;
        this.snippetReflection = snippetReflection;
        ClassLoader cl = this.getClass().getClassLoader();
        this.loader = cl == null ? ClassLoader.getSystemClassLoader() : cl;
    }

    public ClassfileBytecodeProvider(MetaAccessProvider metaAccess, SnippetReflectionProvider snippetReflection, ClassLoader loader) {
        this.metaAccess = metaAccess;
        this.snippetReflection = snippetReflection;
        this.loader = loader;
    }

    @Override
    public Bytecode getBytecode(ResolvedJavaMethod method) {
        Classfile classfile = this.getClassfile(this.resolveToClass(method.getDeclaringClass().getName()));
        return classfile.getCode(method.getName(), method.getSignature().toMethodDescriptor());
    }

    @Override
    public boolean supportsInvokedynamic() {
        return false;
    }

    @Override
    public boolean shouldRecordMethodDependencies() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Classfile getClassfile(Class<?> c) {
        Classfile classfile;
        if (!$assertionsDisabled) {
            if (c.isPrimitive()) throw new AssertionError(c);
            if (c.isArray()) {
                throw new AssertionError(c);
            }
        }
        if ((classfile = (Classfile)this.classfiles.get(c)) != null) return classfile;
        try {
            ResolvedJavaType type = this.metaAccess.lookupJavaType(c);
            try (InputStream in = GraalServices.getClassfileAsStream(c);){
                if (in == null) throw new NoClassDefFoundError(c.getName());
                DataInputStream stream = new DataInputStream(in);
                classfile = new Classfile(type, stream, this);
                this.classfiles.put(c, (Object)classfile);
                Classfile classfile2 = classfile;
                return classfile2;
            }
        }
        catch (IOException e) {
            throw (NoClassDefFoundError)new NoClassDefFoundError(c.getName()).initCause(e);
        }
    }

    synchronized Class<?> resolveToClass(String descriptor) {
        Class<?> c = (Class<?>)this.classes.get((Object)descriptor);
        if (c == null) {
            if (descriptor.length() == 1) {
                c = JavaKind.fromPrimitiveOrVoidTypeChar((char)descriptor.charAt(0)).toJavaClass();
            } else {
                int dimensions = 0;
                while (descriptor.charAt(dimensions) == '[') {
                    ++dimensions;
                }
                String name = dimensions == 0 && descriptor.startsWith("L") && descriptor.endsWith(";") ? descriptor.substring(1, descriptor.length() - 1).replace('/', '.') : descriptor.replace('/', '.');
                try {
                    c = Class.forName(name, true, this.loader);
                    this.classes.put((Object)descriptor, c);
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(descriptor);
                }
            }
        }
        return c;
    }

    private synchronized MethodsCache getMethods(ResolvedJavaType type) {
        MethodsCache methodsCache = (MethodsCache)this.methods.get((Object)type);
        if (methodsCache == null) {
            methodsCache = new MethodsCache();
            this.methods.put((Object)type, (Object)methodsCache);
        }
        return methodsCache;
    }

    private synchronized FieldsCache getFields(ResolvedJavaType type) {
        FieldsCache fieldsCache = (FieldsCache)this.fields.get((Object)type);
        if (fieldsCache == null) {
            fieldsCache = new FieldsCache();
            this.fields.put((Object)type, (Object)fieldsCache);
        }
        return fieldsCache;
    }

    ResolvedJavaField findField(ResolvedJavaType type, String name, String fieldType, boolean isStatic) {
        return this.getFields(type).lookup(type, name, fieldType, isStatic);
    }

    ResolvedJavaMethod findMethod(ResolvedJavaType type, String name, String descriptor, boolean isStatic) {
        ResolvedJavaMethod method = this.getMethods(type).lookup(type, name, descriptor);
        if (method != null && method.isStatic() == isStatic) {
            return method;
        }
        return null;
    }

    static final class MethodsCache {
        volatile EconomicMap<MethodKey, ResolvedJavaMethod> constructors;
        volatile EconomicMap<MethodKey, ResolvedJavaMethod> methods;

        MethodsCache() {
        }

        ResolvedJavaMethod lookup(ResolvedJavaType type, String name, String descriptor) {
            MethodKey key = new MethodKey(name, descriptor);
            if (name.equals("<clinit>")) {
                return type.getClassInitializer();
            }
            if (!name.equals("<init>")) {
                if (this.methods == null) {
                    this.methods = MethodsCache.createMethodMap(type.getDeclaredMethods());
                }
                return (ResolvedJavaMethod)this.methods.get((Object)key);
            }
            if (this.constructors == null) {
                this.constructors = MethodsCache.createMethodMap(type.getDeclaredConstructors());
            }
            return (ResolvedJavaMethod)this.constructors.get((Object)key);
        }

        private static EconomicMap<MethodKey, ResolvedJavaMethod> createMethodMap(ResolvedJavaMethod[] methodArray) {
            EconomicMap map = EconomicMap.create();
            for (ResolvedJavaMethod m : methodArray) {
                map.put((Object)new MethodKey(m.getName(), m.getSignature().toMethodDescriptor()), (Object)m);
            }
            return map;
        }
    }

    static final class FieldsCache {
        volatile EconomicMap<FieldKey, ResolvedJavaField> instanceFields;
        volatile EconomicMap<FieldKey, ResolvedJavaField> staticFields;

        FieldsCache() {
        }

        ResolvedJavaField lookup(ResolvedJavaType type, String name, String fieldType, boolean isStatic) {
            FieldKey key = new FieldKey(name, fieldType);
            if (isStatic) {
                if (this.staticFields == null) {
                    this.staticFields = FieldsCache.createFieldMap(type.getStaticFields());
                }
                return (ResolvedJavaField)this.staticFields.get((Object)key);
            }
            if (this.instanceFields == null) {
                this.instanceFields = FieldsCache.createFieldMap(type.getInstanceFields(false));
            }
            return (ResolvedJavaField)this.instanceFields.get((Object)key);
        }

        private static EconomicMap<FieldKey, ResolvedJavaField> createFieldMap(ResolvedJavaField[] fieldArray) {
            EconomicMap map = EconomicMap.create();
            for (ResolvedJavaField f : fieldArray) {
                map.put((Object)new FieldKey(f.getName(), f.getType().getName()), (Object)f);
            }
            return map;
        }
    }

    static final class MethodKey {
        final String name;
        final String descriptor;

        MethodKey(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }

        public String toString() {
            return this.name + ":" + this.descriptor;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodKey) {
                MethodKey that = (MethodKey)obj;
                return that.name.equals(this.name) && that.descriptor.equals(this.descriptor);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.descriptor.hashCode();
        }
    }

    static final class FieldKey {
        final String name;
        final String type;

        FieldKey(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return this.name + ":" + this.type;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FieldKey) {
                FieldKey that = (FieldKey)obj;
                return that.name.equals(this.name) && that.type.equals(this.type);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.type.hashCode();
        }
    }
}

