/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, nameTemplate="AES#{p#cryptMode/s}", cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public class AESNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<AESNode> TYPE = NodeClass.create(AESNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte)};
    public static final ForeignCallDescriptor STUB_ENCRYPT = new ForeignCallDescriptor("aesEncrypt", Void.TYPE, new Class[]{Pointer.class, Pointer.class, Pointer.class}, false, KILLED_LOCATIONS, false, false);
    public static final ForeignCallDescriptor STUB_DECRYPT = new ForeignCallDescriptor("aesDecrypt", Void.TYPE, new Class[]{Pointer.class, Pointer.class, Pointer.class}, false, KILLED_LOCATIONS, false, false);
    public static final ForeignCallDescriptor[] STUBS = new ForeignCallDescriptor[]{STUB_ENCRYPT, STUB_DECRYPT};
    private final CryptMode cryptMode;
    @Node.Input
    protected ValueNode from;
    @Node.Input
    protected ValueNode to;
    @Node.Input
    protected ValueNode key;

    public AESNode(ValueNode from, ValueNode to, ValueNode key, CryptMode cryptMode) {
        this(from, to, key, cryptMode, null);
    }

    public AESNode(ValueNode from, ValueNode to, ValueNode key, CryptMode cryptMode, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.forVoid(), runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.from = from;
        this.to = to;
        this.key = key;
        this.cryptMode = cryptMode;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.from, this.to, this.key};
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
        return EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AES);
    }

    public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
        return EnumSet.of(AArch64.CPUFeature.AES);
    }

    public static boolean isSupported(Architecture arch) {
        if (arch instanceof AMD64) {
            return ((AMD64)arch).getFeatures().containsAll(AESNode.minFeaturesAMD64());
        }
        if (arch instanceof AArch64) {
            return ((AArch64)arch).getFeatures().containsAll(AESNode.minFeaturesAARCH64());
        }
        return false;
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="aesEncrypt", minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64", parameters={"ENCRYPT"}), @GenerateStub(name="aesDecrypt", minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64", parameters={"DECRYPT"})})
    public static native void apply(Pointer var0, Pointer var1, Pointer var2, @Node.ConstantNodeParameter CryptMode var3);

    @Node.NodeIntrinsic
    public static native void apply(Pointer var0, Pointer var1, Pointer var2, @Node.ConstantNodeParameter CryptMode var3, @Node.ConstantNodeParameter EnumSet<?> var4);

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return this.cryptMode.isEncrypt() ? STUB_ENCRYPT : STUB_DECRYPT;
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        if (this.cryptMode.isEncrypt()) {
            gen.getLIRGeneratorTool().emitAESEncrypt(gen.operand(this.from), gen.operand(this.to), gen.operand(this.key));
        } else {
            gen.getLIRGeneratorTool().emitAESDecrypt(gen.operand(this.from), gen.operand(this.to), gen.operand(this.key));
        }
    }

    public static enum CryptMode {
        ENCRYPT,
        DECRYPT;


        public boolean isEncrypt() {
            return this == ENCRYPT;
        }
    }
}

