/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.Stride;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.replacements.nodes.ArrayIndexOfNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_128)
public final class ArrayIndexOfMacroNode
extends MacroNode {
    public static final NodeClass<ArrayIndexOfMacroNode> TYPE = NodeClass.create(ArrayIndexOfMacroNode.class);
    private final Stride stride;
    private final LIRGeneratorTool.ArrayIndexOfVariant variant;
    private final LocationIdentity locationIdentity;

    public ArrayIndexOfMacroNode(MacroNode.MacroParams p, Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant, LocationIdentity locationIdentity) {
        this(TYPE, p, stride, variant, locationIdentity);
    }

    public ArrayIndexOfMacroNode(NodeClass<? extends MacroNode> c, MacroNode.MacroParams p, Stride stride, LIRGeneratorTool.ArrayIndexOfVariant variant, LocationIdentity locationIdentity) {
        super(c, p);
        this.stride = stride;
        this.variant = variant;
        this.locationIdentity = locationIdentity;
    }

    @Override
    public void lower(LoweringTool tool) {
        Architecture arch = tool.getLowerer().getTarget().arch;
        if (ArrayIndexOfNode.isSupported(arch, this.stride, this.variant)) {
            ValueNode[] searchValues = (ValueNode[])this.getArguments().subList(7).toArray(ValueNode[]::new);
            if (this.variant == LIRGeneratorTool.ArrayIndexOfVariant.Table) {
                ValueNode array = searchValues[0];
                ConstantNode offset = ConstantNode.forLong(tool.getMetaAccess().getArrayBaseOffset(JavaKind.Byte));
                assert (offset.getStackKind() == tool.getReplacements().getWordKind());
                searchValues[0] = this.graph().add(new ComputeObjectAddressNode(array, this.graph().addOrUnique(offset)));
            }
            ArrayIndexOfNode replacement = this.graph().addOrUnique(new ArrayIndexOfNode(this.stride, this.variant, null, this.locationIdentity, this.getArgument(1), this.getArgument(2), this.getArgument(3), this.getArgument(6), searchValues));
            this.graph().replaceFixedWithFixed(this, replacement);
            if (this.variant == LIRGeneratorTool.ArrayIndexOfVariant.Table) {
                this.graph().addBeforeFixed(replacement, (ComputeObjectAddressNode)searchValues[0]);
            }
        } else {
            super.lower(tool);
        }
    }
}

