/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_1024, size=NodeSize.SIZE_32)
public class BigIntegerMulAddNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<BigIntegerMulAddNode> TYPE = NodeClass.create(BigIntegerMulAddNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Int)};
    public static final ForeignCallDescriptor STUB = new ForeignCallDescriptor("mulAdd", Integer.TYPE, new Class[]{Pointer.class, Pointer.class, Integer.TYPE, Integer.TYPE, Integer.TYPE}, false, KILLED_LOCATIONS, false, false);
    @Node.Input
    protected ValueNode out;
    @Node.Input
    protected ValueNode in;
    @Node.Input
    protected ValueNode offset;
    @Node.Input
    protected ValueNode len;
    @Node.Input
    protected ValueNode k;

    public BigIntegerMulAddNode(ValueNode out, ValueNode in, ValueNode offset, ValueNode len, ValueNode k) {
        this(out, in, offset, len, k, null);
    }

    public BigIntegerMulAddNode(ValueNode out, ValueNode in, ValueNode offset, ValueNode len, ValueNode k, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, StampFactory.intValue(), runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.out = out;
        this.in = in;
        this.offset = offset;
        this.len = len;
        this.k = k;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.out, this.in, this.offset, this.len, this.k};
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    @Node.NodeIntrinsic
    @GenerateStub(name="mulAdd")
    public static native int apply(Pointer var0, Pointer var1, int var2, int var3, int var4);

    @Node.NodeIntrinsic
    public static native int apply(Pointer var0, Pointer var1, int var2, int var3, int var4, @Node.ConstantNodeParameter EnumSet<?> var5);

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitBigIntegerMulAdd(gen.operand(this.out), gen.operand(this.in), gen.operand(this.offset), gen.operand(this.len), gen.operand(this.k)));
    }
}

