/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.CalcStringAttributesForeignCalls;
import org.graalvm.compiler.replacements.nodes.PureFunctionStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public final class CalcStringAttributesNode
extends PureFunctionStubIntrinsicNode {
    public static final NodeClass<CalcStringAttributesNode> TYPE = NodeClass.create(CalcStringAttributesNode.class);
    private static final EnumSet<AMD64.CPUFeature> MINIMUM_FEATURES_AMD64 = EnumSet.of(AMD64.CPUFeature.SSE, new AMD64.CPUFeature[]{AMD64.CPUFeature.SSE2, AMD64.CPUFeature.SSE3, AMD64.CPUFeature.SSSE3, AMD64.CPUFeature.SSE4_1, AMD64.CPUFeature.SSE4_2, AMD64.CPUFeature.POPCNT});
    private final LIRGeneratorTool.CalcStringAttributesEncoding encoding;
    private final boolean assumeValid;
    @Node.Input
    protected ValueNode array;
    @Node.Input
    protected ValueNode offset;
    @Node.Input
    protected ValueNode length;

    protected CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding encoding, @Node.ConstantNodeParameter boolean assumeValid) {
        this(array, offset, length, encoding, assumeValid, null, LocationIdentity.any());
    }

    protected CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding encoding, @Node.ConstantNodeParameter boolean assumeValid, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures) {
        this(array, offset, length, encoding, assumeValid, runtimeCheckedCPUFeatures, LocationIdentity.any());
    }

    public CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding encoding, @Node.ConstantNodeParameter boolean assumeValid, LocationIdentity locationIdentity) {
        this(array, offset, length, encoding, assumeValid, null, locationIdentity);
    }

    public CalcStringAttributesNode(ValueNode array, ValueNode offset, ValueNode length, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding encoding, @Node.ConstantNodeParameter boolean assumeValid, @Node.ConstantNodeParameter EnumSet<?> runtimeCheckedCPUFeatures, LocationIdentity locationIdentity) {
        super(TYPE, StampFactory.forKind(CalcStringAttributesNode.getReturnValueKind(encoding)), runtimeCheckedCPUFeatures, locationIdentity);
        this.encoding = encoding;
        this.assumeValid = assumeValid;
        this.array = array;
        this.offset = offset;
        this.length = length;
    }

    private static JavaKind getReturnValueKind(LIRGeneratorTool.CalcStringAttributesEncoding encoding) {
        return encoding == LIRGeneratorTool.CalcStringAttributesEncoding.UTF_8 || encoding == LIRGeneratorTool.CalcStringAttributesEncoding.UTF_16 ? JavaKind.Long : JavaKind.Int;
    }

    public LIRGeneratorTool.CalcStringAttributesEncoding getOp() {
        return this.encoding;
    }

    public boolean isAssumeValid() {
        return this.assumeValid;
    }

    public ValueNode getArray() {
        return this.array;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public ValueNode getLength() {
        return this.length;
    }

    public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
        return MINIMUM_FEATURES_AMD64;
    }

    public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
        return EnumSet.noneOf(AArch64.CPUFeature.class);
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return CalcStringAttributesForeignCalls.getStub(this);
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.array, this.offset, this.length};
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitCalcStringAttributes(this.encoding, this.getRuntimeCheckedCPUFeatures(), gen.operand(this.array), gen.operand(this.offset), gen.operand(this.length), this.assumeValid));
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="calcStringAttributesLatin1", parameters={"LATIN1", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesBMP", parameters={"BMP", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF32", parameters={"UTF_32", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")})
    public static native int intReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding var4, @Node.ConstantNodeParameter boolean var5);

    @Node.NodeIntrinsic
    public static native int intReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding var4, @Node.ConstantNodeParameter boolean var5, @Node.ConstantNodeParameter EnumSet<?> var6);

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="calcStringAttributesUTF8Valid", parameters={"UTF_8", "true"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF8Unknown", parameters={"UTF_8", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF16Valid", parameters={"UTF_16", "true"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64"), @GenerateStub(name="calcStringAttributesUTF16Unknown", parameters={"UTF_16", "false"}, minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")})
    public static native long longReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding var4, @Node.ConstantNodeParameter boolean var5);

    @Node.NodeIntrinsic
    public static native long longReturnValue(Object var0, long var1, int var3, @Node.ConstantNodeParameter LIRGeneratorTool.CalcStringAttributesEncoding var4, @Node.ConstantNodeParameter boolean var5, @Node.ConstantNodeParameter EnumSet<?> var6);
}

