/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.lir.GenerateStubs;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.AESNode;
import org.graalvm.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, nameTemplate="CBCAES#{p#cryptMode/s}", cycles=NodeCycles.CYCLES_1024, size=NodeSize.SIZE_64)
public class CipherBlockChainingAESNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<CipherBlockChainingAESNode> TYPE = NodeClass.create(CipherBlockChainingAESNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte)};
    public static final ForeignCallDescriptor STUB_ENCRYPT = new ForeignCallDescriptor("cbcAESEncrypt", Integer.TYPE, new Class[]{Pointer.class, Pointer.class, Pointer.class, Pointer.class, Integer.TYPE}, false, KILLED_LOCATIONS, false, false);
    public static final ForeignCallDescriptor STUB_DECRYPT = new ForeignCallDescriptor("cbcAESDecrypt", Integer.TYPE, new Class[]{Pointer.class, Pointer.class, Pointer.class, Pointer.class, Integer.TYPE}, false, KILLED_LOCATIONS, false, false);
    public static final ForeignCallDescriptor[] STUBS = new ForeignCallDescriptor[]{STUB_ENCRYPT, STUB_DECRYPT};
    private final AESNode.CryptMode cryptMode;
    @Node.Input
    protected ValueNode from;
    @Node.Input
    protected ValueNode to;
    @Node.Input
    protected ValueNode key;
    @Node.Input
    protected ValueNode r;
    @Node.Input
    protected ValueNode len;

    public CipherBlockChainingAESNode(ValueNode from, ValueNode to, ValueNode key, ValueNode r, ValueNode len, AESNode.CryptMode cryptMode) {
        this(from, to, key, r, len, cryptMode, null);
    }

    public CipherBlockChainingAESNode(ValueNode from, ValueNode to, ValueNode key, ValueNode r, ValueNode len, AESNode.CryptMode cryptMode, EnumSet<?> runtimeCheckedCPUFeatures) {
        super(TYPE, len.stamp(NodeView.DEFAULT), runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.from = from;
        this.to = to;
        this.key = key;
        this.r = r;
        this.len = len;
        this.cryptMode = cryptMode;
    }

    @Override
    public ValueNode[] getForeignCallArguments() {
        return new ValueNode[]{this.from, this.to, this.key, this.r, this.len};
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
        return AESNode.minFeaturesAMD64();
    }

    public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
        return AESNode.minFeaturesAARCH64();
    }

    public static boolean isSupported(Architecture arch) {
        if (arch instanceof AMD64) {
            return ((AMD64)arch).getFeatures().containsAll(CipherBlockChainingAESNode.minFeaturesAMD64());
        }
        if (arch instanceof AArch64) {
            return ((AArch64)arch).getFeatures().containsAll(CipherBlockChainingAESNode.minFeaturesAARCH64());
        }
        return false;
    }

    @Node.NodeIntrinsic
    @GenerateStubs(value={@GenerateStub(name="cbcAESEncrypt", minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64", parameters={"ENCRYPT"}), @GenerateStub(name="cbcAESDecrypt", minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64", parameters={"DECRYPT"})})
    public static native int apply(Pointer var0, Pointer var1, Pointer var2, Pointer var3, int var4, @Node.ConstantNodeParameter AESNode.CryptMode var5);

    @Node.NodeIntrinsic
    public static native int apply(Pointer var0, Pointer var1, Pointer var2, Pointer var3, int var4, @Node.ConstantNodeParameter AESNode.CryptMode var5, @Node.ConstantNodeParameter EnumSet<?> var6);

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return this.cryptMode.isEncrypt() ? STUB_ENCRYPT : STUB_DECRYPT;
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        if (this.cryptMode.isEncrypt()) {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitCBCAESEncrypt(gen.operand(this.from), gen.operand(this.to), gen.operand(this.key), gen.operand(this.r), gen.operand(this.len)));
        } else {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitCBCAESDecrypt(gen.operand(this.from), gen.operand(this.to), gen.operand(this.key), gen.operand(this.r), gen.operand(this.len)));
        }
    }
}

