/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.util.EnumSet;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.lir.GenerateStub;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.replacements.nodes.AESNode;
import org.graalvm.compiler.replacements.nodes.MemoryKillStubIntrinsicNode;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public class CounterModeAESNode
extends MemoryKillStubIntrinsicNode {
    public static final NodeClass<CounterModeAESNode> TYPE = NodeClass.create(CounterModeAESNode.class);
    public static final LocationIdentity[] KILLED_LOCATIONS = new LocationIdentity[]{NamedLocationIdentity.getArrayLocation(JavaKind.Byte)};
    public static final ForeignCallDescriptor STUB = new ForeignCallDescriptor("ctrAESCrypt", Integer.TYPE, new Class[]{Pointer.class, Pointer.class, Pointer.class, Pointer.class, Integer.TYPE, Pointer.class, Pointer.class}, false, KILLED_LOCATIONS, false, false);
    @Node.Input
    protected NodeInputList<ValueNode> inputs;

    public CounterModeAESNode(ValueNode inAddr, ValueNode outAddr, ValueNode kAddr, ValueNode counterAddr, ValueNode len, ValueNode encryptedCounterAddr, ValueNode usedPtr) {
        this(null, len.stamp(NodeView.DEFAULT), inAddr, outAddr, kAddr, counterAddr, len, encryptedCounterAddr, usedPtr);
    }

    public CounterModeAESNode(ValueNode inAddr, ValueNode outAddr, ValueNode kAddr, ValueNode counterAddr, ValueNode len, ValueNode encryptedCounterAddr, ValueNode usedPtr, EnumSet<?> runtimeCheckedCPUFeatures) {
        this(runtimeCheckedCPUFeatures, len.stamp(NodeView.DEFAULT), inAddr, outAddr, kAddr, counterAddr, len, encryptedCounterAddr, usedPtr);
    }

    private CounterModeAESNode(EnumSet<?> runtimeCheckedCPUFeatures, Stamp stamp, ValueNode ... args) {
        super(TYPE, stamp, runtimeCheckedCPUFeatures, LocationIdentity.any());
        this.inputs = new NodeInputList((Node)this, (Node[])args);
    }

    public static EnumSet<AMD64.CPUFeature> minFeaturesAMD64() {
        return AESNode.minFeaturesAMD64();
    }

    public static EnumSet<AArch64.CPUFeature> minFeaturesAARCH64() {
        return AESNode.minFeaturesAARCH64();
    }

    public static boolean isSupported(Architecture arch) {
        if (arch instanceof AMD64) {
            return ((AMD64)arch).getFeatures().containsAll(CounterModeAESNode.minFeaturesAMD64());
        }
        if (arch instanceof AArch64) {
            return ((AArch64)arch).getFeatures().containsAll(CounterModeAESNode.minFeaturesAARCH64());
        }
        return false;
    }

    @Node.NodeIntrinsic
    @GenerateStub(name="ctrAESCrypt", minimumCPUFeaturesAMD64="minFeaturesAMD64", minimumCPUFeaturesAARCH64="minFeaturesAARCH64")
    public static native int apply(Pointer var0, Pointer var1, Pointer var2, Pointer var3, int var4, Pointer var5, Pointer var6);

    @Node.NodeIntrinsic
    public static native int apply(Pointer var0, Pointer var1, Pointer var2, Pointer var3, int var4, Pointer var5, Pointer var6, @Node.ConstantNodeParameter EnumSet<?> var7);

    @Override
    public ValueNode[] getForeignCallArguments() {
        return this.inputs.toArray((A[])ValueNode.EMPTY_ARRAY);
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return KILLED_LOCATIONS;
    }

    @Override
    public ForeignCallDescriptor getForeignCallDescriptor() {
        return STUB;
    }

    @Override
    public void emitIntrinsic(NodeLIRBuilderTool gen) {
        GraalError.guarantee(this.inputs.size() == 7, "inputs do not match");
        gen.setResult(this, (Value)gen.getLIRGeneratorTool().emitCTRAESCrypt(gen.operand((Node)this.inputs.get(0)), gen.operand((Node)this.inputs.get(1)), gen.operand((Node)this.inputs.get(2)), gen.operand((Node)this.inputs.get(3)), gen.operand((Node)this.inputs.get(4)), gen.operand((Node)this.inputs.get(5)), gen.operand((Node)this.inputs.get(6))));
    }
}

