/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_32, size=NodeSize.SIZE_32)
public final class HalfFloatToFloatNode
extends UnaryNode
implements LIRLowerable {
    public static final NodeClass<HalfFloatToFloatNode> TYPE = NodeClass.create(HalfFloatToFloatNode.class);

    public HalfFloatToFloatNode(ValueNode value) {
        super(TYPE, StampFactory.forKind(JavaKind.Float), value);
    }

    private static float float16ToFloat(short floatBinary16) {
        try {
            Method float16ToFloat = Float.class.getDeclaredMethod("float16ToFloat", Short.TYPE);
            return ((Float)float16ToFloat.invoke(null, floatBinary16)).floatValue();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere(e, "Float.float16ToFloat is introduced in Java 20");
        }
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue instanceof ConstantNode) {
            short s = (short)forValue.asJavaConstant().asInt();
            return ConstantNode.forFloat(HalfFloatToFloatNode.float16ToFloat(s));
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Variable result = gen.getLIRGeneratorTool().getArithmetic().emitHalfFloatToFloat(gen.operand(this.getValue()));
        gen.setResult(this, (Value)result);
    }
}

