/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class ReverseBytesNode
extends UnaryNode
implements LIRLowerable {
    public static final NodeClass<ReverseBytesNode> TYPE = NodeClass.create(ReverseBytesNode.class);

    public ReverseBytesNode(ValueNode value) {
        super(TYPE, value.stamp(NodeView.DEFAULT).unrestricted(), value);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        if (newStamp instanceof IntegerStamp) {
            IntegerStamp valueStamp = (IntegerStamp)newStamp;
            switch (valueStamp.getBits()) {
                case 1: 
                case 8: {
                    return this.stamp(NodeView.DEFAULT);
                }
                case 16: {
                    long mask = CodeUtil.mask((int)16);
                    return IntegerStamp.stampForMask(16, (long)Short.reverseBytes((short)valueStamp.mustBeSet()) & mask, (long)Short.reverseBytes((short)valueStamp.mayBeSet()) & mask);
                }
                case 32: {
                    long mask = CodeUtil.mask((int)32);
                    return IntegerStamp.stampForMask(32, (long)Integer.reverseBytes((int)valueStamp.mustBeSet()) & mask, (long)Integer.reverseBytes((int)valueStamp.mayBeSet()) & mask);
                }
                case 64: {
                    return IntegerStamp.stampForMask(64, Long.reverseBytes(valueStamp.mustBeSet()), Long.reverseBytes(valueStamp.mayBeSet()));
                }
            }
            throw GraalError.unimplemented("Unsupported bit size " + valueStamp.getBits());
        }
        return this.stamp(NodeView.DEFAULT);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue instanceof ReverseBytesNode) {
            return ((ReverseBytesNode)forValue).getValue();
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Variable result = gen.getLIRGeneratorTool().emitReverseBytes(gen.operand(this.getValue()));
        gen.setResult(this, (Value)result);
    }
}

