/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes;

import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="ZeroMemory#{p#location/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public class ZeroMemoryNode
extends FixedAccessNode
implements LIRLowerable,
SingleMemoryKill {
    public static final NodeClass<ZeroMemoryNode> TYPE = NodeClass.create(ZeroMemoryNode.class);
    @Node.Input
    ValueNode length;
    private final boolean isAligned;

    public ZeroMemoryNode(ValueNode address, ValueNode length, boolean isAligned, LocationIdentity locationIdentity) {
        this(OffsetAddressNode.create(address), length, isAligned, locationIdentity, BarrierType.NONE);
    }

    public ZeroMemoryNode(AddressNode address, ValueNode length, boolean isAligned, LocationIdentity locationIdentity, BarrierType type) {
        super(TYPE, address, locationIdentity, StampFactory.forVoid(), type);
        this.length = length;
        this.isAligned = isAligned;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.getLIRGeneratorTool().emitZeroMemory(gen.operand(this.getAddress()), gen.operand(this.length), this.isAligned);
    }

    public ValueNode getLength() {
        return this.length;
    }

    @Override
    public boolean canNullCheck() {
        return false;
    }

    @Node.NodeIntrinsic
    public static native void zero(Word var0, long var1, @Node.ConstantNodeParameter boolean var3, @Node.ConstantNodeParameter LocationIdentity var4);

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.location;
    }
}

