/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes.arithmetic;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class IntegerSubExactNode
extends SubNode
implements GuardedNode,
IntegerExactArithmeticNode,
IterableNodeType {
    public static final NodeClass<IntegerSubExactNode> TYPE = NodeClass.create(IntegerSubExactNode.class);
    @Node.Input(value=InputType.Guard)
    protected GuardingNode guard;

    public IntegerSubExactNode(ValueNode x, ValueNode y, GuardingNode guard) {
        super(TYPE, x, y);
        this.setStamp(x.stamp(NodeView.DEFAULT).unrestricted());
        assert (x.stamp(NodeView.DEFAULT).isCompatible(y.stamp(NodeView.DEFAULT)) && x.stamp(NodeView.DEFAULT) instanceof IntegerStamp);
        this.guard = guard;
    }

    @Override
    public boolean inferStamp() {
        return false;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        long c;
        if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
            return ConstantNode.forIntegerStamp(this.stamp(NodeView.DEFAULT), 0L);
        }
        if (forX.isConstant() && forY.isConstant()) {
            return this.canonicalXYconstant(forX, forY);
        }
        if (forY.isConstant() && (c = forY.asJavaConstant().asLong()) == 0L) {
            return forX;
        }
        if (!IntegerStamp.subtractionCanOverflow((IntegerStamp)this.x.stamp(NodeView.DEFAULT), (IntegerStamp)this.y.stamp(NodeView.DEFAULT))) {
            return (ValueNode)new SubNode(this.x, this.y).canonical(tool);
        }
        return this;
    }

    private ValueNode canonicalXYconstant(ValueNode forX, ValueNode forY) {
        JavaConstant xConst = forX.asJavaConstant();
        JavaConstant yConst = forY.asJavaConstant();
        assert (xConst.getJavaKind() == yConst.getJavaKind());
        try {
            if (xConst.getJavaKind() == JavaKind.Int) {
                return ConstantNode.forInt(Math.subtractExact(xConst.asInt(), yConst.asInt()));
            }
            assert (xConst.getJavaKind() == JavaKind.Long);
            return ConstantNode.forLong(Math.subtractExact(xConst.asLong(), yConst.asLong()));
        }
        catch (ArithmeticException arithmeticException) {
            return this;
        }
    }

    @Override
    public GuardingNode getGuard() {
        return this.guard;
    }

    @Override
    public void setGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.guard, guard);
        this.guard = guard;
    }

    @Override
    protected boolean isExact() {
        return true;
    }
}

