/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.SourceLanguagePosition;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.phases.schedule.SchedulePhase;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionValues;

final class ExpansionStatistics {
    private final Set<PolyglotCompilerOptions.CompilationTier> enabledStages = new HashSet<PolyglotCompilerOptions.CompilationTier>();
    private volatile CompilableTruffleAST previousCompilation;
    private final Set<PolyglotCompilerOptions.CompilationTier> traceMethodExpansion;
    private final Set<PolyglotCompilerOptions.CompilationTier> traceNodeExpansion;
    private final Map<PolyglotCompilerOptions.CompilationTier, Map<ResolvedJavaMethod, Stats>> methodExpansionStatistics = new HashMap<PolyglotCompilerOptions.CompilationTier, Map<ResolvedJavaMethod, Stats>>();
    private final Map<PolyglotCompilerOptions.CompilationTier, Map<NodeClassKey, Stats>> nodeExpansionStatistics = new HashMap<PolyglotCompilerOptions.CompilationTier, Map<NodeClassKey, Stats>>();
    private final Map<PolyglotCompilerOptions.CompilationTier, Map<NodeSpecializationKey, Stats>> specializationExpansionStatistics = new HashMap<PolyglotCompilerOptions.CompilationTier, Map<NodeSpecializationKey, Stats>>();
    private final ConcurrentHashMap<ResolvedJavaMethod, Boolean> isSpecializationMethodCache = new ConcurrentHashMap();

    private ExpansionStatistics(Set<PolyglotCompilerOptions.CompilationTier> traceMethodExpansion, Set<PolyglotCompilerOptions.CompilationTier> traceNodeExpansion, Set<PolyglotCompilerOptions.CompilationTier> methodExpansionStatistics, Set<PolyglotCompilerOptions.CompilationTier> nodeExpansionStatistics) {
        this.traceMethodExpansion = traceMethodExpansion;
        this.traceNodeExpansion = traceNodeExpansion;
        for (PolyglotCompilerOptions.CompilationTier tier : methodExpansionStatistics) {
            this.methodExpansionStatistics.put(tier, new HashMap());
        }
        for (PolyglotCompilerOptions.CompilationTier tier : nodeExpansionStatistics) {
            this.nodeExpansionStatistics.put(tier, new HashMap());
        }
        this.enabledStages.addAll(traceMethodExpansion);
        this.enabledStages.addAll(traceNodeExpansion);
        this.enabledStages.addAll(methodExpansionStatistics);
        this.enabledStages.addAll(nodeExpansionStatistics);
    }

    static ExpansionStatistics create(OptionValues options) {
        if (!ExpansionStatistics.isEnabled(options)) {
            return null;
        }
        boolean legacyExpansion = (Boolean)options.get(PolyglotCompilerOptions.PrintExpansionHistogram);
        HashSet<PolyglotCompilerOptions.CompilationTier> traceMethodExpansion = (HashSet<PolyglotCompilerOptions.CompilationTier>)options.get(PolyglotCompilerOptions.TraceMethodExpansion);
        Set traceNodeExpansion = (Set)options.get(PolyglotCompilerOptions.TraceNodeExpansion);
        Set methodExpansionStatistics = (Set)options.get(PolyglotCompilerOptions.MethodExpansionStatistics);
        Set nodeExpansionStatistics = (Set)options.get(PolyglotCompilerOptions.NodeExpansionStatistics);
        if (legacyExpansion) {
            traceMethodExpansion = new HashSet<PolyglotCompilerOptions.CompilationTier>(traceMethodExpansion);
            traceMethodExpansion.add(PolyglotCompilerOptions.CompilationTier.truffleTier);
        }
        return new ExpansionStatistics(traceMethodExpansion, traceNodeExpansion, methodExpansionStatistics, nodeExpansionStatistics);
    }

    static boolean isEnabled(OptionValues options) {
        return (Boolean)options.get(PolyglotCompilerOptions.PrintExpansionHistogram) != false || !((Set)options.get(PolyglotCompilerOptions.TraceMethodExpansion)).isEmpty() || !((Set)options.get(PolyglotCompilerOptions.TraceNodeExpansion)).isEmpty() || !((Set)options.get(PolyglotCompilerOptions.MethodExpansionStatistics)).isEmpty() || !((Set)options.get(PolyglotCompilerOptions.NodeExpansionStatistics)).isEmpty();
    }

    void afterPartialEvaluation(CompilableTruffleAST compilable, StructuredGraph graph) {
        this.previousCompilation = compilable;
        this.handleStage(compilable, graph, PolyglotCompilerOptions.CompilationTier.peTier);
    }

    void afterTruffleTier(CompilableTruffleAST compilable, StructuredGraph graph) {
        this.handleStage(compilable, graph, PolyglotCompilerOptions.CompilationTier.truffleTier);
    }

    void afterLowTier(CompilableTruffleAST compilable, StructuredGraph graph) {
        this.handleStage(compilable, graph, PolyglotCompilerOptions.CompilationTier.lowTier);
    }

    private void handleStage(CompilableTruffleAST compilable, StructuredGraph graph, PolyglotCompilerOptions.CompilationTier tier) {
        boolean methodExpansion = this.traceMethodExpansion.contains((Object)tier);
        boolean nodeExpansion = this.traceNodeExpansion.contains((Object)tier);
        boolean methodExpansionStat = this.methodExpansionStatistics.containsKey((Object)tier);
        boolean nodeExpansionStat = this.nodeExpansionStatistics.containsKey((Object)tier);
        TreeNode methodTree = null;
        TreeNode nodeTree = null;
        if (methodExpansion) {
            if (methodTree == null) {
                methodTree = ExpansionStatistics.buildMethodTree(graph);
            }
            ExpansionStatistics.printExpansionTree(compilable, methodTree, tier);
        }
        if (nodeExpansion) {
            if (methodTree == null) {
                methodTree = ExpansionStatistics.buildMethodTree(graph);
            }
            nodeTree = methodTree.groupByNode();
            ExpansionStatistics.printExpansionTree(compilable, nodeTree, tier);
        }
        if (methodExpansionStat) {
            if (methodTree == null) {
                methodTree = ExpansionStatistics.buildMethodTree(graph);
            }
            HashMap sums = new HashMap();
            methodTree.acceptStats(sums, tree -> tree.position == null ? null : tree.position.getMethod(), compilable.getName());
            this.combineExpansionStatistics(tier, this.methodExpansionStatistics, sums);
        }
        if (nodeExpansionStat) {
            if (methodTree == null) {
                methodTree = ExpansionStatistics.buildMethodTree(graph);
            }
            if (nodeTree == null) {
                nodeTree = methodTree.groupByNode();
            }
            HashMap classSums = new HashMap();
            nodeTree.acceptStats(classSums, tree -> new NodeClassKey((TreeNode)tree), compilable.getName());
            this.combineExpansionStatistics(tier, this.nodeExpansionStatistics, classSums);
            HashMap specializationSums = new HashMap();
            nodeTree.acceptStats(specializationSums, tree -> new NodeSpecializationKey((TreeNode)tree, this.isSpecializationMethodCache), compilable.getName());
            this.combineExpansionStatistics(tier, this.specializationExpansionStatistics, specializationSums);
        }
    }

    void onShutdown() {
        CompilableTruffleAST ast = this.previousCompilation;
        if (ast == null) {
            return;
        }
        for (Map.Entry<PolyglotCompilerOptions.CompilationTier, Map<ResolvedJavaMethod, Stats>> entry : this.methodExpansionStatistics.entrySet()) {
            ExpansionStatistics.printHistogram(ast, entry.getKey(), entry.getValue(), ExpansionStatistics::formatQualifiedMethod, null, null, null, "Method");
        }
        for (Map.Entry<PolyglotCompilerOptions.CompilationTier, Map<Object, Stats>> entry : this.nodeExpansionStatistics.entrySet()) {
            ExpansionStatistics.printHistogram(ast, entry.getKey(), entry.getValue(), info -> info == null ? "no info" : info.getLabel(), this.specializationExpansionStatistics.get((Object)entry.getKey()), s -> s.getLabel(), s -> s.classKey, "Node");
        }
    }

    private static <T, S> void printHistogram(CompilableTruffleAST ast, PolyglotCompilerOptions.CompilationTier tier, Map<T, Stats> statsMap, Function<T, String> labelFunction, Map<S, Stats> subGroupMap, Function<S, String> subGroupLabelFunction, Function<S, T> subGroupToGroup, String kind) {
        StringWriter writer = new StringWriter();
        try (PrintWriter w = new PrintWriter(writer);){
            List subGroup;
            String label;
            List entries = statsMap.entrySet().stream().sorted(ExpansionStatistics::orderBySumDesc).collect(Collectors.toList());
            HashMap<Object, List> subGroups = null;
            if (subGroupMap != null) {
                List subEntries = subGroupMap.entrySet().stream().sorted(ExpansionStatistics::orderBySumDesc).collect(Collectors.toList());
                subGroups = new HashMap<Object, List>();
                for (Map.Entry entry : subEntries) {
                    List subGroup2 = subGroups.computeIfAbsent(subGroupToGroup.apply(entry.getKey()), k -> new ArrayList());
                    subGroup2.add(entry);
                }
            }
            String indent = "  ";
            int maxLabelLength = 50;
            for (Map.Entry entry : entries) {
                label = labelFunction.apply(entry.getKey());
                int labelLength = label.length();
                if (subGroups != null) {
                    subGroup = (List)subGroups.get(entry.getKey());
                    for (Map.Entry sub : subGroup) {
                        maxLabelLength = Math.max(subGroupLabelFunction.apply(sub.getKey()).length(), maxLabelLength);
                    }
                }
                maxLabelLength = Math.max(labelLength, maxLabelLength);
            }
            w.printf("%-" + (maxLabelLength += indent.length()) + "s    Count IR Nodes (min avg max)        Size (min avg max)      Cycles (min avg max)       Ifs  Loops Invokes Allocs | Max IRNode ASTNode Unit:Lang:File:Line:Chars%n", "Name");
            block8: for (Map.Entry entry : entries) {
                label = labelFunction.apply(entry.getKey());
                Stats stats = (Stats)entry.getValue();
                ExpansionStatistics.printHistogramStats(w, indent, maxLabelLength, label, stats);
                if (subGroups == null || (subGroup = (List)subGroups.get(entry.getKey())) == null || subGroup.size() <= 0) continue;
                for (Map.Entry subEntry : subGroup) {
                    String subLabel = subGroupLabelFunction.apply(subEntry.getKey());
                    if (subGroup.size() == 1 && subLabel.equals("<unknown>")) continue block8;
                    ExpansionStatistics.printHistogramStats(w, indent + "  ", maxLabelLength, subLabel, (Stats)subEntry.getValue());
                }
            }
        }
        TruffleCompilerRuntime.getRuntime().log(ast, String.format("%s expansion statistics after %s:%n%s", kind, tier.toString(), writer.toString()));
    }

    private static void printHistogramStats(PrintWriter w, String indent, int maxLabelLength, String label, Stats stats) {
        String sourceString = ExpansionStatistics.formatSourceAndCompilation(stats.maxCompilation, stats.maxSourcePosition);
        int useWidth = Math.max(maxLabelLength - indent.length(), 10);
        w.printf("%s%-" + useWidth + "s %8d %8d %-16s %8d %-16s %8d %-16s %6d %6d %7d %6d | %10s %7s %s%n", indent, label, stats.count.getCount(), stats.count.getSum(), String.format("(%d %.1f %d)", stats.count.getMin(), stats.count.getAverage(), stats.count.getMax()), stats.size.getSum(), String.format("(%d %.1f %d)", stats.size.getMin(), stats.size.getAverage(), stats.size.getMax()), stats.cycles.getSum(), String.format("(%d %.1f %d)", stats.cycles.getMin(), stats.cycles.getAverage(), stats.cycles.getMax()), stats.conditions.getSum(), stats.loops.getSum(), stats.invokes.getSum(), stats.allocs.getSum(), stats.maxGraalNodeId == -1 ? "" : Integer.valueOf(stats.maxGraalNodeId), ExpansionStatistics.getTruffleNodeId(stats.maxSourcePosition) == -1 ? "" : Integer.valueOf(ExpansionStatistics.getTruffleNodeId(stats.maxSourcePosition)), sourceString);
    }

    private static <T> int orderBySumDesc(Map.Entry<T, Stats> e0, Map.Entry<T, Stats> e1) {
        return Long.compare(e1.getValue().count.getSum(), e0.getValue().count.getSum());
    }

    private static TreeNode buildMethodTree(StructuredGraph graph) {
        TreeNode root = new TreeNode(null, null, ExpansionStatistics::buildMethodTreeLabel);
        SchedulePhase.runWithoutContextOptimizations(graph, SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS, true);
        ControlFlowGraph cfg = graph.getLastSchedule().getCFG();
        for (Node node : graph.getNodes()) {
            double frequency;
            NodeSourcePosition nodeSourcePosition = node.getNodeSourcePosition();
            TreeNode tree = ExpansionStatistics.resolveMethodTree(root, nodeSourcePosition);
            HIRBlock block = cfg.blockFor(node);
            if (block != null) {
                frequency = block.getRelativeFrequency();
                assert (frequency != -0.0);
            } else {
                frequency = -0.0;
            }
            tree.frequency = Math.max(tree.frequency, frequency);
            tree.graalNodes.add(node);
        }
        return root;
    }

    private static String buildMethodTreeLabel(NodeSourcePosition pos) {
        if (pos == null || pos.getMethod() == null) {
            return "<root>";
        }
        return ExpansionStatistics.formatQualifiedMethod(pos.getMethod());
    }

    private static TreeNode resolveMethodTree(TreeNode root, NodeSourcePosition pos) {
        if (pos == null) {
            return root;
        }
        TreeNode parent = ExpansionStatistics.resolveMethodTree(root, pos.getCaller());
        return parent.children.computeIfAbsent(new MethodKey(pos), p -> new TreeNode(parent, pos, root.label));
    }

    private synchronized <T> void combineExpansionStatistics(PolyglotCompilerOptions.CompilationTier tier, Map<PolyglotCompilerOptions.CompilationTier, Map<T, Stats>> stats, Map<T, Stats> newStats) {
        Map<T, Stats> methodStats = stats.get((Object)tier);
        if (methodStats == null) {
            methodStats = new HashMap<T, Stats>();
            stats.put(tier, methodStats);
        }
        for (Map.Entry<T, Stats> entry : newStats.entrySet()) {
            Stats s = entry.getValue();
            methodStats.computeIfAbsent(entry.getKey(), m -> new Stats()).combine(s);
        }
    }

    private static void printExpansionTree(CompilableTruffleAST compilable, TreeNode tree, PolyglotCompilerOptions.CompilationTier tier) {
        StringWriter writer = new StringWriter();
        try (PrintWriter w = new PrintWriter(writer);){
            tree.print(w);
        }
        TruffleCompilerRuntime.getRuntime().log(compilable, String.format("Expansion tree for %s after %s:%n%s", compilable.getName(), tier.toString(), writer.toString()));
    }

    private static String formatQualifiedMethod(ResolvedJavaMethod method) {
        if (method == null) {
            return "<no-source-position>";
        }
        String className = method.getDeclaringClass().getUnqualifiedName();
        return className + "." + ExpansionStatistics.formatMethod(method, 60);
    }

    private static String formatMethod(ResolvedJavaMethod method, int maxSignature) {
        if (method == null) {
            return "<no-source-position>";
        }
        StringBuilder signatureBuilder = new StringBuilder();
        ResolvedJavaType declaringType = method.getDeclaringClass();
        Signature signature = method.getSignature();
        String sep = "";
        for (int i = 0; i < signature.getParameterCount(false); ++i) {
            JavaType type = signature.getParameterType(i, declaringType);
            signatureBuilder.append(sep);
            signatureBuilder.append(type.getUnqualifiedName());
            sep = ", ";
        }
        if (method.getName().length() + signatureBuilder.length() > maxSignature) {
            return method.getName() + "(..." + signature.getParameterCount(false) + ")";
        }
        return method.getName() + "(" + signatureBuilder.toString() + ")";
    }

    private static int getTruffleNodeId(NodeSourcePosition position) {
        return position != null && position.getSourceLanguage() != null ? position.getSourceLanguage().getNodeId() : -1;
    }

    private static String formatSourceAndCompilation(String compilation, NodeSourcePosition pos) {
        if (pos == null || pos.getSourceLanguage() == null) {
            return compilation;
        }
        return compilation + ":" + ExpansionStatistics.formatSource(pos);
    }

    private static String formatSource(NodeSourcePosition pos) {
        String p;
        if (pos == null) {
            return "";
        }
        SourceLanguagePosition source = pos.getSourceLanguage();
        if (source == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(source.getLanguage());
        String string = p = source.getURI() != null ? source.getURI().getPath() : null;
        if (p != null) {
            int lastIndex = p.lastIndexOf(47);
            if (lastIndex != -1) {
                p = p.substring(lastIndex + 1, p.length());
            }
            b.append(":").append(p);
        }
        b.append(":").append(source.getLineNumber());
        b.append(":").append(source.getOffsetStart());
        b.append("-").append(source.getOffsetEnd());
        String sourceString = b.toString();
        return sourceString;
    }

    private static String formatClassName(String qualifiedName) {
        String chunk;
        String[] chunks = qualifiedName.split("\\.");
        StringBuilder b = new StringBuilder();
        String sep = "";
        for (int i = chunks.length - 1; i >= 0 && !(chunk = chunks[i]).isEmpty() && Character.isUpperCase(chunk.charAt(0)); --i) {
            b.append(sep);
            b.append(chunk);
            sep = ".";
        }
        if (b.length() == 0) {
            return qualifiedName;
        }
        return b.toString();
    }

    static final class TreeNode {
        static final double UNSET_FREQUENCY = -0.0;
        final TreeNode parent;
        final Map<MethodKey, TreeNode> children = new TreeMap<MethodKey, TreeNode>();
        final Function<NodeSourcePosition, String> label;
        NodeSourcePosition position;
        final List<Node> graalNodes = new ArrayList<Node>();
        double frequency = -0.0;

        TreeNode(TreeNode parent, NodeSourcePosition position, Function<NodeSourcePosition, String> label) {
            this.parent = parent;
            this.position = position;
            this.label = label;
        }

        Set<ResolvedJavaMethod> findSpecializationMethods(ConcurrentHashMap<ResolvedJavaMethod, Boolean> cache) {
            HashSet<ResolvedJavaMethod> specializations = new HashSet<ResolvedJavaMethod>();
            int nodeId = ExpansionStatistics.getTruffleNodeId(this.position);
            for (Node node : this.graalNodes) {
                SourceLanguagePosition sourceLang;
                for (NodeSourcePosition currentPos = node.getNodeSourcePosition(); currentPos != null && ((sourceLang = currentPos.getSourceLanguage()) == null || sourceLang.getNodeId() == nodeId); currentPos = currentPos.getCaller()) {
                    ResolvedJavaMethod method = currentPos.getMethod();
                    if (method == null || !TreeNode.isSpecializationMethod(method, cache)) continue;
                    specializations.add(currentPos.getMethod());
                }
            }
            this.findSpecializationMethodsWithNodeId(specializations, nodeId, cache);
            return specializations;
        }

        private static boolean isSpecializationMethod(ResolvedJavaMethod method, ConcurrentHashMap<ResolvedJavaMethod, Boolean> cache) {
            return cache.computeIfAbsent(method, m -> TruffleCompilerRuntime.getRuntime().isSpecializationMethod((ResolvedJavaMethod)m));
        }

        private void findSpecializationMethodsWithNodeId(Set<ResolvedJavaMethod> specializations, int nodeId, ConcurrentHashMap<ResolvedJavaMethod, Boolean> cache) {
            for (Node node : this.graalNodes) {
                for (NodeSourcePosition currentPos = node.getNodeSourcePosition(); currentPos != null; currentPos = currentPos.getCaller()) {
                    ResolvedJavaMethod method;
                    SourceLanguagePosition sourceLang = currentPos.getSourceLanguage();
                    if (sourceLang == null || sourceLang.getNodeId() != nodeId || (method = currentPos.getMethod()) == null || !TreeNode.isSpecializationMethod(method, cache)) continue;
                    specializations.add(currentPos.getMethod());
                }
            }
            for (TreeNode child : this.children.values()) {
                child.findSpecializationMethodsWithNodeId(specializations, nodeId, cache);
            }
        }

        <T> void acceptStats(Map<T, Stats> stats, Function<TreeNode, T> keyFactory, String compilation) {
            T key = keyFactory.apply(this);
            Sums newSum = this.createSums();
            Stats stat = stats.get(key);
            if (stat == null) {
                stat = new Stats();
                stats.put(key, stat);
            }
            stat.accept(newSum, this.position, compilation, this.getGraalNodeId());
            for (TreeNode tree : this.children.values()) {
                tree.acceptStats(stats, keyFactory, compilation);
            }
        }

        int getGraalNodeId() {
            if (this.graalNodes.isEmpty()) {
                return -1;
            }
            return this.graalNodes.get(0).getId();
        }

        TreeNode groupByNode() {
            return this.newGroup(new TreeNode(null, this.position, n -> {
                if (n != null && n.getSourceLanguage() != null) {
                    return ExpansionStatistics.formatClassName(n.getSourceLanguage().getNodeClassName());
                }
                return "<call-root>";
            }), (t0, t1) -> {
                int id1;
                int id0 = ExpansionStatistics.getTruffleNodeId(t0.position);
                if (id0 == (id1 = ExpansionStatistics.getTruffleNodeId(t1.position)) || id0 != -1 && id1 == -1) {
                    return 0;
                }
                return 1;
            });
        }

        TreeNode newGroup(TreeNode newNode, Comparator<TreeNode> comparison) {
            newNode.merge(this);
            for (Map.Entry<MethodKey, TreeNode> child : this.children.entrySet()) {
                newNode.tryMerge(child.getKey(), child.getValue(), comparison);
            }
            return newNode;
        }

        private void tryMerge(MethodKey method, TreeNode tree, Comparator<TreeNode> groupCriteria) {
            if (groupCriteria.compare(this, tree) == 0) {
                this.merge(tree);
                if (this.position == null) {
                    this.position = tree.position;
                }
                for (Map.Entry<MethodKey, TreeNode> child : tree.children.entrySet()) {
                    this.tryMerge(child.getKey(), child.getValue(), groupCriteria);
                }
                HashSet<MethodKey> toRemove = new HashSet<MethodKey>();
                HashMap<Integer, TreeNode> mergeChildren = new HashMap<Integer, TreeNode>();
                for (Map.Entry<MethodKey, TreeNode> entry : new ArrayList<Map.Entry<MethodKey, TreeNode>>(this.children.entrySet())) {
                    TreeNode mergeTarget = (TreeNode)mergeChildren.get(ExpansionStatistics.getTruffleNodeId(entry.getValue().position));
                    if (mergeTarget != null) {
                        mergeTarget.merge(entry.getValue());
                        mergeTarget.children.putAll(entry.getValue().children);
                        toRemove.add(entry.getKey());
                        continue;
                    }
                    mergeChildren.put(ExpansionStatistics.getTruffleNodeId(entry.getValue().position), entry.getValue());
                }
                this.children.keySet().removeAll(toRemove);
            } else {
                TreeNode newGroup = this.children.get(method);
                if (newGroup == null) {
                    newGroup = new TreeNode(this, tree.position, this.label);
                } else assert (newGroup.parent == this);
                this.children.put(method, tree.newGroup(newGroup, groupCriteria));
            }
        }

        private void merge(TreeNode input) {
            if (input == null) {
                return;
            }
            this.graalNodes.addAll(input.graalNodes);
            this.frequency = Math.max(this.frequency, input.frequency);
        }

        void print(PrintWriter writer) {
            int width = Math.min(this.maxLabelLength() + 5, 150);
            TreeNode.printHeader(writer, width);
            this.printRec(writer, width, "");
        }

        private int maxLabelLength() {
            int maxLength = 0;
            for (TreeNode tree : this.children.values()) {
                maxLength = Math.max(tree.maxLabelLength(), maxLength);
            }
            return Math.max(this.depth() + this.getLabel().length() + 1, maxLength);
        }

        private int depth() {
            int maxDepth = 0;
            for (TreeNode tree : this.children.values()) {
                maxDepth = Math.max(tree.depth(), maxDepth);
            }
            return maxDepth + 1;
        }

        private Sums createRecursiveSum() {
            Sums stats = this.createSums();
            for (TreeNode child : this.children.values()) {
                stats = stats.add(child.createRecursiveSum());
            }
            return stats;
        }

        private Sums createSums() {
            return new Sums(this.graalNodes, this.position, this.getGraalNodeId());
        }

        private static void printHeader(PrintWriter writer, int width) {
            writer.printf("%-" + width + "sFrequency | Count    Size  Cycles   Ifs Loops Invokes Allocs | Self Count  Size Cycles   Ifs Loops Invokes Allocs | IRNode ASTNode Lang:File:Line:Chars %n", "Name");
        }

        private void printRec(PrintWriter writer, int width, String sep) {
            Sums shallowStats = this.createSums();
            Sums deepStats = this.createRecursiveSum();
            int useWidth = Math.max(width - sep.length(), 10);
            writer.printf("%s%-" + useWidth + "s %8.2f | %5d %7d %7d %5d %5d %7d %6d | %10d %5d %6d %5d %5d %7d %6d | %s %n", sep, this.getLabel(), this.getFrequency(), deepStats.count, deepStats.size, deepStats.cycles, deepStats.conditions, deepStats.loops, deepStats.invokes, deepStats.allocs, shallowStats.count, shallowStats.size, shallowStats.cycles, shallowStats.conditions, shallowStats.loops, shallowStats.invokes, shallowStats.allocs, this.getSourceString());
            String newSep = sep + " ";
            for (TreeNode tree : this.children.values()) {
                tree.printRec(writer, width, newSep);
            }
        }

        private double getFrequency() {
            if (this.parent == null) {
                return 1.0;
            }
            if (this.frequency == -0.0 && this.parent != null) {
                return this.parent.getFrequency();
            }
            return this.frequency;
        }

        private String getSourceString() {
            if (this.position == null) {
                return " - ";
            }
            SourceLanguagePosition source = this.position.getSourceLanguage();
            String irNode = "";
            if (!this.graalNodes.isEmpty()) {
                irNode = String.valueOf(this.graalNodes.iterator().next().getId());
            }
            String astNode = "";
            String sourceString = "";
            if (source != null) {
                if (source.getNodeId() != -1) {
                    astNode = String.valueOf(source.getNodeId());
                }
                sourceString = ExpansionStatistics.formatSource(this.position);
            }
            return String.format("%6s %7s %6s", irNode, astNode, sourceString);
        }

        private String getLabel() {
            return this.label.apply(this.position);
        }
    }

    static final class Stats {
        final IntSummaryStatistics count = new IntSummaryStatistics();
        final IntSummaryStatistics size = new IntSummaryStatistics();
        final IntSummaryStatistics cycles = new IntSummaryStatistics();
        final IntSummaryStatistics conditions = new IntSummaryStatistics();
        final IntSummaryStatistics loops = new IntSummaryStatistics();
        final IntSummaryStatistics invokes = new IntSummaryStatistics();
        final IntSummaryStatistics allocs = new IntSummaryStatistics();
        NodeSourcePosition maxSourcePosition;
        int maxGraalNodeId = -1;
        String maxCompilation;

        Stats() {
        }

        void accept(Sums sums, NodeSourcePosition sourcePosition, String compilation, int graalNodeId) {
            if (sums.count > this.count.getMax()) {
                this.maxGraalNodeId = graalNodeId;
                this.maxCompilation = compilation;
                this.maxSourcePosition = sourcePosition;
            }
            this.count.accept(sums.count);
            this.size.accept(sums.size);
            this.cycles.accept(sums.cycles);
            this.conditions.accept(sums.conditions);
            this.loops.accept(sums.loops);
            this.invokes.accept(sums.invokes);
            this.allocs.accept(sums.allocs);
        }

        void combine(Stats s) {
            if (s.count.getMax() > this.count.getMax()) {
                this.maxGraalNodeId = s.maxGraalNodeId;
                this.maxCompilation = s.maxCompilation;
                this.maxSourcePosition = s.maxSourcePosition;
            }
            this.count.combine(s.count);
            this.size.combine(s.size);
            this.cycles.combine(s.cycles);
            this.conditions.combine(s.conditions);
            this.loops.combine(s.loops);
            this.invokes.combine(s.invokes);
            this.allocs.combine(s.allocs);
        }
    }

    private static class MethodKey
    implements Comparable<MethodKey> {
        final NodeSourcePosition position;

        MethodKey(NodeSourcePosition position) {
            this.position = position;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodKey)) {
                return false;
            }
            NodeSourcePosition other = ((MethodKey)obj).position;
            if (!Objects.equals(this.position.getCaller(), other.getCaller())) {
                return false;
            }
            return Objects.equals(this.position.getMethod(), other.getMethod()) && Objects.equals(this.position.getSourceLanguage(), other.getSourceLanguage());
        }

        @Override
        public int compareTo(MethodKey o) {
            NodeSourcePosition otherParent;
            if (this.equals(o)) {
                return 0;
            }
            NodeSourcePosition thisParent = this.position.getCaller();
            if (Objects.equals(thisParent, otherParent = o.position.getCaller()) && thisParent != null) {
                return Integer.compare(thisParent.getBCI(), otherParent.getBCI());
            }
            return 1;
        }

        public int hashCode() {
            return Objects.hash(this.position.getCaller(), this.position.getMethod(), this.position.getSourceLanguage());
        }
    }

    private static class NodeSpecializationKey {
        private final NodeClassKey classKey;
        private final Set<ResolvedJavaMethod> specializations;

        NodeSpecializationKey(TreeNode tree, ConcurrentHashMap<ResolvedJavaMethod, Boolean> isSpecializationCache) {
            this.classKey = new NodeClassKey(tree);
            this.specializations = tree.findSpecializationMethods(isSpecializationCache);
        }

        public int hashCode() {
            return Objects.hash(this.classKey, this.specializations);
        }

        String getLabel() {
            if (this.specializations.isEmpty()) {
                return "<unknown>";
            }
            StringBuilder b = new StringBuilder("[");
            String sep = "";
            for (ResolvedJavaMethod method : this.specializations) {
                b.append(sep);
                b.append(ExpansionStatistics.formatMethod(method, 40));
                sep = ", ";
            }
            b.append("]");
            return b.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeSpecializationKey)) {
                return false;
            }
            NodeSpecializationKey other = (NodeSpecializationKey)obj;
            return Objects.equals(this.classKey, other.classKey) && Objects.equals(this.specializations, other.specializations);
        }
    }

    private static class NodeClassKey {
        private final String name;

        NodeClassKey(TreeNode tree) {
            NodeSourcePosition pos = tree.position;
            if (pos != null && pos.getSourceLanguage() != null) {
                SourceLanguagePosition source = pos.getSourceLanguage();
                this.name = source.getNodeClassName();
            } else {
                this.name = null;
            }
        }

        String getLabel() {
            if (this.name == null) {
                return "<call-root>";
            }
            return ExpansionStatistics.formatClassName(this.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeClassKey)) {
                return false;
            }
            NodeClassKey other = (NodeClassKey)obj;
            return Objects.equals(this.name, other.name);
        }
    }

    static class Sums {
        final NodeSourcePosition nodeSourcePosition;
        final int graalNodeId;
        final int count;
        final int size;
        final int cycles;
        final int conditions;
        final int loops;
        final int invokes;
        final int allocs;

        Sums(List<Node> nodes, NodeSourcePosition position, int graalNodeId) {
            this.count = nodes.size();
            this.size = Sums.computeSize(nodes);
            this.cycles = Sums.computeCycles(nodes);
            int invokeSum = 0;
            int loopSum = 0;
            int conditionSum = 0;
            int allocationSum = 0;
            for (Node node : nodes) {
                if (node instanceof InvokeNode) {
                    ++invokeSum;
                }
                if (node instanceof LoopBeginNode) {
                    ++loopSum;
                }
                if (node instanceof IfNode) {
                    ++conditionSum;
                }
                if (!(node instanceof VirtualizableAllocation)) continue;
                ++allocationSum;
            }
            this.conditions = conditionSum;
            this.loops = loopSum;
            this.invokes = invokeSum;
            this.allocs = allocationSum;
            this.nodeSourcePosition = position;
            this.graalNodeId = graalNodeId;
        }

        Sums(int count, int size, int cycles, int conditions, int loops, int invokes, int allocs, NodeSourcePosition position, int graalNodeId) {
            this.count = count;
            this.size = size;
            this.cycles = cycles;
            this.conditions = conditions;
            this.loops = loops;
            this.invokes = invokes;
            this.allocs = allocs;
            this.nodeSourcePosition = position;
            this.graalNodeId = graalNodeId;
        }

        Sums add(Sums stats) {
            return new Sums(this.count + stats.count, this.size + stats.size, this.cycles + stats.cycles, this.conditions + stats.conditions, this.loops + stats.loops, this.invokes + stats.invokes, this.allocs + stats.allocs, this.nodeSourcePosition, this.graalNodeId);
        }

        private static int computeSize(List<Node> nodes) {
            int sum = 0;
            for (Node node : nodes) {
                sum += node.estimatedNodeSize().value;
            }
            return sum;
        }

        private static int computeCycles(List<Node> nodes) {
            int sum = 0;
            for (Node node : nodes) {
                sum += node.estimatedNodeCycles().value;
            }
            return sum;
        }
    }
}

