/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import java.io.IOException;
import java.util.Map;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.graphio.GraphOutput;

public class TruffleDebugContextImpl
implements TruffleDebugContext {
    public final DebugContext debugContext;

    public TruffleDebugContextImpl(DebugContext debugContext) {
        this.debugContext = debugContext;
    }

    @Override
    public <G, N, M> GraphOutput<G, M> buildOutput(GraphOutput.Builder<G, N, M> builder) throws IOException {
        return this.debugContext.buildOutput(builder);
    }

    @Override
    public boolean isDumpEnabled() {
        return this.debugContext.isDumpEnabled(1);
    }

    @Override
    public Map<Object, Object> getVersionProperties() {
        return DebugContext.addVersionProperties(null);
    }

    @Override
    public AutoCloseable scope(String name) {
        return this.debugContext.scope(name);
    }

    @Override
    public AutoCloseable scope(String name, Object context) {
        try {
            return this.debugContext.scope((Object)name, context);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void close() {
        this.debugContext.close();
    }

    @Override
    public void closeDebugChannels() {
        this.debugContext.closeDumpHandlers(false);
    }
}

