/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.truffle.compiler.substitutions.KnownTruffleTypes;

public class TruffleStringConstantFieldProvider
implements ConstantFieldProvider {
    private static final int FLAG_IMPRECISE = 16;
    protected final ConstantFieldProvider graalConstantFieldProvider;
    protected final MetaAccessProvider metaAccess;
    private final KnownTruffleTypes types;
    private final ResolvedJavaType byteArrayType;

    public TruffleStringConstantFieldProvider(ConstantFieldProvider graalConstantFieldProvider, MetaAccessProvider metaAccess, KnownTruffleTypes types) {
        this.graalConstantFieldProvider = graalConstantFieldProvider;
        this.metaAccess = metaAccess;
        this.types = types;
        this.byteArrayType = metaAccess.lookupJavaType(byte[].class);
    }

    @Override
    public <T> T readConstantField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        boolean isStaticField = field.isStatic();
        if (!isStaticField && tool.getReceiver().isNull()) {
            return null;
        }
        T wellKnownField = this.readWellKnownConstantTruffleField(field, tool);
        if (wellKnownField != null) {
            return wellKnownField;
        }
        return this.graalConstantFieldProvider.readConstantField(field, tool);
    }

    protected <T> T readWellKnownConstantTruffleField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        JavaConstant value;
        if ((this.types.truffleStringDataField.equals(field) || this.types.truffleStringHashCodeField.equals(field) || this.types.truffleStringCodeRangeField.equals(field) || this.types.truffleStringCodePointLengthField.equals(field)) && this.types.truffleStringType.isAssignableFrom(this.metaAccess.lookupJavaType(tool.getReceiver())) && (value = tool.readValue()) != null) {
            if (this.types.truffleStringDataField.equals(field)) {
                if (this.byteArrayType.isAssignableFrom(this.metaAccess.lookupJavaType(value))) {
                    return tool.foldStableArray(value, 1, true);
                }
            } else if (this.types.truffleStringHashCodeField.equals(field)) {
                if (!value.isDefaultForKind()) {
                    return tool.foldConstant(value);
                }
            } else if (this.types.truffleStringCodeRangeField.equals(field)) {
                if ((value.asInt() & 0x10) == 0) {
                    return tool.foldConstant(value);
                }
            } else {
                assert (this.types.truffleStringCodePointLengthField.equals(field));
                if (value.asInt() >= 0) {
                    return tool.foldConstant(value);
                }
            }
        }
        return null;
    }

    @Override
    public boolean maybeFinal(ResolvedJavaField field) {
        return this.types.truffleStringDataField.equals(field) || this.types.truffleStringHashCodeField.equals(field) || this.types.truffleStringCodeRangeField.equals(field) || this.types.truffleStringCodePointLengthField.equals(field) || this.graalConstantFieldProvider.maybeFinal(field);
    }
}

