/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import java.lang.ref.Reference;
import java.lang.reflect.Type;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.nodes.HotSpotLoadReservedReferenceNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotStoreReservedReferenceNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotKnownTruffleTypes;
import org.graalvm.compiler.word.WordTypes;

final class HotSpotTruffleGraphBuilderPlugins {
    HotSpotTruffleGraphBuilderPlugins() {
    }

    static void registerCompilationFinalReferencePlugins(InvocationPlugins plugins, final boolean canDelayIntrinsification, final HotSpotKnownTruffleTypes types) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Reference.class));
        r.register(new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{InvocationPlugin.Receiver.class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant constant;
                if (!canDelayIntrinsification && receiver.isConstant() && (constant = (JavaConstant)receiver.get().asConstant()).isNonNull() && (types.classWeakReference.isInstance(constant) || types.classSoftReference.isInstance(constant))) {
                    JavaConstant referent = b.getConstantReflection().readFieldValue(types.referenceReferent, constant);
                    b.addPush(JavaKind.Object, ConstantNode.forConstant(referent, b.getMetaAccess()));
                    return true;
                }
                return false;
            }
        });
    }

    static void registerHotspotThreadLocalStubPlugins(InvocationPlugins plugins, final WordTypes wordTypes, final int jvmciReservedReference0Offset) {
        GraalError.guarantee(jvmciReservedReference0Offset != -1, "jvmciReservedReference0Offset is not available but used.");
        InvocationPlugins.Registration tl = new InvocationPlugins.Registration(plugins, "org.graalvm.compiler.truffle.runtime.hotspot.HotSpotFastThreadLocal");
        tl.register(new InvocationPlugin.RequiredInvocationPlugin("getJVMCIReservedReference", new Type[0]){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, new HotSpotLoadReservedReferenceNode(b.getMetaAccess(), wordTypes, jvmciReservedReference0Offset));
                return true;
            }
        });
        tl.register(new InvocationPlugin.RequiredInvocationPlugin("setJVMCIReservedReference", new Type[]{Object[].class}){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.add(new HotSpotStoreReservedReferenceNode(wordTypes, value, jvmciReservedReference0Offset));
                return true;
            }
        });
    }
}

