/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot.aarch64;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotBackend;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotMove;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotZBarrierSetLIRGenerator;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.lir.aarch64.AArch64FrameMap;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.EntryPointDecorator;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleCallBoundaryInstrumentationFactory;
import org.graalvm.compiler.truffle.compiler.hotspot.TruffleEntryPointDecorator;

@ServiceProvider(value=TruffleCallBoundaryInstrumentationFactory.class)
public class AArch64TruffleCallBoundaryInstrumentationFactory
extends TruffleCallBoundaryInstrumentationFactory {
    @Override
    public EntryPointDecorator create(MetaAccessProvider metaAccess, GraalHotSpotVMConfig config, HotSpotRegistersProvider registers) {
        return new TruffleEntryPointDecorator(metaAccess, config, registers){

            @Override
            public void emitEntryPoint(CompilationResultBuilder crb) {
                AArch64MacroAssembler masm = (AArch64MacroAssembler)crb.asm;
                AArch64HotSpotBackend.emitInvalidatePlaceholder(crb, masm);
                try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                    Register thisRegister = crb.codeCache.getRegisterConfig().getCallingConventionRegisters((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, JavaKind.Object).get(0);
                    Register spillRegister = scratch.getRegister();
                    Label doProlog = new Label();
                    if (this.config.useCompressedOops) {
                        CompressEncoding encoding = this.config.getOopEncoding();
                        masm.ldr(32, spillRegister, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thisRegister, this.installedCodeOffset));
                        Register base = encoding.hasBase() ? this.registers.getHeapBaseRegister() : null;
                        AArch64HotSpotMove.UncompressPointer.emitUncompressCode(masm, spillRegister, spillRegister, base, encoding.getShift(), true);
                    } else {
                        AArch64Address address = AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, thisRegister, this.installedCodeOffset);
                        masm.ldr(64, spillRegister, address);
                        if (this.config.gc == HotSpotGraalRuntime.HotSpotGC.Z) {
                            ForeignCallLinkage callTarget = crb.providers.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_FIELD_BARRIER);
                            AArch64FrameMap frameMap = (AArch64FrameMap)crb.frameMap;
                            AArch64HotSpotZBarrierSetLIRGenerator.emitBarrier(crb, masm, null, spillRegister, this.config, callTarget, address, null, frameMap);
                        }
                    }
                    masm.ldr(64, spillRegister, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_UNSIGNED_SCALED, spillRegister, this.entryPointOffset));
                    masm.cbz(64, spillRegister, doProlog);
                    masm.jmp(spillRegister);
                    masm.nop();
                    masm.bind(doProlog);
                }
            }
        };
    }

    @Override
    public String getArchitecture() {
        return "aarch64";
    }
}

