/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessFlags;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessVerificationNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessorNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public class VirtualFrameClearNode
extends VirtualFrameAccessorNode
implements Virtualizable,
IterableNodeType {
    public static final NodeClass<VirtualFrameClearNode> TYPE = NodeClass.create(VirtualFrameClearNode.class);

    public VirtualFrameClearNode(InvocationPlugin.Receiver frame, int frameSlotIndex, int illegalTag, VirtualFrameAccessType type, VirtualFrameAccessFlags accessFlags) {
        super(TYPE, StampFactory.forVoid(), frame, frameSlotIndex, illegalTag, type, accessFlags);
        assert (accessFlags.updatesFrame());
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode tagAlias = tool.getAlias(this.frame.getTagArray(this.type));
        ValueNode localsAlias = tool.getAlias(this.frame.getObjectArray(this.type));
        ValueNode primitiveAlias = tool.getAlias(this.frame.getPrimitiveArray(this.type));
        if (tagAlias instanceof VirtualObjectNode && localsAlias instanceof VirtualObjectNode && primitiveAlias instanceof VirtualObjectNode) {
            VirtualObjectNode tagVirtual = (VirtualObjectNode)tagAlias;
            VirtualObjectNode localsVirtual = (VirtualObjectNode)localsAlias;
            VirtualObjectNode primitiveVirtual = (VirtualObjectNode)primitiveAlias;
            if (this.frameSlotIndex < tagVirtual.entryCount()) {
                JavaKind tagKind = tagVirtual.entryKind(tool.getMetaAccessExtensionProvider(), this.frameSlotIndex);
                boolean success = this.accessFlags.isStatic() ? tool.setVirtualEntry(tagVirtual, this.frameSlotIndex, this.getConstantWithStaticModifier(this.accessTag), tagKind, -1L) : tool.setVirtualEntry(tagVirtual, this.frameSlotIndex, this.getConstant(this.accessTag), tagKind, -1L);
                if (this.accessFlags.isObject()) {
                    boolean bl = success = success && tool.setVirtualEntry(localsVirtual, this.frameSlotIndex, ConstantNode.defaultForKind(JavaKind.Object, this.graph()), JavaKind.Object, -1L);
                }
                if (this.accessFlags.isPrimitive()) {
                    boolean bl = success = success && tool.setVirtualEntry(primitiveVirtual, this.frameSlotIndex, ConstantNode.defaultForKind(JavaKind.Long, this.graph()), JavaKind.Long, -1L);
                }
                if (success) {
                    tool.delete();
                    return;
                }
            }
        }
        this.insertDeoptimization(tool);
    }

    @Override
    public <State> void updateVerificationState(VirtualFrameAccessVerificationNode.VirtualFrameVerificationStateUpdater<State> updater, State state) {
        updater.clear(state, this.getFrameSlotIndex());
    }
}

