/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessFlags;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessorNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameGetNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameGetNode> TYPE = NodeClass.create(VirtualFrameGetNode.class);
    private final JavaKind accessKind;

    public VirtualFrameGetNode(InvocationPlugin.Receiver frame, int frameSlotIndex, JavaKind accessKind, int accessTag, VirtualFrameAccessType type, VirtualFrameAccessFlags accessFlags) {
        super(TYPE, StampFactory.forKind(accessKind), frame, frameSlotIndex, accessTag, type, accessFlags);
        this.accessKind = accessKind;
        assert (!accessFlags.updatesFrame());
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode tagAlias = tool.getAlias(this.frame.getTagArray(this.type));
        ValueNode dataAlias = tool.getAlias(TruffleCompilerRuntime.getRuntime().getJavaKindForFrameSlotKind(this.accessTag) == JavaKind.Object ? this.frame.getObjectArray(this.type) : this.frame.getPrimitiveArray(this.type));
        if (this.type == VirtualFrameAccessType.Auxiliary) {
            VirtualObjectNode dataVirtual;
            if (dataAlias instanceof VirtualObjectNode && this.frameSlotIndex < (dataVirtual = (VirtualObjectNode)dataAlias).entryCount()) {
                ValueNode dataEntry = tool.getEntry(dataVirtual, this.frameSlotIndex);
                tool.replaceWith(dataEntry);
                return;
            }
        } else if (tagAlias instanceof VirtualObjectNode && dataAlias instanceof VirtualObjectNode) {
            VirtualObjectNode tagVirtual = (VirtualObjectNode)tagAlias;
            VirtualObjectNode dataVirtual = (VirtualObjectNode)dataAlias;
            if (this.frameSlotIndex < tagVirtual.entryCount() && this.frameSlotIndex < dataVirtual.entryCount()) {
                ValueNode actualTag = tool.getEntry(tagVirtual, this.frameSlotIndex);
                boolean staticAccess = this.accessFlags.isStatic();
                if (!(staticAccess || actualTag.isConstant() && actualTag.asJavaConstant().asInt() == this.accessTag)) {
                    IntegerEqualsNode comparison = new IntegerEqualsNode(actualTag, this.getConstant(this.accessTag));
                    tool.addNode(comparison);
                    tool.addNode(new FixedGuardNode(comparison, DeoptimizationReason.RuntimeConstraint, DeoptimizationAction.InvalidateRecompile));
                }
                ValueNode dataEntry = tool.getEntry(dataVirtual, this.frameSlotIndex);
                if ((dataEntry = this.maybeNarrowForOSRStaticAccess(tool, dataEntry)).getStackKind() == this.getStackKind()) {
                    tool.replaceWith(dataEntry);
                    return;
                }
            }
        }
        this.insertDeoptimization(tool);
    }

    private ValueNode maybeNarrowForOSRStaticAccess(VirtualizerTool tool, ValueNode value) {
        if (!this.accessKind.isPrimitive() || !this.isOSRRawStaticAccess()) {
            return value;
        }
        Stamp valueStamp = value.stamp(NodeView.DEFAULT);
        if (!(valueStamp instanceof PrimitiveStamp)) {
            return value;
        }
        assert (valueStamp.getStackKind() == JavaKind.Long);
        return this.narrowForOSRStaticAccess(tool, value);
    }

    private ValueNode narrowForOSRStaticAccess(VirtualizerTool tool, ValueNode value) {
        int intBits;
        assert (value.getStackKind() == JavaKind.Long && this.accessKind.isPrimitive());
        if (this.accessKind == JavaKind.Boolean) {
            IntegerEqualsNode logicNode = new IntegerEqualsNode(value, ConstantNode.forLong(0L, this.graph()));
            tool.addNode(logicNode);
            ConditionalNode conditional = new ConditionalNode(logicNode, ConstantNode.forInt(0, this.graph()), ConstantNode.forInt(1, this.graph()));
            tool.addNode(conditional);
            return conditional;
        }
        int targetBits = this.accessKind.getBitCount();
        ValueNode tmpValue = value;
        int longBits = JavaKind.Long.getBitCount();
        if (targetBits < longBits) {
            tmpValue = new NarrowNode(tmpValue, targetBits);
            tool.addNode(tmpValue);
        }
        if (targetBits < (intBits = JavaKind.Int.getBitCount())) {
            assert (this.accessKind == JavaKind.Byte);
            tmpValue = new SignExtendNode(tmpValue, JavaKind.Int.getBitCount());
            tool.addNode(tmpValue);
        }
        if (this.accessKind.isNumericFloat()) {
            tmpValue = new ReinterpretNode(this.accessKind, tmpValue);
            tool.addNode(tmpValue);
        }
        return tmpValue;
    }

    private boolean isOSRRawStaticAccess() {
        return this.accessFlags.isStatic() && this.frame.isBytecodeOSRTransferTarget();
    }
}

