/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.nodes.frame;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessFlags;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessType;
import org.graalvm.compiler.truffle.compiler.nodes.frame.VirtualFrameAccessorNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VirtualFrameIsNode
extends VirtualFrameAccessorNode
implements Virtualizable {
    public static final NodeClass<VirtualFrameIsNode> TYPE = NodeClass.create(VirtualFrameIsNode.class);

    public VirtualFrameIsNode(InvocationPlugin.Receiver frame, int frameSlotIndex, int accessTag, VirtualFrameAccessType type) {
        super(TYPE, StampFactory.forKind(JavaKind.Boolean), frame, frameSlotIndex, accessTag, type, VirtualFrameAccessFlags.BENIGN);
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        VirtualObjectNode tagVirtual;
        ValueNode tagAlias = tool.getAlias(this.frame.getTagArray(this.type));
        if (tagAlias instanceof VirtualObjectNode && this.frameSlotIndex < (tagVirtual = (VirtualObjectNode)tagAlias).entryCount()) {
            ValueNode actualTag = tool.getEntry(tagVirtual, this.frameSlotIndex);
            if (actualTag.isConstant()) {
                tool.replaceWith(this.getConstant(actualTag.asJavaConstant().asInt() == this.accessTag ? 1 : 0));
            } else {
                IntegerEqualsNode comparison = new IntegerEqualsNode(actualTag, this.getConstant(this.accessTag));
                tool.addNode(comparison);
                ConditionalNode result = new ConditionalNode(comparison, this.getConstant(1), this.getConstant(0));
                tool.addNode(result);
                tool.replaceWith(result);
            }
            return;
        }
        this.insertDeoptimization(tool);
    }
}

