/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;

final class TruffleSplittingStrategy {
    private static final Set<OptimizedCallTarget> waste = Collections.synchronizedSet(new HashSet());
    private static final int RECURSIVE_SPLIT_DEPTH = 3;

    TruffleSplittingStrategy() {
    }

    @HostCompilerDirectives.InliningCutoff
    static void beforeCall(OptimizedDirectCallNode call, OptimizedCallTarget currentTarget) {
        EngineData engineData = currentTarget.engine;
        if (engineData.traceSplittingSummary) {
            TruffleSplittingStrategy.traceSplittingPreShouldSplit(engineData, currentTarget);
        }
        if (TruffleSplittingStrategy.shouldSplit(engineData, call)) {
            TruffleSplittingStrategy.doSplit(engineData, call);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceSplittingPreShouldSplit(EngineData engineData, OptimizedCallTarget currentTarget) {
        if (currentTarget.getCallCount() == 0) {
            SplitStatisticsData splitStatisticsData = engineData.splittingStatistics;
            synchronized (splitStatisticsData) {
                engineData.splittingStatistics.totalExecutedNodeCount += currentTarget.getUninitializedNodeCount();
            }
        }
    }

    private static void doSplit(EngineData engineData, OptimizedDirectCallNode call) {
        engineData.splitCount += call.getCallTarget().getUninitializedNodeCount();
        if (engineData.traceSplittingSummary) {
            TruffleSplittingStrategy.traceSplittingPreSplit(engineData, call);
        }
        call.split();
        if (engineData.traceSplittingSummary) {
            TruffleSplittingStrategy.traceSplittingPostSplit(engineData, call);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceSplittingPreSplit(EngineData engineData, OptimizedDirectCallNode call) {
        SplitStatisticsData splitStatisticsData = engineData.splittingStatistics;
        synchronized (splitStatisticsData) {
            TruffleSplittingStrategy.calculateSplitWasteImpl(call.getCurrentCallTarget());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceSplittingPostSplit(EngineData engineData, OptimizedDirectCallNode call) {
        SplitStatisticsData splitStatisticsData = engineData.splittingStatistics;
        synchronized (splitStatisticsData) {
            engineData.splittingStatistics.splitNodeCount += call.getCurrentCallTarget().getUninitializedNodeCount();
            ++engineData.splittingStatistics.splitCount;
            engineData.splittingStatistics.splitTargets.put(call.getCallTarget(), engineData.splittingStatistics.splitTargets.getOrDefault(call.getCallTarget(), 0) + 1);
        }
    }

    private static boolean shouldSplit(EngineData engine, OptimizedDirectCallNode call) {
        OptimizedCallTarget callTarget = call.getCurrentCallTarget();
        if (!callTarget.isNeedsSplit()) {
            return false;
        }
        if (!TruffleSplittingStrategy.canSplit(engine, call)) {
            TruffleSplittingStrategy.maybeTraceFail(engine, call, TruffleSplittingStrategy::splitNotPossibleMessageFactory);
            return false;
        }
        if (TruffleSplittingStrategy.isRecursiveSplit(call, 3)) {
            TruffleSplittingStrategy.maybeTraceFail(engine, call, TruffleSplittingStrategy::recursiveSplitMessageFactory);
            return false;
        }
        if (engine.splitCount + call.getCallTarget().getUninitializedNodeCount() >= engine.splitLimit) {
            TruffleSplittingStrategy.maybeTraceFail(engine, call, TruffleSplittingStrategy::notEnoughBudgetMessageFactory);
            return false;
        }
        if (callTarget.getUninitializedNodeCount() > engine.splittingMaxCalleeSize) {
            TruffleSplittingStrategy.maybeTraceFail(engine, call, TruffleSplittingStrategy::targetTooBigMessageFactory);
            return false;
        }
        return true;
    }

    private static String targetTooBigMessageFactory(OptimizedDirectCallNode call, EngineData engine) {
        return "Target too big: " + call.getCallTarget().getUninitializedNodeCount() + " > " + engine.splittingMaxCalleeSize;
    }

    private static String notEnoughBudgetMessageFactory(OptimizedDirectCallNode call, EngineData engine) {
        return "Not enough budget. " + (engine.splitCount + call.getCallTarget().getUninitializedNodeCount()) + " > " + engine.splitLimit;
    }

    private static String splitNotPossibleMessageFactory(OptimizedDirectCallNode node, EngineData data) {
        return "Split not possible.";
    }

    private static String recursiveSplitMessageFactory(OptimizedDirectCallNode node, EngineData data) {
        return "Recursive split.";
    }

    private static void maybeTraceFail(EngineData engine, OptimizedDirectCallNode call, BiFunction<OptimizedDirectCallNode, EngineData, String> messageFactory) {
        if (engine.traceSplits) {
            GraalTruffleRuntime.getRuntime().getListener().onCompilationSplitFailed(call, messageFactory.apply(call, engine));
        }
    }

    static void forceSplitting(OptimizedDirectCallNode call) {
        EngineData engineData = call.getCallTarget().engine;
        if (engineData.splittingAllowForcedSplits) {
            if (!TruffleSplittingStrategy.canSplit(engineData, call) || TruffleSplittingStrategy.isRecursiveSplit(call, 3)) {
                return;
            }
            engineData.splitCount += call.getCurrentCallTarget().getUninitializedNodeCount();
            TruffleSplittingStrategy.doSplit(engineData, call);
            if (engineData.traceSplittingSummary) {
                TruffleSplittingStrategy.traceSplittingForcedSplit(engineData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceSplittingForcedSplit(EngineData engineData) {
        SplitStatisticsData splitStatisticsData = engineData.splittingStatistics;
        synchronized (splitStatisticsData) {
            ++engineData.splittingStatistics.forcedSplitCount;
        }
    }

    private static boolean canSplit(EngineData engine, OptimizedDirectCallNode call) {
        if (call.isCallTargetCloned()) {
            return false;
        }
        if (!engine.splitting) {
            return false;
        }
        return call.isCallTargetCloningAllowed();
    }

    private static boolean isRecursiveSplit(OptimizedDirectCallNode call, int allowedDepth) {
        OptimizedCallTarget splitCandidateTarget = call.getCallTarget();
        RootNode rootNode = call.getRootNode();
        if (rootNode == null) {
            return false;
        }
        OptimizedCallTarget callRootTarget = (OptimizedCallTarget)rootNode.getCallTarget();
        if (callRootTarget == null) {
            return false;
        }
        OptimizedCallTarget callSourceTarget = callRootTarget.getSourceCallTarget();
        int depth = 0;
        while (callSourceTarget != null) {
            RootNode splitCallSiteRootNode;
            if (callSourceTarget == splitCandidateTarget && ++depth == allowedDepth) {
                return true;
            }
            OptimizedDirectCallNode splitCallSite = callRootTarget.getCallSiteForSplit();
            if (splitCallSite == null || (splitCallSiteRootNode = splitCallSite.getRootNode()) == null || (callRootTarget = (OptimizedCallTarget)splitCallSiteRootNode.getCallTarget()) == null) break;
            callSourceTarget = callRootTarget.getSourceCallTarget();
        }
        return false;
    }

    static void newTargetCreated(RootCallTarget target) {
        OptimizedCallTarget callTarget = (OptimizedCallTarget)target;
        if (callTarget.isSplit()) {
            return;
        }
        if (callTarget.isOSR()) {
            return;
        }
        EngineData engineData = callTarget.engine;
        if (engineData.splitting) {
            engineData.splitLimit = (int)((double)engineData.splitLimit + engineData.splittingGrowthLimit * (double)callTarget.getUninitializedNodeCount());
        }
        if (engineData.traceSplittingSummary) {
            TruffleSplittingStrategy.traceSplittingNewCallTarget(callTarget, engineData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceSplittingNewCallTarget(OptimizedCallTarget callTarget, EngineData engineData) {
        SplitStatisticsData splitStatisticsData = engineData.splittingStatistics;
        synchronized (splitStatisticsData) {
            engineData.splittingStatistics.totalCreatedNodeCount += callTarget.getUninitializedNodeCount();
        }
    }

    private static void calculateSplitWasteImpl(OptimizedCallTarget callTarget) {
        List callNodes = NodeUtil.findAllNodeInstances((Node)callTarget.getRootNode(), OptimizedDirectCallNode.class);
        callNodes.removeIf(callNode -> !callNode.isCallTargetCloned());
        for (OptimizedDirectCallNode node : callNodes) {
            OptimizedCallTarget clonedCallTarget = node.getClonedCallTarget();
            if (!waste.add(clonedCallTarget)) continue;
            EngineData engineData = clonedCallTarget.engine;
            ++engineData.splittingStatistics.wastedTargetCount;
            engineData.splittingStatistics.wastedNodeCount += clonedCallTarget.getUninitializedNodeCount();
            TruffleSplittingStrategy.calculateSplitWasteImpl(clonedCallTarget);
        }
    }

    static void newPolymorphicSpecialize(Node node, EngineData engineData) {
        if (engineData.traceSplittingSummary) {
            TruffleSplittingStrategy.traceSplittingNewPolymorphicSpecialize(node, engineData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceSplittingNewPolymorphicSpecialize(Node node, EngineData engineData) {
        SplitStatisticsData splitStatisticsData = engineData.splittingStatistics;
        synchronized (splitStatisticsData) {
            Map<Class<? extends Node>, Integer> polymorphicNodes = engineData.splittingStatistics.polymorphicNodes;
            Class<?> aClass = node.getClass();
            polymorphicNodes.put(aClass, polymorphicNodes.getOrDefault(aClass, 0) + 1);
        }
    }

    static void installListener(GraalTruffleRuntime runtime) {
        runtime.addListener(new SplitStatisticsReporter());
    }

    static class SplitStatisticsData {
        final Map<Class<? extends Node>, Integer> polymorphicNodes = new HashMap<Class<? extends Node>, Integer>();
        final Map<OptimizedCallTarget, Integer> splitTargets = new HashMap<OptimizedCallTarget, Integer>();
        int splitCount;
        int forcedSplitCount;
        int splitNodeCount;
        int totalExecutedNodeCount;
        int totalCreatedNodeCount;
        int wastedNodeCount;
        int wastedTargetCount;

        SplitStatisticsData() {
        }
    }

    private static final class SplitStatisticsReporter
    implements GraalTruffleRuntimeListener {
        private static final String D_FORMAT = "%n%-82s: %10d";
        private static final String D_LONG_FORMAT = "%n%-120s: %10d";
        private static final String P_FORMAT = "%n%-82s: %9.2f%%";
        private static final String DELIMITER_FORMAT = "%n--- %s";

        SplitStatisticsReporter() {
        }

        @Override
        public void onEngineClosed(EngineData engineData) {
            if (engineData.traceSplittingSummary) {
                SplitStatisticsData stat = engineData.splittingStatistics;
                StringWriter messageBuilder = new StringWriter();
                try (PrintWriter out = new PrintWriter(messageBuilder);){
                    out.print("Splitting Statistics");
                    out.printf(D_FORMAT, "Split count (sum of uninitializedNodeCount for all split targets)", engineData.splitCount);
                    out.printf(D_FORMAT, "Split limit (limit for the number of nodes to create through splitting)", engineData.splitLimit);
                    out.printf(D_FORMAT, "Splits (number of targets created through splitting)", stat.splitCount);
                    out.printf(D_FORMAT, "Forced splits (number of targets created through DirectCallNode#cloneCallTarget)", stat.forcedSplitCount);
                    out.printf(D_FORMAT, "Nodes created through splitting (sum of uninitializedNodeCount for split targets)", stat.splitNodeCount);
                    out.printf(D_FORMAT, "Nodes created without splitting (sum of uninitializedNodeCount for source targets)", stat.totalCreatedNodeCount);
                    out.printf(P_FORMAT, "Increase in nodes", (double)stat.splitNodeCount * 100.0 / (double)stat.totalCreatedNodeCount);
                    out.printf(D_FORMAT, "Split nodes wasted (callee split nodes wasted due to splitting the caller later)", stat.wastedNodeCount);
                    out.printf(P_FORMAT, "Percent of split nodes wasted", (double)stat.wastedNodeCount * 100.0 / (double)stat.splitNodeCount);
                    out.printf(D_FORMAT, "Targets wasted due to splitting", stat.wastedTargetCount);
                    out.printf(D_FORMAT, "Total nodes executed", stat.totalExecutedNodeCount);
                    out.printf(DELIMITER_FORMAT, "SPLIT TARGETS");
                    for (Map.Entry<OptimizedCallTarget, Integer> entry : SplitStatisticsReporter.sortByIntegerValue(stat.splitTargets).entrySet()) {
                        out.printf(D_FORMAT, entry.getKey(), entry.getValue());
                    }
                    out.printf(DELIMITER_FORMAT, "NODES");
                    for (Map.Entry<Object, Integer> entry : SplitStatisticsReporter.sortByIntegerValue(stat.polymorphicNodes).entrySet()) {
                        out.printf(D_LONG_FORMAT, entry.getKey(), entry.getValue());
                    }
                }
                TruffleLogger log = engineData.getEngineLogger();
                log.log(Level.INFO, messageBuilder.toString());
            }
        }

        private static <K, T> Map<K, Integer> sortByIntegerValue(Map<K, Integer> map) {
            ArrayList<Map.Entry<K, Integer>> list = new ArrayList<Map.Entry<K, Integer>>(map.entrySet());
            list.sort((x, y) -> ((Integer)y.getValue()).compareTo((Integer)x.getValue()));
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry entry : list) {
                result.put(entry.getKey(), (Integer)entry.getValue());
            }
            return result;
        }
    }
}

