/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.IntUnaryOperator;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.RetryableBailoutException;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.ValueProxyNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.cfg.HIRBlock;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.NodeWithState;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.EnsureVirtualizedNode;
import org.graalvm.compiler.nodes.virtual.EscapeObjectState;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectState;
import org.graalvm.compiler.virtual.phases.ea.EffectsBlockState;
import org.graalvm.compiler.virtual.phases.ea.EffectsClosure;
import org.graalvm.compiler.virtual.phases.ea.GraphEffectList;
import org.graalvm.compiler.virtual.phases.ea.ObjectState;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapeBlockState;
import org.graalvm.compiler.virtual.phases.ea.VirtualUtil;
import org.graalvm.compiler.virtual.phases.ea.VirtualizerToolImpl;

public abstract class PartialEscapeClosure<BlockT extends PartialEscapeBlockState<BlockT>>
extends EffectsClosure<BlockT> {
    public static final CounterKey COUNTER_MATERIALIZATIONS = DebugContext.counter("Materializations");
    public static final CounterKey COUNTER_MATERIALIZATIONS_PHI = DebugContext.counter("MaterializationsPhi");
    public static final CounterKey COUNTER_MATERIALIZATIONS_MERGE = DebugContext.counter("MaterializationsMerge");
    public static final CounterKey COUNTER_MATERIALIZATIONS_UNHANDLED = DebugContext.counter("MaterializationsUnhandled");
    public static final CounterKey COUNTER_MATERIALIZATIONS_LOOP_EXIT = DebugContext.counter("MaterializationsLoopExit");
    public static final CounterKey COUNTER_ALLOCATION_REMOVED = DebugContext.counter("AllocationsRemoved");
    public static final CounterKey COUNTER_MEMORYCHECKPOINT = DebugContext.counter("MemoryCheckpoint");
    private final NodeBitMap hasVirtualInputs;
    protected final VirtualizerToolImpl tool;
    public final ArrayList<VirtualObjectNode> virtualObjects = new ArrayList();

    @Override
    public boolean needsApplyEffects() {
        if (this.hasChanged()) {
            return true;
        }
        for (HIRBlock block : this.cfg.getBlocks()) {
            GraphEffectList effects = (GraphEffectList)this.blockEffects.get(block);
            if (effects == null || effects.getVirtualizationDelta() == 0 && effects.getAllocationDelta() == 0) continue;
            return true;
        }
        return false;
    }

    public PartialEscapeClosure(StructuredGraph.ScheduleResult schedule, CoreProviders providers) {
        super(schedule, schedule.getCFG());
        StructuredGraph graph = schedule.getCFG().graph;
        this.hasVirtualInputs = graph.createNodeBitMap();
        this.tool = new VirtualizerToolImpl(providers, this, graph.getAssumptions(), graph.getOptions(), this.debug);
    }

    @Override
    protected boolean processNode(Node node, BlockT state, GraphEffectList effects, FixedWithNextNode lastFixedNode) {
        if (node instanceof CallTargetNode || node instanceof FrameState || node instanceof ConstantNode) {
            return false;
        }
        if (node instanceof Invoke) {
            this.processNodeInternal(((Invoke)((Object)node)).callTarget(), state, effects, lastFixedNode);
        }
        return this.processNodeInternal(node, state, effects, lastFixedNode);
    }

    @Override
    protected void processStateBeforeLoopOnOverflow(BlockT initialState, FixedNode materializeBefore, GraphEffectList effects) {
        for (int i = 0; i < ((PartialEscapeBlockState)initialState).getStateCount(); ++i) {
            if (!((PartialEscapeBlockState)initialState).hasObjectState(i) || !((PartialEscapeBlockState)initialState).getObjectState(i).isVirtual()) continue;
            VirtualObjectNode virtual = this.virtualObjects.get(i);
            ((PartialEscapeBlockState)initialState).materializeBefore(materializeBefore, virtual, effects);
        }
    }

    private boolean processNodeInternal(Node node, BlockT state, GraphEffectList effects, FixedWithNextNode lastFixedNode) {
        FixedNode nextFixedNode = lastFixedNode == null ? null : lastFixedNode.next();
        VirtualUtil.trace(node.getOptions(), this.debug, "%s", node);
        if (this.requiresProcessing(node)) {
            if (!this.processVirtualizable((ValueNode)node, nextFixedNode, state, effects)) {
                return false;
            }
            if (this.tool.isDeleted()) {
                if (node instanceof AbstractNewObjectNode || node instanceof CommitAllocationNode) {
                    effects.addAllocationDelta(1);
                }
                VirtualUtil.trace(node.getOptions(), this.debug, "deleted virtualizable allocation %s", node);
                return true;
            }
        }
        if (this.hasVirtualInputs.isMarked(node) && node instanceof ValueNode) {
            if (node instanceof Virtualizable) {
                if (!this.processVirtualizable((ValueNode)node, nextFixedNode, state, effects)) {
                    return false;
                }
                if (this.tool.isDeleted()) {
                    VirtualUtil.trace(node.getOptions(), this.debug, "deleted virtualizable node %s", node);
                    return true;
                }
            }
            this.processNodeInputs((ValueNode)node, nextFixedNode, state, effects);
        }
        return this.hasScalarReplacedInputs(node) && node instanceof ValueNode && this.processNodeWithScalarReplacedInputs((ValueNode)node, nextFixedNode, state, effects);
    }

    protected boolean requiresProcessing(Node node) {
        return node instanceof VirtualizableAllocation;
    }

    private boolean processVirtualizable(ValueNode node, FixedNode insertBefore, BlockT state, GraphEffectList effects) {
        this.tool.reset((PartialEscapeBlockState<?>)state, node, insertBefore, effects);
        switch (this.currentMode) {
            case REGULAR_VIRTUALIZATION: {
                break;
            }
            case STOP_NEW_VIRTUALIZATIONS_LOOP_NEST: {
                if (node instanceof VirtualizableAllocation) {
                    boolean mayEnsureVirtualized = false;
                    for (Node usage : node.usages()) {
                        if (!(usage instanceof EnsureVirtualizedNode)) continue;
                        mayEnsureVirtualized = true;
                        break;
                    }
                    if (!mayEnsureVirtualized) {
                        return false;
                    }
                }
                if (this.hasVirtualInputs.isMarked(node)) break;
                return false;
            }
            case MATERIALIZE_ALL: {
                boolean virtualizationResult = this.virtualize(node, this.tool);
                for (VirtualObjectNode virtualObject : this.virtualObjects) {
                    int id;
                    ValueNode alias = this.getAlias(virtualObject);
                    if (!(alias instanceof VirtualObjectNode) || !((PartialEscapeBlockState)state).hasObjectState(id = ((VirtualObjectNode)alias).getObjectId())) continue;
                    FixedNode materializeBefore = insertBefore;
                    if (insertBefore == node && this.tool.isDeleted()) {
                        materializeBefore = ((FixedWithNextNode)insertBefore).next();
                    }
                    this.ensureMaterialized((PartialEscapeBlockState<?>)state, id, materializeBefore, effects, COUNTER_MATERIALIZATIONS);
                }
                return virtualizationResult;
            }
            default: {
                throw GraalError.shouldNotReachHere("Unknown effects closure mode " + this.currentMode);
            }
        }
        return this.virtualize(node, this.tool);
    }

    protected boolean virtualize(ValueNode node, VirtualizerTool vt) {
        ((Virtualizable)((Object)node)).virtualize(vt);
        return true;
    }

    private boolean processNodeWithScalarReplacedInputs(ValueNode node, FixedNode insertBefore, BlockT state, GraphEffectList effects) {
        ValueNode canonicalizedValue = node;
        if (node instanceof Canonicalizable.Unary) {
            ValueNode valueAlias;
            canonicalizable = (Canonicalizable.Unary)((Object)node);
            ObjectState valueObj = this.getObjectState((PartialEscapeBlockState<?>)state, (ValueNode)canonicalizable.getValue());
            ValueNode valueNode = valueAlias = valueObj != null ? valueObj.getMaterializedValue() : this.getScalarAlias((ValueNode)canonicalizable.getValue());
            if (valueAlias != canonicalizable.getValue()) {
                canonicalizedValue = (ValueNode)canonicalizable.canonical(this.tool, valueAlias);
            }
        } else if (node instanceof Canonicalizable.Binary) {
            ValueNode yAlias;
            canonicalizable = (Canonicalizable.Binary)((Object)node);
            ObjectState xObj = this.getObjectState((PartialEscapeBlockState<?>)state, (ValueNode)canonicalizable.getX());
            ValueNode xAlias = xObj != null ? xObj.getMaterializedValue() : this.getScalarAlias((ValueNode)canonicalizable.getX());
            ObjectState yObj = this.getObjectState((PartialEscapeBlockState<?>)state, (ValueNode)canonicalizable.getY());
            ValueNode valueNode = yAlias = yObj != null ? yObj.getMaterializedValue() : this.getScalarAlias((ValueNode)canonicalizable.getY());
            if (xAlias != canonicalizable.getX() || yAlias != canonicalizable.getY()) {
                canonicalizedValue = (ValueNode)canonicalizable.canonical(this.tool, xAlias, yAlias);
            }
        } else {
            return false;
        }
        if (canonicalizedValue != node && canonicalizedValue != null) {
            if (canonicalizedValue.isAlive()) {
                ValueNode alias = this.getAliasAndResolve((PartialEscapeBlockState<?>)state, canonicalizedValue);
                if (alias instanceof VirtualObjectNode) {
                    this.addVirtualAlias((VirtualObjectNode)alias, node);
                    effects.deleteNode(node);
                } else {
                    effects.replaceAtUsages(node, alias, insertBefore);
                    this.addScalarAlias(node, alias);
                }
            } else {
                if (!this.prepareCanonicalNode(canonicalizedValue, state, effects)) {
                    VirtualUtil.trace(node.getOptions(), this.debug, "replacement via canonicalization too complex: %s -> %s", node, canonicalizedValue);
                    return false;
                }
                if (canonicalizedValue instanceof ControlSinkNode) {
                    effects.replaceWithSink((FixedWithNextNode)node, (ControlSinkNode)canonicalizedValue);
                    ((EffectsBlockState)state).markAsDead();
                } else {
                    effects.replaceAtUsages(node, canonicalizedValue, insertBefore);
                    this.addScalarAlias(node, canonicalizedValue);
                }
            }
            VirtualUtil.trace(node.getOptions(), this.debug, "replaced via canonicalization: %s -> %s", node, canonicalizedValue);
            return true;
        }
        return false;
    }

    private boolean prepareCanonicalNode(ValueNode node, BlockT state, GraphEffectList effects) {
        assert (!node.isAlive());
        for (Position pos : node.inputPositions()) {
            Node input = pos.get(node);
            if (!(input instanceof ValueNode)) continue;
            if (input.isAlive()) {
                if (input instanceof VirtualObjectNode) continue;
                ObjectState obj = this.getObjectState((PartialEscapeBlockState<?>)state, (ValueNode)input);
                if (obj != null) {
                    if (obj.isVirtual()) {
                        return false;
                    }
                    pos.initialize(node, obj.getMaterializedValue());
                    continue;
                }
                pos.initialize(node, this.getScalarAlias((ValueNode)input));
                continue;
            }
            if (this.prepareCanonicalNode((ValueNode)input, state, effects)) continue;
            return false;
        }
        return true;
    }

    protected void processNodeInputs(ValueNode node, FixedNode insertBefore, BlockT state, GraphEffectList effects) {
        VirtualUtil.trace(node.getOptions(), this.debug, "processing nodewithstate: %s", node);
        for (Node input : node.inputs()) {
            int id;
            ValueNode alias;
            if (!(input instanceof ValueNode) || !((alias = this.getAlias((ValueNode)input)) instanceof VirtualObjectNode) || !this.shouldMaterializeNonVirtualizable(state, id = ((VirtualObjectNode)alias).getObjectId(), insertBefore)) continue;
            this.ensureMaterialized((PartialEscapeBlockState<?>)state, id, insertBefore, effects, COUNTER_MATERIALIZATIONS_UNHANDLED);
            effects.replaceFirstInput(node, input, ((PartialEscapeBlockState)state).getObjectState(id).getMaterializedValue());
            VirtualUtil.trace(node.getOptions(), this.debug, "replacing input %s at %s", input, node);
        }
        if (node instanceof NodeWithState) {
            this.processNodeWithState((NodeWithState)((Object)node), state, effects);
        }
    }

    protected boolean shouldMaterializeNonVirtualizable(BlockT state, int id, FixedNode insertBefore) {
        return true;
    }

    protected void processNodeWithState(NodeWithState nodeWithState, BlockT state, GraphEffectList effects) {
        for (FrameState fs : nodeWithState.states()) {
            FrameState frameState = PartialEscapeClosure.getUniqueFramestate(nodeWithState, fs);
            EconomicSet virtual = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
            frameState.applyToNonVirtual(new CollectVirtualObjectsClosure2(this, virtual, effects, state));
            this.collectLockedVirtualObjects(state, (EconomicSet<VirtualObjectNode>)virtual);
            this.collectReferencedVirtualObjects(state, (EconomicSet<VirtualObjectNode>)virtual);
            this.addVirtualMappings(frameState, (EconomicSet<VirtualObjectNode>)virtual, state, effects);
        }
    }

    private static FrameState getUniqueFramestate(NodeWithState nodeWithState, FrameState frameState) {
        if (frameState.hasMoreThanOneUsage()) {
            FrameState copy = (FrameState)frameState.copyWithInputs();
            nodeWithState.asNode().replaceFirstInput(frameState, copy);
            return copy;
        }
        return frameState;
    }

    private void addVirtualMappings(FrameState frameState, EconomicSet<VirtualObjectNode> virtual, BlockT state, GraphEffectList effects) {
        block0: for (VirtualObjectNode obj : virtual) {
            for (int i = 0; i < frameState.virtualObjectMappingCount(); ++i) {
                EscapeObjectState mapping = frameState.virtualObjectMappingAt(i);
                if (mapping.object() != obj || !(mapping instanceof VirtualObjectState)) continue;
                VirtualObjectState virtualState = (VirtualObjectState)mapping;
                NodeInputList<ValueNode> values = virtualState.values();
                for (int v = 0; v < values.size(); ++v) {
                    ValueNode value = (ValueNode)values.get(v);
                    ValueNode alias = this.getAlias(value);
                    if (alias == value) continue;
                    effects.updateVirtualMapping(virtualState, v, alias);
                }
                continue block0;
            }
            effects.addVirtualMapping(frameState, ((PartialEscapeBlockState)state).getObjectState(obj).createEscapeObjectState(this.debug, this.tool.getMetaAccessExtensionProvider(), obj));
        }
    }

    private void collectReferencedVirtualObjects(BlockT state, EconomicSet<VirtualObjectNode> virtual) {
        for (VirtualObjectNode object : virtual) {
            ObjectState objState;
            int id = object.getObjectId();
            if (id == -1 || (objState = ((PartialEscapeBlockState)state).getObjectStateOptional(id)) == null || !objState.isVirtual()) continue;
            for (ValueNode entry : objState.getEntries()) {
                VirtualObjectNode entryVirtual;
                if (!(entry instanceof VirtualObjectNode) || virtual.contains((Object)(entryVirtual = (VirtualObjectNode)entry))) continue;
                virtual.add((Object)entryVirtual);
            }
        }
    }

    private void collectLockedVirtualObjects(BlockT state, EconomicSet<VirtualObjectNode> virtual) {
        for (int i = 0; i < ((PartialEscapeBlockState)state).getStateCount(); ++i) {
            ObjectState objState = ((PartialEscapeBlockState)state).getObjectStateOptional(i);
            if (objState == null || !objState.isVirtual() || !objState.hasLocks()) continue;
            virtual.add((Object)this.virtualObjects.get(i));
        }
    }

    protected boolean ensureMaterialized(PartialEscapeBlockState<?> state, int object, FixedNode materializeBefore, GraphEffectList effects, CounterKey counter) {
        if (state.getObjectState(object).isVirtual()) {
            if (this.currentMode == EffectsClosure.EffectsClosureMode.STOP_NEW_VIRTUALIZATIONS_LOOP_NEST) {
                if (state.getObjectState(object).getEnsureVirtualized()) {
                    throw new RetryableBailoutException("Materializing an ensureVirtualized marked allocation inside a very deep loop nest, this may lead to exponential runtime of the partial escape analysis.");
                }
                throw new EffectsClosure.EffecsClosureOverflowException();
            }
            counter.increment(this.debug);
            VirtualObjectNode virtual = this.virtualObjects.get(object);
            state.materializeBefore(materializeBefore, virtual, effects);
            assert (!PartialEscapeClosure.updateStatesForMaterialized(state, virtual, state.getObjectState(object).getMaterializedValue())) : "method must already have been called before";
            return true;
        }
        return false;
    }

    public static boolean updateStatesForMaterialized(PartialEscapeBlockState<?> state, VirtualObjectNode virtual, ValueNode materializedValue) {
        boolean change = false;
        for (int i = 0; i < state.getStateCount(); ++i) {
            ObjectState objState = state.getObjectStateOptional(i);
            if (objState == null || !objState.isVirtual()) continue;
            ValueNode[] entries = objState.getEntries();
            for (int i2 = 0; i2 < entries.length; ++i2) {
                if (entries[i2] != virtual) continue;
                state.setEntry(i, i2, materializedValue);
                change = true;
            }
        }
        return change;
    }

    @Override
    protected BlockT stripKilledLoopLocations(Loop<HIRBlock> loop, BlockT originalInitialState) {
        PartialEscapeBlockState initialState = (PartialEscapeBlockState)super.stripKilledLoopLocations(loop, originalInitialState);
        if (loop.getDepth() > GraalOptions.EscapeAnalysisLoopCutoff.getValue(this.cfg.graph.getOptions())) {
            boolean change;
            ObjectState state;
            int i;
            LoopBeginNode loopBegin = (LoopBeginNode)loop.getHeader().getBeginNode();
            EndNode end = loopBegin.forwardEnd();
            HIRBlock loopPredecessor = loop.getHeader().getFirstPredecessor();
            assert (loopPredecessor.getEndNode() == end);
            int length = initialState.getStateCount();
            BitSet ensureVirtualized = new BitSet(length);
            for (i = 0; i < length; ++i) {
                state = initialState.getObjectStateOptional(i);
                if (state == null || !state.isVirtual() || !state.getEnsureVirtualized()) continue;
                ensureVirtualized.set(i);
            }
            do {
                change = false;
                block2: for (i = 0; i < length; ++i) {
                    if (ensureVirtualized.get(i) || (state = initialState.getObjectStateOptional(i)) == null || !state.isVirtual()) continue;
                    for (ValueNode entry : state.getEntries()) {
                        if (!(entry instanceof VirtualObjectNode) || !ensureVirtualized.get(((VirtualObjectNode)entry).getObjectId())) continue;
                        change = true;
                        ensureVirtualized.set(i);
                        continue block2;
                    }
                }
            } while (change);
            if (this.currentMode == EffectsClosure.EffectsClosureMode.REGULAR_VIRTUALIZATION) {
                this.currentMode = EffectsClosure.EffectsClosureMode.STOP_NEW_VIRTUALIZATIONS_LOOP_NEST;
            }
        }
        return (BlockT)initialState;
    }

    @Override
    protected void processInitialLoopState(Loop<HIRBlock> loop, BlockT initialState) {
        for (PhiNode phi : ((LoopBeginNode)loop.getHeader().getBeginNode()).phis()) {
            if (phi.valueAt(0) == null) continue;
            ValueNode alias = this.getAliasAndResolve((PartialEscapeBlockState<?>)initialState, phi.valueAt(0));
            if (alias instanceof VirtualObjectNode) {
                VirtualObjectNode virtual = (VirtualObjectNode)alias;
                this.addVirtualAlias(virtual, phi);
                continue;
            }
            this.aliases.set(phi, null);
        }
    }

    @Override
    protected void processLoopExit(LoopExitNode exitNode, BlockT initialState, BlockT exitState, GraphEffectList effects) {
        if (exitNode.graph().isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
            boolean forceMaterialization = exitNode.stateAfter().isExceptionHandlingBCI();
            EconomicMap proxies = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            for (ProxyNode proxy : exitNode.proxies()) {
                ValueNode alias = this.getAlias(proxy.value());
                if (!(alias instanceof VirtualObjectNode)) continue;
                VirtualObjectNode virtual = (VirtualObjectNode)alias;
                if (forceMaterialization) {
                    this.ensureMaterialized((PartialEscapeBlockState<?>)exitState, virtual.getObjectId(), exitNode, effects, COUNTER_MATERIALIZATIONS_LOOP_EXIT);
                }
                proxies.put((Object)virtual.getObjectId(), (Object)proxy);
            }
            for (int i = 0; i < ((PartialEscapeBlockState)exitState).getStateCount(); ++i) {
                ObjectState exitObjState = ((PartialEscapeBlockState)exitState).getObjectStateOptional(i);
                if (exitObjState == null) continue;
                ObjectState initialObjState = ((PartialEscapeBlockState)initialState).getObjectStateOptional(i);
                if (exitObjState.isVirtual()) {
                    PartialEscapeClosure.processVirtualAtLoopExit(exitNode, effects, i, exitObjState, initialObjState, exitState);
                    continue;
                }
                PartialEscapeClosure.processMaterializedAtLoopExit(exitNode, effects, (EconomicMap<Integer, ProxyNode>)proxies, i, exitObjState, initialObjState, exitState);
            }
        }
    }

    private static void processMaterializedAtLoopExit(LoopExitNode exitNode, GraphEffectList effects, EconomicMap<Integer, ProxyNode> proxies, int object, ObjectState exitObjState, ObjectState initialObjState, PartialEscapeBlockState<?> exitState) {
        if (initialObjState == null || initialObjState.isVirtual()) {
            ProxyNode proxy = (ProxyNode)proxies.get((Object)object);
            if (proxy == null) {
                proxy = new ValueProxyNode(exitObjState.getMaterializedValue(), exitNode);
                effects.addFloatingNode(proxy, "proxy");
            } else {
                effects.replaceFirstInput(proxy, proxy.value(), exitObjState.getMaterializedValue());
            }
            exitState.updateMaterializedValue(object, proxy);
        } else if (initialObjState.getMaterializedValue() != exitObjState.getMaterializedValue()) {
            exitNode.getDebug().log("materialized value changes within loop: %s vs. %s at %s", initialObjState.getMaterializedValue(), (Object)exitObjState.getMaterializedValue(), (Object)exitNode);
        }
    }

    private static void processVirtualAtLoopExit(LoopExitNode exitNode, GraphEffectList effects, int object, ObjectState exitObjState, ObjectState initialObjState, PartialEscapeBlockState<?> exitState) {
        for (int i = 0; i < exitObjState.getEntries().length; ++i) {
            ValueNode value = exitState.getObjectState(object).getEntry(i);
            if (value instanceof VirtualObjectNode || value.isConstant() || !exitNode.loopBegin().isPhiAtMerge(value) && initialObjState != null && initialObjState.isVirtual() && initialObjState.getEntry(i) == value) continue;
            ValueProxyNode proxy = new ValueProxyNode(value, exitNode);
            exitState.setEntry(object, i, proxy);
            effects.addFloatingNode(proxy, "virtualProxy");
        }
    }

    @Override
    protected MergeProcessor createMergeProcessor(HIRBlock merge) {
        return new MergeProcessor(merge);
    }

    public ObjectState getObjectState(PartialEscapeBlockState<?> state, ValueNode value) {
        if (value == null) {
            return null;
        }
        if (value.isAlive() && !this.aliases.isNew(value)) {
            ValueNode object = (ValueNode)this.aliases.get(value);
            return object instanceof VirtualObjectNode ? state.getObjectStateOptional((VirtualObjectNode)object) : null;
        }
        if (value instanceof VirtualObjectNode) {
            return state.getObjectStateOptional((VirtualObjectNode)value);
        }
        return null;
    }

    public ValueNode getAlias(ValueNode value) {
        ValueNode result;
        if (value != null && !(value instanceof VirtualObjectNode) && value.isAlive() && !this.aliases.isNew(value) && (result = (ValueNode)this.aliases.get(value)) != null) {
            return result;
        }
        return value;
    }

    public ValueNode getAliasAndResolve(PartialEscapeBlockState<?> state, ValueNode value) {
        int id;
        ValueNode result = this.getAlias(value);
        if (result instanceof VirtualObjectNode && (id = ((VirtualObjectNode)result).getObjectId()) != -1 && !state.getObjectState(id).isVirtual()) {
            result = state.getObjectState(id).getMaterializedValue();
        }
        return result;
    }

    void addVirtualAlias(VirtualObjectNode virtual, ValueNode node) {
        if (node.isAlive()) {
            this.aliases.set(node, virtual);
            for (Node usage : node.usages()) {
                this.markVirtualUsages(usage);
            }
        }
    }

    private void markVirtualUsages(Node node) {
        if (!this.hasVirtualInputs.isNew(node) && !this.hasVirtualInputs.isMarked(node)) {
            this.hasVirtualInputs.mark(node);
            if (node instanceof VirtualState) {
                for (Node usage : node.usages()) {
                    this.markVirtualUsages(usage);
                }
            }
        }
    }

    private static final class CollectVirtualObjectsClosure2
    extends VirtualState.NodePositionClosure<Node> {
        private final EconomicSet<VirtualObjectNode> virtual;
        private final GraphEffectList effects;
        private final BlockT state;
        final /* synthetic */ PartialEscapeClosure this$0;

        private CollectVirtualObjectsClosure2(EconomicSet<VirtualObjectNode> virtual, GraphEffectList effects, BlockT state) {
            this.this$0 = var1_1;
            this.virtual = virtual;
            this.effects = effects;
            this.state = state;
        }

        @Override
        public void apply(Node from, Position p) {
            ValueNode value = (ValueNode)p.get(from);
            Node usage = from;
            if (value instanceof VirtualObjectNode) {
                VirtualObjectNode object = (VirtualObjectNode)value;
                if (object.getObjectId() != -1 && ((PartialEscapeBlockState)this.state).getObjectStateOptional(object) != null) {
                    this.virtual.add((Object)object);
                }
            } else {
                ValueNode alias = this.this$0.getAlias(value);
                if (alias instanceof VirtualObjectNode) {
                    VirtualObjectNode object = (VirtualObjectNode)alias;
                    this.virtual.add((Object)object);
                    this.effects.replaceFirstInput(usage, value, object);
                }
            }
        }
    }

    protected class MergeProcessor
    extends EffectsClosure.MergeProcessor {
        private EconomicMap<Object, ValuePhiNode> materializedPhis;
        private EconomicMap<ValueNode, ValuePhiNode[]> valuePhis;
        private EconomicMap<ValuePhiNode, VirtualObjectNode> valueObjectVirtuals;
        private final boolean needsCaching;

        public MergeProcessor(HIRBlock mergeBlock) {
            super(mergeBlock);
            this.needsCaching = mergeBlock.isLoopHeader();
        }

        protected <T> PhiNode getPhi(T virtual, Stamp stamp) {
            if (this.needsCaching) {
                return this.getPhiCached(virtual, stamp);
            }
            return this.createValuePhi(stamp);
        }

        private <T> PhiNode getPhiCached(T virtual, Stamp stamp) {
            ValuePhiNode result;
            if (this.materializedPhis == null) {
                this.materializedPhis = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            }
            if ((result = (ValuePhiNode)this.materializedPhis.get(virtual)) == null) {
                result = this.createValuePhi(stamp);
                this.materializedPhis.put(virtual, (Object)result);
            }
            return result;
        }

        private PhiNode[] getValuePhis(ValueNode key, int entryCount) {
            if (this.needsCaching) {
                return this.getValuePhisCached(key, entryCount);
            }
            return new ValuePhiNode[entryCount];
        }

        private PhiNode[] getValuePhisCached(ValueNode key, int entryCount) {
            PhiNode[] result;
            if (this.valuePhis == null) {
                this.valuePhis = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
            }
            if ((result = (ValuePhiNode[])this.valuePhis.get((Object)key)) == null) {
                result = new ValuePhiNode[entryCount];
                this.valuePhis.put((Object)key, (Object)result);
            }
            assert (result.length == entryCount);
            return result;
        }

        private VirtualObjectNode getValueObjectVirtual(ValuePhiNode phi, VirtualObjectNode virtual) {
            if (this.needsCaching) {
                return this.getValueObjectVirtualCached(phi, virtual);
            }
            VirtualObjectNode duplicate = virtual.duplicate();
            duplicate.setNodeSourcePosition(virtual.getNodeSourcePosition());
            return duplicate;
        }

        private VirtualObjectNode getValueObjectVirtualCached(ValuePhiNode phi, VirtualObjectNode virtual) {
            VirtualObjectNode result;
            if (this.valueObjectVirtuals == null) {
                this.valueObjectVirtuals = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            }
            if ((result = (VirtualObjectNode)this.valueObjectVirtuals.get((Object)phi)) == null) {
                result = virtual.duplicate();
                result.setNodeSourcePosition(virtual.getNodeSourcePosition());
                this.valueObjectVirtuals.put((Object)phi, (Object)result);
            }
            return result;
        }

        @Override
        protected void merge(List<BlockT> statesList) {
            boolean materialized;
            int i;
            PartialEscapeBlockState[] states = new PartialEscapeBlockState[statesList.size()];
            for (int i2 = 0; i2 < statesList.size(); ++i2) {
                states[i2] = (PartialEscapeBlockState)statesList.get(i2);
            }
            int[] virtualObjTemp = this.intersectVirtualObjects(states);
            boolean forceMaterialization = false;
            ValueNode forcedMaterializationValue = null;
            FrameState frameState = this.merge.stateAfter();
            if (frameState != null && frameState.isExceptionHandlingBCI()) {
                forceMaterialization = true;
                if (frameState.stackSize() == 1 && this.merge.next() instanceof UnwindNode) {
                    assert (frameState.outerFrameState() == null);
                    UnwindNode unwind = (UnwindNode)this.merge.next();
                    if (unwind.exception() == frameState.stackAt(0)) {
                        boolean nullLocals = true;
                        for (i = 0; i < frameState.localsSize(); ++i) {
                            if (frameState.localAt(i) == null) continue;
                            nullLocals = false;
                            break;
                        }
                        if (nullLocals) {
                            forcedMaterializationValue = unwind.exception();
                        }
                    }
                }
            }
            do {
                materialized = false;
                if (!forceMaterialization && PartialEscapeBlockState.identicalObjectStates(states)) {
                    ((PartialEscapeBlockState)this.newState).adoptAddObjectStates(states[0]);
                } else {
                    int[] nullLocals = virtualObjTemp;
                    i = nullLocals.length;
                    for (int j = 0; j < i; ++j) {
                        int object = nullLocals[j];
                        if (!forceMaterialization && PartialEscapeBlockState.identicalObjectStates(states, object)) {
                            ((PartialEscapeBlockState)this.newState).addObject(object, states[0].getObjectState(object).share());
                            continue;
                        }
                        int virtualCount = 0;
                        ObjectState startObj = states[0].getObjectState(object);
                        boolean locksMatch = true;
                        boolean ensureVirtual = true;
                        ValueNode uniqueMaterializedValue = startObj.isVirtual() ? null : startObj.getMaterializedValue();
                        for (int i3 = 0; i3 < states.length; ++i3) {
                            ObjectState obj = states[i3].getObjectState(object);
                            ensureVirtual &= obj.getEnsureVirtualized();
                            if (forceMaterialization) {
                                ValueNode alias;
                                if (forcedMaterializationValue == null) {
                                    uniqueMaterializedValue = null;
                                    continue;
                                }
                                ValueNode value = forcedMaterializationValue;
                                if (this.merge.isPhiAtMerge(value)) {
                                    value = ((ValuePhiNode)value).valueAt(i3);
                                }
                                if ((alias = PartialEscapeClosure.this.getAlias(value)) instanceof VirtualObjectNode && ((VirtualObjectNode)alias).getObjectId() == object) {
                                    uniqueMaterializedValue = null;
                                    continue;
                                }
                            }
                            if (obj.isVirtual()) {
                                ++virtualCount;
                                uniqueMaterializedValue = null;
                                locksMatch &= obj.locksEqual(startObj);
                                continue;
                            }
                            if (obj.getMaterializedValue() == uniqueMaterializedValue) continue;
                            uniqueMaterializedValue = null;
                        }
                        if (virtualCount == states.length && locksMatch) {
                            materialized |= this.mergeObjectStates(object, null, states);
                            continue;
                        }
                        if (uniqueMaterializedValue != null) {
                            ((PartialEscapeBlockState)this.newState).addObject(object, new ObjectState(uniqueMaterializedValue, null, ensureVirtual));
                            continue;
                        }
                        PhiNode materializedValuePhi = this.getPhi(object, StampFactory.forKind(JavaKind.Object));
                        this.mergeEffects.addFloatingNode(materializedValuePhi, "materializedPhi");
                        for (int i4 = 0; i4 < states.length; ++i4) {
                            ObjectState obj = states[i4].getObjectState(object);
                            if (obj.isVirtual()) {
                                HIRBlock predecessor = this.getPredecessor(i4);
                                if (!ensureVirtual && obj.isVirtual()) {
                                    obj.setEnsureVirtualized(false);
                                }
                                materialized |= PartialEscapeClosure.this.ensureMaterialized(states[i4], object, predecessor.getEndNode(), (GraphEffectList)PartialEscapeClosure.this.blockEffects.get(predecessor), COUNTER_MATERIALIZATIONS_MERGE);
                                obj = states[i4].getObjectState(object);
                            }
                            this.setPhiInput(materializedValuePhi, i4, obj.getMaterializedValue());
                        }
                        ((PartialEscapeBlockState)this.newState).addObject(object, new ObjectState(materializedValuePhi, null, false));
                    }
                    if (virtualObjTemp.length == 0 && forceMaterialization && this.merge.isPhiAtMerge(forcedMaterializationValue)) {
                        PhiNode phi = (PhiNode)forcedMaterializationValue;
                        for (i = 0; i < states.length; ++i) {
                            VirtualObjectNode virtual;
                            ValueNode value = phi.valueAt(i);
                            ValueNode alias = PartialEscapeClosure.this.getAlias(value);
                            if (!(alias instanceof VirtualObjectNode) || !states[i].hasObjectState((virtual = (VirtualObjectNode)alias).getObjectId())) continue;
                            predecessor = this.getPredecessor(i);
                            materialized |= PartialEscapeClosure.this.ensureMaterialized(states[i], virtual.getObjectId(), predecessor.getEndNode(), (GraphEffectList)PartialEscapeClosure.this.blockEffects.get(predecessor), COUNTER_MATERIALIZATIONS_MERGE);
                        }
                    } else if (virtualObjTemp.length == 0 && forceMaterialization) {
                        for (VirtualObjectNode virtualObject : PartialEscapeClosure.this.virtualObjects) {
                            ValueNode alias = PartialEscapeClosure.this.getAlias(virtualObject);
                            if (!(alias instanceof VirtualObjectNode)) continue;
                            VirtualObjectNode virtual = (VirtualObjectNode)alias;
                            for (int i5 = 0; i5 < states.length; ++i5) {
                                if (!states[i5].hasObjectState(virtual.getObjectId())) continue;
                                predecessor = this.getPredecessor(i5);
                                materialized |= PartialEscapeClosure.this.ensureMaterialized(states[i5], virtual.getObjectId(), predecessor.getEndNode(), (GraphEffectList)PartialEscapeClosure.this.blockEffects.get(predecessor), COUNTER_MATERIALIZATIONS_MERGE);
                            }
                        }
                    }
                }
                for (PhiNode phi : this.getPhis()) {
                    PartialEscapeClosure.this.aliases.set(phi, null);
                    if (!PartialEscapeClosure.this.hasVirtualInputs.isMarked(phi) || !(phi instanceof ValuePhiNode)) continue;
                    materialized |= this.processPhi((ValuePhiNode)phi, states);
                }
                if (!materialized) continue;
                ((PartialEscapeBlockState)this.newState).resetObjectStates(PartialEscapeClosure.this.virtualObjects.size());
                this.mergeEffects.clear();
                this.afterMergeEffects.clear();
            } while (materialized);
        }

        private int[] intersectVirtualObjects(PartialEscapeBlockState<?>[] states) {
            int length = states[0].getStateCount();
            for (int i = 1; i < states.length; ++i) {
                length = Math.min(length, states[i].getStateCount());
            }
            int count = 0;
            for (int objectIndex = 0; objectIndex < length; ++objectIndex) {
                if (!this.intersectObjectState(states, objectIndex)) continue;
                ++count;
            }
            int index = 0;
            int[] resultInts = new int[count];
            for (int objectIndex = 0; objectIndex < length; ++objectIndex) {
                if (!this.intersectObjectState(states, objectIndex)) continue;
                resultInts[index++] = objectIndex;
            }
            assert (index == count);
            return resultInts;
        }

        private boolean intersectObjectState(PartialEscapeBlockState<?>[] states, int objectIndex) {
            for (int i = 0; i < states.length; ++i) {
                PartialEscapeBlockState<?> state = states[i];
                if (state.getObjectStateOptional(objectIndex) != null) continue;
                return false;
            }
            return true;
        }

        private boolean mergeObjectStates(int resultObject, int[] sourceObjects, PartialEscapeBlockState<?>[] states) {
            int i;
            int valueIndex;
            boolean compatible = true;
            boolean ensureVirtual = true;
            IntUnaryOperator getObject = index -> sourceObjects == null ? resultObject : sourceObjects[index];
            VirtualObjectNode virtual = PartialEscapeClosure.this.virtualObjects.get(resultObject);
            int entryCount = virtual.entryCount();
            JavaKind[] twoSlotKinds = null;
            int[] virtualByteCount = null;
            JavaKind[] virtualKinds = null;
            block0: for (int i2 = 0; i2 < states.length; ++i2) {
                int object = getObject.applyAsInt(i2);
                ObjectState objectState = states[i2].getObjectState(object);
                ValueNode[] entries = objectState.getEntries();
                ensureVirtual &= objectState.getEnsureVirtualized();
                for (int valueIndex2 = 0; valueIndex2 < entryCount; ++valueIndex2) {
                    JavaKind otherKind = entries[valueIndex2].getStackKind();
                    JavaKind entryKind = virtual.entryKind(PartialEscapeClosure.this.tool.getMetaAccessExtensionProvider(), valueIndex2);
                    if (entryKind == JavaKind.Int && otherKind.needsTwoSlots()) {
                        if (twoSlotKinds == null) {
                            twoSlotKinds = new JavaKind[entryCount];
                        }
                        if (twoSlotKinds[valueIndex2] != null && twoSlotKinds[valueIndex2] != otherKind) {
                            compatible = false;
                            break block0;
                        }
                        twoSlotKinds[valueIndex2] = otherKind;
                        ++valueIndex2;
                        continue;
                    }
                    if (virtual.isVirtualByteArray(PartialEscapeClosure.this.tool.getMetaAccessExtensionProvider())) {
                        int bytecount = PartialEscapeClosure.this.tool.getVirtualByteCount(entries, valueIndex2);
                        if (bytecount <= 1) continue;
                        if (virtualByteCount == null) {
                            virtualByteCount = new int[entryCount];
                        }
                        if (virtualKinds == null) {
                            virtualKinds = new JavaKind[entryCount];
                        }
                        if (virtualByteCount[valueIndex2] != 0 && virtualByteCount[valueIndex2] != bytecount) {
                            compatible = false;
                            break block0;
                        }
                        if (virtualKinds[valueIndex2] != null && virtualKinds[valueIndex2] != otherKind) {
                            compatible = false;
                            break block0;
                        }
                        virtualByteCount[valueIndex2] = bytecount;
                        virtualKinds[valueIndex2] = otherKind;
                        valueIndex2 = valueIndex2 + bytecount - 1;
                        continue;
                    }
                    assert (entryKind.getStackKind() == otherKind.getStackKind() || entryKind == JavaKind.Int && otherKind == JavaKind.Illegal || entryKind.getBitCount() >= otherKind.getBitCount()) : entryKind + " vs " + otherKind;
                }
            }
            if (compatible && twoSlotKinds != null) {
                block2: for (valueIndex = 0; valueIndex < entryCount; ++valueIndex) {
                    if (twoSlotKinds[valueIndex] == null) continue;
                    assert (valueIndex < virtual.entryCount() - 1 && virtual.entryKind(PartialEscapeClosure.this.tool.getMetaAccessExtensionProvider(), valueIndex) == JavaKind.Int && virtual.entryKind(PartialEscapeClosure.this.tool.getMetaAccessExtensionProvider(), valueIndex + 1) == JavaKind.Int);
                    for (i = 0; i < states.length; ++i) {
                        int object = getObject.applyAsInt(i);
                        ObjectState objectState = states[i].getObjectState(object);
                        ValueNode value = objectState.getEntry(valueIndex);
                        JavaKind valueKind = value.getStackKind();
                        if (valueKind == twoSlotKinds[valueIndex]) continue;
                        ValueNode nextValue = objectState.getEntry(valueIndex + 1);
                        if (value.isConstant() && value.asConstant().equals(JavaConstant.INT_0) && nextValue.isConstant() && nextValue.asConstant().equals(JavaConstant.INT_0)) {
                            PartialEscapeClosure.this.debug.log("Rewriting entry %s to constant of larger size", valueIndex);
                            states[i].setEntry(object, valueIndex, ConstantNode.defaultForKind(twoSlotKinds[valueIndex], this.graph()));
                            states[i].setEntry(object, valueIndex + 1, PartialEscapeClosure.this.tool.getIllegalConstant());
                            continue;
                        }
                        compatible = false;
                        break block2;
                    }
                }
            }
            if (compatible && virtualByteCount != null) {
                assert (twoSlotKinds == null);
                block4: for (valueIndex = 0; valueIndex < entryCount; ++valueIndex) {
                    if (virtualByteCount[valueIndex] == false) continue;
                    void byteCount = virtualByteCount[valueIndex];
                    for (int i3 = 0; i3 < states.length; ++i3) {
                        int object = getObject.applyAsInt(i3);
                        ObjectState objectState = states[i3].getObjectState(object);
                        if (PartialEscapeClosure.this.tool.isEntryDefaults(objectState, (int)byteCount, valueIndex)) {
                            states[i3].setEntry(object, valueIndex, ConstantNode.defaultForKind((JavaKind)virtualKinds[valueIndex]));
                            for (int illegalIndex = valueIndex + 1; illegalIndex < valueIndex + byteCount; ++illegalIndex) {
                                states[i3].setEntry(object, illegalIndex, PartialEscapeClosure.this.tool.getIllegalConstant());
                            }
                            continue;
                        }
                        if (PartialEscapeClosure.this.tool.getVirtualByteCount(objectState.getEntries(), valueIndex) == byteCount) continue;
                        compatible = false;
                        break block4;
                    }
                }
            }
            if (compatible) {
                ValueNode[] values = (ValueNode[])states[0].getObjectState(getObject.applyAsInt(0)).getEntries().clone();
                PhiNode[] phis = this.getValuePhis(virtual, virtual.entryCount());
                for (int valueIndex3 = 0; valueIndex3 < values.length; ++valueIndex3) {
                    for (int i4 = 1; i4 < states.length; ++i4) {
                        ValueNode field;
                        int object;
                        if (phis[valueIndex3] != null || (object = getObject.applyAsInt(i4)) == -1 || values[valueIndex3] == (field = states[i4].getObjectState(object).getEntry(valueIndex3))) continue;
                        phis[valueIndex3] = this.createValuePhi(values[valueIndex3].stamp(NodeView.DEFAULT).unrestricted());
                    }
                    if (phis[valueIndex3] != null && !phis[valueIndex3].stamp(NodeView.DEFAULT).isCompatible(values[valueIndex3].stamp(NodeView.DEFAULT))) {
                        phis[valueIndex3] = this.createValuePhi(values[valueIndex3].stamp(NodeView.DEFAULT).unrestricted());
                    }
                    if (twoSlotKinds == null || twoSlotKinds[valueIndex3] == null) continue;
                    phis[++valueIndex3] = null;
                    values[valueIndex3] = PartialEscapeClosure.this.tool.getIllegalConstant();
                }
                boolean materialized = false;
                for (int i5 = 0; i5 < values.length; ++i5) {
                    PhiNode phi = phis[i5];
                    if (phi == null) continue;
                    this.mergeEffects.addFloatingNode(phi, "virtualMergePhi");
                    if (virtual.entryKind(PartialEscapeClosure.this.tool.getMetaAccessExtensionProvider(), i5) == JavaKind.Object) {
                        materialized |= this.mergeObjectEntry(getObject, states, phi, i5);
                    } else {
                        for (int i2 = 0; i2 < states.length; ++i2) {
                            int object = getObject.applyAsInt(i2);
                            if (object == -1) {
                                this.setPhiInput(phi, i2, phi);
                                continue;
                            }
                            ObjectState state = states[i2].getObjectState(object);
                            if (!state.isVirtual()) break;
                            ValueNode entry = state.getEntry(i5);
                            this.setPhiInput(phi, i2, entry);
                        }
                    }
                    values[i5] = phi;
                }
                ((PartialEscapeBlockState)this.newState).addObject(resultObject, new ObjectState(values, states[0].getObjectState(getObject.applyAsInt(0)).getLocks(), ensureVirtual));
                return materialized;
            }
            PhiNode materializedValuePhi = this.getPhi(resultObject, StampFactory.forKind(JavaKind.Object));
            for (i = 0; i < states.length; ++i) {
                HIRBlock predecessor = this.getPredecessor(i);
                int object = getObject.applyAsInt(i);
                if (object == -1) {
                    this.setPhiInput(materializedValuePhi, i, materializedValuePhi);
                    continue;
                }
                if (!ensureVirtual && states[i].getObjectState(object).isVirtual()) {
                    states[i].getObjectState(object).setEnsureVirtualized(false);
                }
                PartialEscapeClosure.this.ensureMaterialized(states[i], object, predecessor.getEndNode(), (GraphEffectList)PartialEscapeClosure.this.blockEffects.get(predecessor), COUNTER_MATERIALIZATIONS_MERGE);
                this.setPhiInput(materializedValuePhi, i, states[i].getObjectState(object).getMaterializedValue());
            }
            ((PartialEscapeBlockState)this.newState).addObject(resultObject, new ObjectState(materializedValuePhi, null, ensureVirtual));
            return true;
        }

        private boolean mergeObjectEntry(IntUnaryOperator objectIdFunc, PartialEscapeBlockState<?>[] states, PhiNode phi, int entryIndex) {
            boolean materialized = false;
            for (int i = 0; i < states.length; ++i) {
                int object = objectIdFunc.applyAsInt(i);
                if (object == -1) {
                    this.setPhiInput(phi, i, phi);
                    continue;
                }
                ObjectState objectState = states[i].getObjectState(object);
                if (!objectState.isVirtual()) break;
                ValueNode entry = objectState.getEntry(entryIndex);
                if (entry instanceof VirtualObjectNode) {
                    VirtualObjectNode entryVirtual = (VirtualObjectNode)entry;
                    HIRBlock predecessor = this.getPredecessor(i);
                    materialized |= PartialEscapeClosure.this.ensureMaterialized(states[i], entryVirtual.getObjectId(), predecessor.getEndNode(), (GraphEffectList)PartialEscapeClosure.this.blockEffects.get(predecessor), COUNTER_MATERIALIZATIONS_MERGE);
                    objectState = states[i].getObjectState(object);
                    if (objectState.isVirtual()) {
                        entry = states[i].getObjectState(entryVirtual.getObjectId()).getMaterializedValue();
                        states[i].setEntry(object, entryIndex, entry);
                    }
                }
                this.setPhiInput(phi, i, entry);
            }
            return materialized;
        }

        private boolean processPhi(ValuePhiNode phi, PartialEscapeBlockState<?>[] states) {
            int virtualInputs = 0;
            boolean uniqueVirtualObject = true;
            boolean ensureVirtual = true;
            boolean selfReference = false;
            VirtualObjectNode[] virtualObjs = new VirtualObjectNode[states.length];
            for (int i = 0; i < states.length; ++i) {
                ValueNode alias = PartialEscapeClosure.this.getAlias(this.getPhiValueAt(phi, i));
                if (alias instanceof VirtualObjectNode) {
                    VirtualObjectNode virtual;
                    virtualObjs[i] = virtual = (VirtualObjectNode)alias;
                    ObjectState objectState = states[i].getObjectStateOptional(virtual);
                    if (objectState == null) {
                        assert (this.getPhiValueAt(phi, i) instanceof PhiNode) : "this should only happen for phi nodes";
                        return false;
                    }
                    if (!objectState.isVirtual()) continue;
                    if (virtualObjs[0] != alias) {
                        uniqueVirtualObject = false;
                    }
                    ensureVirtual &= objectState.getEnsureVirtualized();
                    ++virtualInputs;
                    continue;
                }
                if (alias != phi) continue;
                assert (i > 0);
                ++virtualInputs;
                selfReference = true;
            }
            if (virtualInputs == states.length) {
                VirtualObjectNode virtual;
                int i;
                if (uniqueVirtualObject) {
                    PartialEscapeClosure.this.addVirtualAlias(virtualObjs[0], phi);
                    this.mergeEffects.deleteNode(phi);
                    return false;
                }
                boolean compatible = true;
                VirtualObjectNode firstVirtual = virtualObjs[0];
                for (i = 0; i < states.length; ++i) {
                    virtual = virtualObjs[i];
                    if (virtual == null) continue;
                    if (!firstVirtual.type().equals(virtual.type()) || firstVirtual.entryCount() != virtual.entryCount()) {
                        compatible = false;
                        break;
                    }
                    if (states[0].getObjectState(firstVirtual).locksEqual(states[i].getObjectState(virtual))) continue;
                    compatible = false;
                    break;
                }
                if (compatible) {
                    for (i = 0; i < states.length; ++i) {
                        virtual = virtualObjs[i];
                        if (virtual == null || !virtual.hasIdentity() || !selfReference && this.isSingleUsageAllocation(this.getPhiValueAt(phi, i), virtualObjs, states[i])) continue;
                        compatible = false;
                        break;
                    }
                }
                if (compatible) {
                    VirtualObjectNode virtual2 = this.getValueObjectVirtual(phi, virtualObjs[0]);
                    this.mergeEffects.addFloatingNode(virtual2, "valueObjectNode");
                    this.mergeEffects.deleteNode(phi);
                    if (virtual2.getObjectId() == -1) {
                        int id = PartialEscapeClosure.this.virtualObjects.size();
                        PartialEscapeClosure.this.virtualObjects.add(virtual2);
                        virtual2.setObjectId(id);
                    }
                    int[] virtualObjectIds = new int[states.length];
                    for (int i2 = 0; i2 < states.length; ++i2) {
                        virtualObjectIds[i2] = virtualObjs[i2] == null ? (states[i2].getObjectStateOptional(virtual2) != null ? virtual2.getObjectId() : virtualObjs[0].getObjectId()) : virtualObjs[i2].getObjectId();
                        if (states[i2].getObjectState(virtualObjectIds[i2]).isVirtual()) continue;
                        compatible = false;
                        break;
                    }
                    if (compatible) {
                        boolean materialized = this.mergeObjectStates(virtual2.getObjectId(), virtualObjectIds, states);
                        PartialEscapeClosure.this.addVirtualAlias(virtual2, virtual2);
                        PartialEscapeClosure.this.addVirtualAlias(virtual2, phi);
                        return materialized;
                    }
                }
            }
            boolean materialized = false;
            if (virtualInputs > 0) {
                for (int i = 0; i < states.length; ++i) {
                    VirtualObjectNode virtual = virtualObjs[i];
                    if (virtual == null) continue;
                    HIRBlock predecessor = this.getPredecessor(i);
                    if (!ensureVirtual && states[i].getObjectState(virtual).isVirtual()) {
                        states[i].getObjectState(virtual).setEnsureVirtualized(false);
                    }
                    materialized |= PartialEscapeClosure.this.ensureMaterialized(states[i], virtual.getObjectId(), predecessor.getEndNode(), (GraphEffectList)PartialEscapeClosure.this.blockEffects.get(predecessor), COUNTER_MATERIALIZATIONS_PHI);
                }
            }
            for (int i = 0; i < states.length; ++i) {
                VirtualObjectNode virtual = virtualObjs[i];
                if (virtual == null) continue;
                this.setPhiInput(phi, i, PartialEscapeClosure.this.getAliasAndResolve(states[i], virtual));
            }
            return materialized;
        }

        private boolean isSingleUsageAllocation(ValueNode value, VirtualObjectNode[] virtualObjs, PartialEscapeBlockState<?> state) {
            if (!(value instanceof AllocatedObjectNode) || !value.hasExactlyOneUsage()) {
                return false;
            }
            VirtualObjectNode singleVirtual = null;
            for (int v = 0; v < virtualObjs.length; ++v) {
                if (!state.contains(virtualObjs[v])) continue;
                if (singleVirtual == null) {
                    singleVirtual = virtualObjs[v];
                    continue;
                }
                if (singleVirtual == virtualObjs[v]) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Final
    extends PartialEscapeClosure<PartialEscapeBlockState.Final> {
        public Final(StructuredGraph.ScheduleResult schedule, CoreProviders providers) {
            super(schedule, providers);
        }

        @Override
        protected PartialEscapeBlockState.Final getInitialState() {
            return new PartialEscapeBlockState.Final(this.tool.getOptions(), this.tool.getDebug());
        }

        @Override
        protected PartialEscapeBlockState.Final cloneState(PartialEscapeBlockState.Final oldState) {
            return new PartialEscapeBlockState.Final(oldState);
        }
    }
}

