/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.word;

import org.graalvm.compiler.word.Word;

final class HostedWord
extends Word {
    private static final int SMALL_FROM = -1;
    private static final int SMALL_TO = 100;
    private static final HostedWord[] smallCache = new HostedWord[102];
    private final long rawValue;

    private HostedWord(long rawValue) {
        this.rawValue = rawValue;
    }

    protected static Word boxLong(long val) {
        if (val >= -1L && val <= 100L) {
            return smallCache[(int)val - -1];
        }
        return new HostedWord(val);
    }

    @Override
    protected long unbox() {
        return this.rawValue;
    }

    @Override
    public String toString() {
        return "Word<" + this.rawValue + ">";
    }

    static {
        for (int i = -1; i <= 100; ++i) {
            HostedWord.smallCache[i - -1] = new HostedWord(i);
        }
    }
}

