/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.graphio;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Map;
import org.graalvm.graphio.GraphBlocks;
import org.graalvm.graphio.GraphElements;
import org.graalvm.graphio.GraphLocations;
import org.graalvm.graphio.GraphProtocol;
import org.graalvm.graphio.GraphStructure;
import org.graalvm.graphio.GraphTypes;

final class ProtocolImpl<Graph, Node, NodeClass, Port, Block, ResolvedJavaMethod, ResolvedJavaField, Signature, NodeSourcePosition, Location>
extends GraphProtocol<Graph, Node, NodeClass, Port, Block, ResolvedJavaMethod, ResolvedJavaField, Signature, NodeSourcePosition, Location> {
    private final GraphStructure<Graph, Node, NodeClass, Port> structure;
    private final GraphTypes types;
    private final GraphBlocks<Graph, Block, Node> blocks;
    private final GraphElements<ResolvedJavaMethod, ResolvedJavaField, Signature, NodeSourcePosition> elements;
    private final GraphLocations<ResolvedJavaMethod, NodeSourcePosition, Location> locations;

    ProtocolImpl(int major, int minor, boolean embedded, GraphStructure<Graph, Node, NodeClass, Port> structure, GraphTypes enums, GraphBlocks<Graph, Block, Node> blocks, GraphElements<ResolvedJavaMethod, ResolvedJavaField, Signature, NodeSourcePosition> elements, GraphLocations<ResolvedJavaMethod, NodeSourcePosition, Location> locs, WritableByteChannel channel) throws IOException {
        super(channel, major, minor, embedded);
        this.structure = structure;
        this.types = enums;
        this.blocks = blocks;
        this.elements = elements;
        this.locations = locs;
    }

    ProtocolImpl(GraphProtocol<?, ?, ?, ?, ?, ?, ?, ?, ?, ?> parent, GraphStructure<Graph, Node, NodeClass, Port> structure, GraphTypes enums, GraphBlocks<Graph, Block, Node> blocks, GraphElements<ResolvedJavaMethod, ResolvedJavaField, Signature, NodeSourcePosition> elements, GraphLocations<ResolvedJavaMethod, NodeSourcePosition, Location> locs) {
        super(parent);
        this.structure = structure;
        this.types = enums;
        this.blocks = blocks;
        this.elements = elements;
        this.locations = locs;
    }

    @Override
    protected Graph findGraph(Graph current, Object obj) {
        return this.structure.graph(current, obj);
    }

    @Override
    protected Node findNode(Object obj) {
        return this.structure.node(obj);
    }

    @Override
    protected NodeClass findNodeClass(Object obj) {
        return this.structure.nodeClass(obj);
    }

    @Override
    protected NodeClass findClassForNode(Node obj) {
        NodeClass clazz = this.structure.classForNode(obj);
        if (clazz != null && (this.findNodeClass(clazz) == null || this.findNode(clazz) != null)) {
            throw new IllegalStateException("classForNode method shall return node class representation rather than node: " + clazz);
        }
        return clazz;
    }

    @Override
    protected String findNameTemplate(NodeClass clazz) {
        return this.structure.nameTemplate(clazz);
    }

    @Override
    protected int findNodeId(Node n) {
        return this.structure.nodeId(n);
    }

    @Override
    protected boolean hasPredecessor(Node node) {
        return this.structure.nodeHasPredecessor(node);
    }

    @Override
    protected int findNodesCount(Graph info) {
        return this.structure.nodesCount(info);
    }

    @Override
    protected Iterable<? extends Node> findNodes(Graph info) {
        return this.structure.nodes(info);
    }

    @Override
    protected void findNodeProperties(Node node, Map<String, Object> props, Graph info) {
        this.structure.nodeProperties(info, node, props);
    }

    @Override
    protected Port findClassEdges(NodeClass nodeClass, boolean dumpInputs) {
        if (dumpInputs) {
            return this.structure.portInputs(nodeClass);
        }
        return this.structure.portOutputs(nodeClass);
    }

    @Override
    protected int findSize(Port edges) {
        return this.structure.portSize(edges);
    }

    @Override
    protected boolean isDirect(Port edges, int i) {
        return this.structure.edgeDirect(edges, i);
    }

    @Override
    protected String findName(Port edges, int i) {
        return this.structure.edgeName(edges, i);
    }

    @Override
    protected Object findType(Port edges, int i) {
        Object type = this.structure.edgeType(edges, i);
        if (this.findEnumOrdinal(type) < 0) {
            throw new IllegalStateException("edgeType method shall return an enum! Was: " + type);
        }
        return type;
    }

    @Override
    protected Collection<? extends Node> findNodes(Graph graph, Node node, Port port, int i) {
        return this.structure.edgeNodes(graph, node, port, i);
    }

    @Override
    protected Object findJavaClass(NodeClass clazz) {
        Object type = this.structure.nodeClassType(clazz);
        if (!(type instanceof Class) && this.findJavaTypeName(type) == null) {
            throw new IllegalStateException("nodeClassType method shall return a Java class (instance of Class)! Was: " + type);
        }
        return type;
    }

    @Override
    protected Object findEnumClass(Object enumValue) {
        return this.types.enumClass(enumValue);
    }

    @Override
    protected int findEnumOrdinal(Object obj) {
        return this.types.enumOrdinal(obj);
    }

    @Override
    protected String[] findEnumTypeValues(Object clazz) {
        return this.types.enumTypeValues(clazz);
    }

    @Override
    protected String findJavaTypeName(Object obj) {
        return this.types.typeName(obj);
    }

    @Override
    protected Collection<? extends Node> findBlockNodes(Graph info, Block block) {
        return this.blocks.blockNodes(info, block);
    }

    @Override
    protected int findBlockId(Block block) {
        return this.blocks.blockId(block);
    }

    @Override
    protected Collection<? extends Block> findBlocks(Graph graph) {
        return this.blocks.blocks(graph);
    }

    @Override
    protected Collection<? extends Block> findBlockSuccessors(Block block) {
        return this.blocks.blockSuccessors(block);
    }

    @Override
    protected ResolvedJavaMethod findMethod(Object obj) {
        return this.elements == null ? null : (ResolvedJavaMethod)this.elements.method(obj);
    }

    @Override
    protected byte[] findMethodCode(ResolvedJavaMethod method) {
        return this.elements.methodCode(method);
    }

    @Override
    protected int findMethodModifiers(ResolvedJavaMethod method) {
        return this.elements.methodModifiers(method);
    }

    @Override
    protected Signature findMethodSignature(ResolvedJavaMethod method) {
        return this.elements.methodSignature(method);
    }

    @Override
    protected String findMethodName(ResolvedJavaMethod method) {
        return this.elements.methodName(method);
    }

    @Override
    protected Object findMethodDeclaringClass(ResolvedJavaMethod method) {
        return this.elements.methodDeclaringClass(method);
    }

    @Override
    protected int findFieldModifiers(ResolvedJavaField field) {
        return this.elements.fieldModifiers(field);
    }

    @Override
    protected String findFieldTypeName(ResolvedJavaField field) {
        return this.elements.fieldTypeName(field);
    }

    @Override
    protected String findFieldName(ResolvedJavaField field) {
        return this.elements.fieldName(field);
    }

    @Override
    protected Object findFieldDeclaringClass(ResolvedJavaField field) {
        return this.elements.fieldDeclaringClass(field);
    }

    @Override
    protected ResolvedJavaField findJavaField(Object object) {
        return this.elements == null ? null : (ResolvedJavaField)this.elements.field(object);
    }

    @Override
    protected Signature findSignature(Object object) {
        return this.elements == null ? null : (Signature)this.elements.signature(object);
    }

    @Override
    protected int findSignatureParameterCount(Signature signature) {
        return this.elements.signatureParameterCount(signature);
    }

    @Override
    protected String findSignatureParameterTypeName(Signature signature, int index) {
        return this.elements.signatureParameterTypeName(signature, index);
    }

    @Override
    protected String findSignatureReturnTypeName(Signature signature) {
        return this.elements.signatureReturnTypeName(signature);
    }

    @Override
    protected NodeSourcePosition findNodeSourcePosition(Object object) {
        return this.elements == null ? null : (NodeSourcePosition)this.elements.nodeSourcePosition(object);
    }

    @Override
    protected ResolvedJavaMethod findNodeSourcePositionMethod(NodeSourcePosition pos) {
        return this.elements.nodeSourcePositionMethod(pos);
    }

    @Override
    protected NodeSourcePosition findNodeSourcePositionCaller(NodeSourcePosition pos) {
        return this.elements.nodeSourcePositionCaller(pos);
    }

    @Override
    protected int findNodeSourcePositionBCI(NodeSourcePosition pos) {
        return this.elements.nodeSourcePositionBCI(pos);
    }

    @Override
    protected Iterable<Location> findLocation(ResolvedJavaMethod method, int bci, NodeSourcePosition pos) {
        return this.locations.methodLocation(method, bci, pos);
    }

    @Override
    protected String findLocationFile(Location loc) throws IOException {
        URI u;
        if (loc == null) {
            return null;
        }
        try {
            u = this.locations.locationURI(loc);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        if (u == null) {
            return null;
        }
        if (u.getScheme() == null) {
            return u.getPath();
        }
        if ("file".equals(u.getScheme())) {
            return new File(u).getPath();
        }
        return null;
    }

    @Override
    protected int findLocationLine(Location loc) {
        return this.locations.locationLineNumber(loc);
    }

    @Override
    protected URI findLocationURI(Location loc) throws URISyntaxException {
        return this.locations.locationURI(loc);
    }

    @Override
    protected String findLocationLanguage(Location loc) {
        return this.locations.locationLanguage(loc);
    }

    @Override
    protected int findLocationStart(Location loc) {
        return this.locations.locationOffsetStart(loc);
    }

    @Override
    protected int findLocationEnd(Location loc) {
        return this.locations.locationOffsetEnd(loc);
    }

    @Override
    protected String formatTitle(Graph graph, int id, String format, Object ... args) {
        return String.format(format, args) + " [" + id + "]";
    }
}

