/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.graalvm.collections.Pair;

public final class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <T> Iterable<T> concat(Iterable<T> a, Iterable<T> b) {
        List<Iterable<T>> l = Arrays.asList(a, b);
        return CollectionsUtil.concat(l);
    }

    public static <T> Iterable<T> concat(final List<Iterable<T>> iterables) {
        for (Iterable<T> iterable : iterables) {
            Objects.requireNonNull(iterable);
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                if (iterables.size() == 0) {
                    return Collections.emptyIterator();
                }
                return new Iterator<T>(){
                    final Iterator<Iterable<T>> cursor;
                    Iterator<T> currentIterator;
                    {
                        this.cursor = iterables.iterator();
                        this.currentIterator = this.cursor.next().iterator();
                    }

                    private void advance() {
                        while (!this.currentIterator.hasNext() && this.cursor.hasNext()) {
                            this.currentIterator = this.cursor.next().iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        this.advance();
                        return this.currentIterator.hasNext();
                    }

                    @Override
                    public T next() {
                        this.advance();
                        return this.currentIterator.next();
                    }
                };
            }
        };
    }

    public static <T> boolean allMatch(T[] inputs, Predicate<T> predicate) {
        return CollectionsUtil.allMatch(Arrays.asList(inputs), predicate);
    }

    public static <T> boolean allMatch(Iterable<T> inputs, Predicate<T> predicate) {
        for (T t : inputs) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(T[] inputs, Predicate<T> predicate) {
        return CollectionsUtil.anyMatch(Arrays.asList(inputs), predicate);
    }

    public static <T> boolean anyMatch(Iterable<T> inputs, Predicate<T> predicate) {
        for (T t : inputs) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> filterToList(List<T> inputs, Predicate<? super T> predicate) {
        return CollectionsUtil.filterToList(inputs, predicate, ArrayList::new);
    }

    public static <T> List<T> filterToList(List<T> inputs, Predicate<? super T> predicate, Supplier<List<T>> listGenerator) {
        List<T> resultList = listGenerator.get();
        for (T t : inputs) {
            if (!predicate.test(t)) continue;
            resultList.add(t);
        }
        return resultList;
    }

    public static <T, R> R[] filterAndMapToArray(T[] inputs, Predicate<? super T> predicate, Function<? super T, ? extends R> mapper, IntFunction<R[]> arrayGenerator) {
        ArrayList<R> resultList = new ArrayList<R>();
        for (T t : inputs) {
            if (!predicate.test(t)) continue;
            resultList.add(mapper.apply(t));
        }
        return resultList.toArray(arrayGenerator.apply(resultList.size()));
    }

    public static <T, R> R[] mapToArray(T[] inputs, Function<? super T, ? extends R> mapper, IntFunction<R[]> arrayGenerator) {
        return CollectionsUtil.mapToArray(Arrays.asList(inputs), mapper, arrayGenerator);
    }

    public static <T, R> R[] mapToArray(Collection<T> inputs, Function<? super T, ? extends R> mapper, IntFunction<R[]> arrayGenerator) {
        R[] result = arrayGenerator.apply(inputs.size());
        int idx = 0;
        for (T t : inputs) {
            result[idx++] = mapper.apply(t);
        }
        return result;
    }

    public static <T, R> String mapAndJoin(T[] inputs, Function<? super T, ? extends R> mapper, String delimiter) {
        return CollectionsUtil.mapAndJoin(Arrays.asList(inputs), mapper, delimiter, "", "");
    }

    public static <T, R> String mapAndJoin(T[] inputs, Function<? super T, ? extends R> mapper, String delimiter, String prefix) {
        return CollectionsUtil.mapAndJoin(Arrays.asList(inputs), mapper, delimiter, prefix, "");
    }

    public static <T, R> String mapAndJoin(T[] inputs, Function<? super T, ? extends R> mapper, String delimiter, String prefix, String suffix) {
        return CollectionsUtil.mapAndJoin(Arrays.asList(inputs), mapper, delimiter, prefix, suffix);
    }

    public static <T, R> String mapAndJoin(Iterable<T> inputs, Function<? super T, ? extends R> mapper, String delimiter) {
        return CollectionsUtil.mapAndJoin(inputs, mapper, delimiter, "", "");
    }

    public static <T, R> String mapAndJoin(Iterable<T> inputs, Function<? super T, ? extends R> mapper, String delimiter, String prefix) {
        return CollectionsUtil.mapAndJoin(inputs, mapper, delimiter, prefix, "");
    }

    public static <T, R> String mapAndJoin(Iterable<T> inputs, Function<? super T, ? extends R> mapper, String delimiter, String prefix, String suffix) {
        StringBuilder strb = new StringBuilder();
        String sep = "";
        for (T t : inputs) {
            strb.append(sep).append(prefix).append(mapper.apply(t)).append(suffix);
            sep = delimiter;
        }
        return strb.toString();
    }

    public static <L, R> Iterable<Pair<L, R>> zipLongest(Iterable<L> lhs, Iterable<R> rhs) {
        final Iterator lhsIterator = lhs.iterator();
        final Iterator rhsIterator = rhs.iterator();
        return () -> new Iterator<Pair<L, R>>(){

            @Override
            public boolean hasNext() {
                return lhsIterator.hasNext() || rhsIterator.hasNext();
            }

            @Override
            public Pair<L, R> next() {
                if (lhsIterator.hasNext() && rhsIterator.hasNext()) {
                    return Pair.create(lhsIterator.next(), rhsIterator.next());
                }
                if (lhsIterator.hasNext()) {
                    return Pair.createLeft(lhsIterator.next());
                }
                return Pair.createRight(rhsIterator.next());
            }
        };
    }

    public static <L, R> Iterable<Pair<L, R>> cartesianProduct(final Iterable<L> lhs, final Iterable<R> rhs) {
        return () -> new Iterator<Pair<L, R>>(){
            private L lhsLast = null;
            private final Iterator<L> lhsIterator = lhs.iterator();
            private boolean rhsReachedEnd = true;
            private Iterator<R> rhsIterator = null;

            @Override
            public boolean hasNext() {
                if (this.rhsReachedEnd) {
                    if (!this.lhsIterator.hasNext()) {
                        return false;
                    }
                    this.lhsLast = this.lhsIterator.next();
                    this.rhsIterator = rhs.iterator();
                    this.rhsReachedEnd = !this.rhsIterator.hasNext();
                    return !this.rhsReachedEnd;
                }
                return true;
            }

            @Override
            public Pair<L, R> next() {
                if (this.rhsReachedEnd) {
                    this.lhsLast = this.lhsIterator.next();
                    this.rhsIterator = rhs.iterator();
                }
                Object rhsItem = this.rhsIterator.next();
                this.rhsReachedEnd = !this.rhsIterator.hasNext();
                return Pair.create(this.lhsLast, rhsItem);
            }
        };
    }
}

