/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.util.json;

import java.util.List;
import java.util.Map;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public class JSONFormatter {
    private static final String DEFAULT_INDENT = "    ";
    private static final String EMPTY_STRING = "";
    private static final String DOUBLE_QUOTE_ESCAPED = "\\\"";
    private static final String BACKSLASH_ESCAPED = "\\\\";
    private static final String BACKSPACE_ESCAPED = "\\b";
    private static final String FORM_FEED_ESCAPED = "\\f";
    private static final String NEWLINE_ESCAPED = "\\n";
    private static final String CARRIAGE_RETURN_ESCAPED = "\\r";
    private static final String TAB_ESCAPED = "\\t";
    private static final String UNICODE_CHARACTER_PREFIX = "\\u00";
    private static final char LEFT_CURLY_BRACKET = '{';
    private static final char RIGHT_CURLY_BRACKET = '}';
    private static final char LEFT_SQUARE_BRACKET = '[';
    private static final char RIGHT_SQUARE_BRACKET = ']';
    private static final String COMMA_NEWLINE = ",\n";
    private static final String COMMA_SPACE = ", ";
    private static final String COLON_SPACE = ": ";
    private static final char NEWLINE = '\n';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char BACKSLASH = '\\';
    private static final char BACKSPACE = '\b';
    private static final char FORM_FEED = '\f';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char TAB = '\t';
    private static final char SPACE = ' ';

    public static String formatJSON(EconomicMap<String, Object> map) {
        return JSONFormatter.formatJSON(map, false);
    }

    public static String formatJSON(EconomicMap<String, Object> map, boolean indent) {
        StringBuilder sb = new StringBuilder();
        JSONFormatter.appendTo(sb, map, indent ? DEFAULT_INDENT : null, EMPTY_STRING);
        return sb.toString();
    }

    public static String formatJSON(List<?> elements) {
        return JSONFormatter.formatJSON(elements, false);
    }

    public static String formatJSON(List<?> elements, boolean indent) {
        StringBuilder sb = new StringBuilder();
        JSONFormatter.appendTo(sb, elements, indent ? DEFAULT_INDENT : null, EMPTY_STRING);
        return sb.toString();
    }

    private static String quote(CharSequence value) {
        StringBuilder builder = new StringBuilder(value.length() + 2);
        builder.append('\"');
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    builder.append(DOUBLE_QUOTE_ESCAPED);
                    continue block9;
                }
                case '\\': {
                    builder.append(BACKSLASH_ESCAPED);
                    continue block9;
                }
                case '\b': {
                    builder.append(BACKSPACE_ESCAPED);
                    continue block9;
                }
                case '\f': {
                    builder.append(FORM_FEED_ESCAPED);
                    continue block9;
                }
                case '\n': {
                    builder.append(NEWLINE_ESCAPED);
                    continue block9;
                }
                case '\r': {
                    builder.append(CARRIAGE_RETURN_ESCAPED);
                    continue block9;
                }
                case '\t': {
                    builder.append(TAB_ESCAPED);
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        builder.append(UNICODE_CHARACTER_PREFIX);
                        builder.append(Character.forDigit(c >> 4 & 0xF, 16));
                        builder.append(Character.forDigit(c & 0xF, 16));
                        continue block9;
                    }
                    builder.append(c);
                }
            }
        }
        builder.append('\"');
        return builder.toString();
    }

    static void appendValue(StringBuilder sb, Object value, String indent, String currentIndent) {
        if (value instanceof EconomicMap) {
            JSONFormatter.appendTo(sb, (EconomicMap)value, indent, currentIndent);
        } else if (value instanceof List) {
            JSONFormatter.appendTo(sb, (List)value, indent, currentIndent);
        } else if (value instanceof Number || value instanceof Boolean || value == null) {
            sb.append(value);
        } else {
            if (value instanceof Map) {
                throw new IllegalArgumentException(value + " must use EconomicMap");
            }
            sb.append(JSONFormatter.quote(String.valueOf(value)));
        }
    }

    static void appendTo(StringBuilder sb, List<?> contents, String indent, String currentIndent) {
        String newIndent = indent + currentIndent;
        sb.append('[');
        if (indent != null) {
            sb.append('\n');
        }
        boolean comma = false;
        for (Object value : contents) {
            if (comma) {
                if (indent != null) {
                    sb.append(COMMA_NEWLINE);
                } else {
                    sb.append(COMMA_SPACE);
                }
            }
            if (indent != null) {
                sb.append(newIndent);
            }
            JSONFormatter.appendValue(sb, value, indent, newIndent);
            comma = true;
        }
        if (indent != null) {
            sb.append('\n');
            sb.append(currentIndent);
        }
        sb.append(']');
    }

    static void appendTo(StringBuilder sb, EconomicMap<?, ?> contents, String indent, String currentIndent) {
        String newIndent = indent + currentIndent;
        if (indent != null) {
            sb.append(currentIndent);
        }
        sb.append('{');
        if (indent != null) {
            sb.append('\n');
        }
        boolean comma = false;
        MapCursor cursor = contents.getEntries();
        while (cursor.advance()) {
            if (comma) {
                if (indent != null) {
                    sb.append(COMMA_NEWLINE);
                } else {
                    sb.append(COMMA_SPACE);
                }
            }
            if (indent != null) {
                sb.append(newIndent);
            }
            sb.append(JSONFormatter.quote((String)cursor.getKey()));
            sb.append(COLON_SPACE);
            JSONFormatter.appendValue(sb, cursor.getValue(), indent, newIndent);
            comma = true;
        }
        if (indent != null) {
            sb.append('\n');
            sb.append(currentIndent);
        }
        sb.append('}');
    }
}

